﻿/*
Run this script to update the MET/CONNECT database from 3.6.0 to 3.7.0

You are recommended to back up your database before running this script

*/
SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '2.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 2.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.0.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.0.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.1.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.1.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.2.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.2.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.3.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.3.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.4.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.4.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.5.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.5.0 is missing. ***', 20,-1) WITH LOG
END
GO

IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE cVersion = '3.6.0' )
BEGIN
	RAISERROR(N'*** Database script for version 3.6.0 is missing. ***', 20,-1) WITH LOG
END
GO

-- set database compatibility level to SQL Server 2012
DECLARE @comp NVARCHAR(max);
SET @comp = N'ALTER DATABASE [' + (SELECT DB_NAME()) + ']
SET COMPATIBILITY_LEVEL = 110 '
EXEC sp_executesql @comp
GO

-- No need to process if we have a 3.7.0 version record
IF NOT EXISTS (SELECT * FROM [dbo].[Version] WHERE nVersionUID = 'D38C0F88-E7B4-4007-A352-FA3ADE1F22E5')
BEGIN
	BEGIN TRANSACTION

	-- get the current collation and switch it to case-sensitive
	DECLARE @sql NVARCHAR(max);
	DECLARE @coll_cs NVARCHAR(100);
	SELECT @coll_cs = collation_name FROM sys.databases WHERE name = (SELECT DB_NAME());
	SELECT @coll_cs = REPLACE(@coll_cs, N'CI', N'CS');


	-->>MTM-5929<<--
	-- FillgrdRecipients-Band1          
	-- cel                              
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '58DE0869-3A7D-4404-9530-C10BD8842730' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '58DE0869-3A7D-4404-9530-C10BD8842730' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'E4041F5B-69F7-4E8D-9A16-7534215D15E4' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'E4041F5B-69F7-4E8D-9A16-7534215D15E4' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6E422996-E954-4D9B-81CA-6DAA5702A367' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6E422996-E954-4D9B-81CA-6DAA5702A367' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '255038F8-AADC-4464-B315-CF79E8D420B0' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '255038F8-AADC-4464-B315-CF79E8D420B0' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'D1412FFB-7A5E-4616-BF29-7EA815B130B3' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'D1412FFB-7A5E-4616-BF29-7EA815B130B3' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'A17A3E8E-3BA3-4AFC-A711-DB2AD29BBFB1' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'A17A3E8E-3BA3-4AFC-A711-DB2AD29BBFB1' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1C70622D-9E19-4C34-9CDF-2A1C7E111079' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1C70622D-9E19-4C34-9CDF-2A1C7E111079' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'FD5BEE2D-29B0-428C-86B6-171666923BAF' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'FD5BEE2D-29B0-428C-86B6-171666923BAF' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5FE8E767-2119-4954-8C84-8E0C047CDCAE' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5FE8E767-2119-4954-8C84-8E0C047CDCAE' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'CEC4CF70-DF7A-42A7-A565-DDC7FAEC2D43' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'CEC4CF70-DF7A-42A7-A565-DDC7FAEC2D43' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'EF277CE4-9741-47B1-AE29-76B82FD247C2' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'EF277CE4-9741-47B1-AE29-76B82FD247C2' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'C894F0D0-9E4C-44E3-9243-6038042EE72E' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'C894F0D0-9E4C-44E3-9243-6038042EE72E' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		
		
	-- FillgrdRecipients-Band0
	-- cel
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0447294F-1F4C-4FD2-A526-DE89E004F1E6' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0447294F-1F4C-4FD2-A526-DE89E004F1E6' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7EB898C6-64B3-4076-B449-932685DA60E0' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7EB898C6-64B3-4076-B449-932685DA60E0' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '62F88322-9C21-44A9-B4A1-DE3C1389097B' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '62F88322-9C21-44A9-B4A1-DE3C1389097B' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0452A07E-42C2-4307-9963-0535A732F0F8' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0452A07E-42C2-4307-9963-0535A732F0F8' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '74A03BEB-0702-4D35-B8D2-C84B138572DA' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '74A03BEB-0702-4D35-B8D2-C84B138572DA' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-- FillgrdEmailContacts
	-- cel
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '194F1748-199E-4E84-B1A7-5E875EF92CEB' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '194F1748-199E-4E84-B1A7-5E875EF92CEB' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '12B9D384-747F-47B3-A2EA-FCA368D4D937' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '12B9D384-747F-47B3-A2EA-FCA368D4D937' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'EBD7E427-7A8A-4122-9AD7-FA8D2B35517E' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'EBD7E427-7A8A-4122-9AD7-FA8D2B35517E' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '80481F34-0396-47EF-B11D-7A0DDA3C1D80' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '80481F34-0396-47EF-B11D-7A0DDA3C1D80' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '25492DD0-14C5-4C36-BE15-90F3DB9EA684' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '25492DD0-14C5-4C36-BE15-90F3DB9EA684' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'F89B9DF5-B308-4530-807D-BC6073529B4E' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'F89B9DF5-B308-4530-807D-BC6073529B4E' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7928D804-8AB1-4414-A605-0849FC6EB00F' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7928D804-8AB1-4414-A605-0849FC6EB00F' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '3321C035-D763-468A-AB44-0B2C5AFB0F3C' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '3321C035-D763-468A-AB44-0B2C5AFB0F3C' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4235DA50-92D2-4D37-AC5E-9AD1712423F8' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4235DA50-92D2-4D37-AC5E-9AD1712423F8' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '320B0B1D-CDC2-4B4E-8538-71B7FE2AD636' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '320B0B1D-CDC2-4B4E-8538-71B7FE2AD636' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'DAE766BB-AA4E-484C-A92A-14DEDD3FD6BD' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'DAE766BB-AA4E-484C-A92A-14DEDD3FD6BD' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'DAE8F6C8-96E3-4CE8-9C78-A4B94055BAFE' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'DAE8F6C8-96E3-4CE8-9C78-A4B94055BAFE' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'D27CA7C2-CE91-4CD8-AC92-712F848AF812' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'D27CA7C2-CE91-4CD8-AC92-712F848AF812' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-- FillGrdFacilityContactLink
	-- cel
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5DD59F4D-51FE-4AF9-B321-9156A1D420F3' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5DD59F4D-51FE-4AF9-B321-9156A1D420F3' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'F1857155-BA31-45F7-B484-84531E4698F7' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'F1857155-BA31-45F7-B484-84531E4698F7' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '03DF6425-F992-484E-ACD5-79AF51F375F8' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '03DF6425-F992-484E-ACD5-79AF51F375F8' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '76AF81CE-C519-4290-B382-FF4F34A531A1' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '76AF81CE-C519-4290-B382-FF4F34A531A1' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-- GetEscalationContacts
	-- cel
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5A9636D6-526D-43D9-AC2C-9EFAB72A46C7' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '5A9636D6-526D-43D9-AC2C-9EFAB72A46C7' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'D262033C-F9AF-46F9-AE35-3DFF0F78B2BD' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'D262033C-F9AF-46F9-AE35-3DFF0F78B2BD' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4E2F2A16-3916-4D7F-98B9-68B72E30B90B' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '4E2F2A16-3916-4D7F-98B9-68B72E30B90B' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	                                                                                                                                                                        
	-- Escalation summary                                                                                                                                                   
	-- cel                                                                                                                                                                  
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '456B5A56-CD4C-4230-A057-400D29E2C505' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '456B5A56-CD4C-4230-A057-400D29E2C505' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8FED98E2-D9DC-4A73-960F-E56A4D29E753' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '8FED98E2-D9DC-4A73-960F-E56A4D29E753' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '28DA009B-39AF-4626-AF81-310A99911854' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '28DA009B-39AF-4626-AF81-310A99911854' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	                                                                                                                                                                          
	-- BuildEmailSummaryPastDue                                                                                                                                               
	-- cel                                                                                                                                                                    
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1F314C67-30CE-47FD-B900-16A5B350CC93' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '1F314C67-30CE-47FD-B900-16A5B350CC93' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '24AD05A0-29D2-44A6-A93A-E1B7ED0DDA53' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '24AD05A0-29D2-44A6-A93A-E1B7ED0DDA53' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'B9917345-4B96-41CB-B656-23D3232D588C' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'B9917345-4B96-41CB-B656-23D3232D588C' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	                                                                                                                                                                          
	-- BuildEmailSummary                                                                                                                                                      
	-- cel                                                                                                                                                                    
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '866B3B5B-0CD3-4CD3-B0FA-0ED0B95ED562' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '866B3B5B-0CD3-4CD3-B0FA-0ED0B95ED562' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0A1146A4-A6F3-4BA7-9BA8-C09C08FDC386' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0A1146A4-A6F3-4BA7-9BA8-C09C08FDC386' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'A3CC43D8-7ADF-4763-9AC3-F69F6A2C559A' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'A3CC43D8-7ADF-4763-9AC3-F69F6A2C559A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	                                                                                                                                                                          
	-- BuildEmailReport                                                                                                                                                       
	-- cel                                                                                                                                                                    
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '2BCD6C65-4E30-44BF-93F4-8433A6F497D0' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '2BCD6C65-4E30-44BF-93F4-8433A6F497D0' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6F03A98C-F1F4-4B5E-BDE9-DCDEFDA2CA6E' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '6F03A98C-F1F4-4B5E-BDE9-DCDEFDA2CA6E' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'CCF1CD5B-5CAE-477C-9326-372EC0C064B7' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'CCF1CD5B-5CAE-477C-9326-372EC0C064B7' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '400CC7AE-F01B-47D1-A3DF-0AB7B8C187FA' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '400CC7AE-F01B-47D1-A3DF-0AB7B8C187FA' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'AA0D3010-457C-42B8-A58A-6F0D6EA0E667' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'AA0D3010-457C-42B8-A58A-6F0D6EA0E667' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7B5BF226-5DAF-47C5-A558-9D0EE6D8C4BE' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '7B5BF226-5DAF-47C5-A558-9D0EE6D8C4BE' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0CD91DD1-94C1-4EBA-B2F1-40C21768FE86' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = '0CD91DD1-94C1-4EBA-B2F1-40C21768FE86' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'BA6A4D08-5428-4948-BAB8-16F6B202DEA5' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'BA6A4D08-5428-4948-BAB8-16F6B202DEA5' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'CE526852-EE03-4B2A-A632-60A2C9260B0C' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'CE526852-EE03-4B2A-A632-60A2C9260B0C' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'C765A96A-7CBA-4899-888A-5E5952ABB2DC' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'C765A96A-7CBA-4899-888A-5E5952ABB2DC' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'B31AE6EF-AD99-49A1-B600-D2620BCBBC12' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'B31AE6EF-AD99-49A1-B600-D2620BCBBC12' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'E2DE699E-182F-45CC-8AE7-AB656CA27C9A' ) BEGIN DELETE FROM [dbo].[ContextElementLink] WHERE nContextElementLinkUID = 'E2DE699E-182F-45CC-8AE7-AB656CA27C9A' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-- FillgrdRecipients-Band1
	-- context
	IF EXISTS ( SELECT * FROM [dbo].[Context] WHERE nContextUID = 'A3AC17CF-3CCA-449A-BDFB-37F41DC1B229' ) BEGIN DELETE FROM [dbo].[Context] WHERE nContextUID = 'A3AC17CF-3CCA-449A-BDFB-37F41DC1B229' END

	-- FillgrdRecipients-Band0
	-- context
	IF EXISTS ( SELECT * FROM [dbo].[Context] WHERE nContextUID = '133182E2-50BE-4D0A-BD05-2FF948F3A6A0' ) BEGIN DELETE FROM [dbo].[Context] WHERE nContextUID = '133182E2-50BE-4D0A-BD05-2FF948F3A6A0' END

	-- FillgrdEmailContacts
	-- context
	IF EXISTS ( SELECT * FROM [dbo].[Context] WHERE nContextUID = '21CCDAF4-CBE0-45D8-B9C0-DD96B85236FF' ) BEGIN DELETE FROM [dbo].[Context] WHERE nContextUID = '21CCDAF4-CBE0-45D8-B9C0-DD96B85236FF' END
	                                                                                                                                                                                                   
	-- GetEscalationContacts                                                                                                                                                                           
	-- context                                                                                                                                                                                         
	IF EXISTS ( SELECT * FROM [dbo].[Context] WHERE nContextUID = '5E00D0F6-CA26-44F8-84E5-557AB37802BA' ) BEGIN DELETE FROM [dbo].[Context] WHERE nContextUID = '5E00D0F6-CA26-44F8-84E5-557AB37802BA' END
	                                                                                                                                                                                                   
	-- Escalation summary                                                                                                                                                                              
	-- context                                                                                                                                                                                         
	IF EXISTS ( SELECT * FROM [dbo].[Context] WHERE nContextUID = '77076BEE-1734-4020-8636-2F83A7F984AA' ) BEGIN DELETE FROM [dbo].[Context] WHERE nContextUID = '77076BEE-1734-4020-8636-2F83A7F984AA' END
	                                                                                                                                                                                                   
	-- BuildEmailSummaryPastDue                                                                                                                                                                        
	-- context                                                                                                                                                                                         
	IF EXISTS ( SELECT * FROM [dbo].[Context] WHERE nContextUID = '994375C0-513B-4582-9DC9-DF8C08E8779A' ) BEGIN DELETE FROM [dbo].[Context] WHERE nContextUID = '994375C0-513B-4582-9DC9-DF8C08E8779A' END
	                                                                                                                                                                                                   
	-- BuildEmailSummary                                                                                                                                                                               
	-- context                                                                                                                                                                                         
	IF EXISTS ( SELECT * FROM [dbo].[Context] WHERE nContextUID = '81F61E26-DD62-4DBE-872B-6103B2FC7A31' ) BEGIN DELETE FROM [dbo].[Context] WHERE nContextUID = '81F61E26-DD62-4DBE-872B-6103B2FC7A31' END
	                                                                                                                                                                                                   
	-- BuildEmailReport                                                                                                                                                                                
	-- context                                                                                                                                                                                         
	IF EXISTS ( SELECT * FROM [dbo].[Context] WHERE nContextUID = '93EF2D72-8D04-4273-965D-42A412097693' ) BEGIN DELETE FROM [dbo].[Context] WHERE nContextUID = '93EF2D72-8D04-4273-965D-42A412097693' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-- ce
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'B2D65600-9060-4C5E-962C-CD1688D2BF63' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'B2D65600-9060-4C5E-962C-CD1688D2BF63' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E4586E8B-21A2-4A57-8B2A-7FFF9537A13B' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E4586E8B-21A2-4A57-8B2A-7FFF9537A13B' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'A1C3A7C9-C39C-44F8-ADD6-FA6991275E39' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'A1C3A7C9-C39C-44F8-ADD6-FA6991275E39' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F9EAF61B-63DA-471D-83BB-9D48BF9E5255' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F9EAF61B-63DA-471D-83BB-9D48BF9E5255' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '84F6A1F9-8443-41BE-8F1F-5A8CCEDEE3CA' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '84F6A1F9-8443-41BE-8F1F-5A8CCEDEE3CA' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'DA3893EB-6AE8-492A-8659-CB45C7145A5D' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'DA3893EB-6AE8-492A-8659-CB45C7145A5D' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F1C08B2B-E744-42F2-9B5E-554FD2A119B0' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F1C08B2B-E744-42F2-9B5E-554FD2A119B0' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '451319A3-2351-42D2-85AA-7AB49F3D3512' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '451319A3-2351-42D2-85AA-7AB49F3D3512' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '6D03F2FD-3303-4C9D-8B45-D96B12CA044C' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '6D03F2FD-3303-4C9D-8B45-D96B12CA044C' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '97EDADEB-1F77-4919-95C0-4E76CCB5FF5C' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '97EDADEB-1F77-4919-95C0-4E76CCB5FF5C' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '76175DA7-29A9-4BED-97D4-79265168596A' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '76175DA7-29A9-4BED-97D4-79265168596A' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'C57BF32F-7084-47E6-8604-1B7969AB38E8' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'C57BF32F-7084-47E6-8604-1B7969AB38E8' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E0113836-F61C-41F1-B78B-29BD7D327D14' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E0113836-F61C-41F1-B78B-29BD7D327D14' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E3D40753-1549-4A69-BD33-8B69398E2296' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E3D40753-1549-4A69-BD33-8B69398E2296' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '1FA06139-DF12-4099-A646-0B40CC9AEE43' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '1FA06139-DF12-4099-A646-0B40CC9AEE43' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E2BDA84E-13E7-4CB7-8267-0BEB6867DF63' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E2BDA84E-13E7-4CB7-8267-0BEB6867DF63' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E035E6C0-5A0B-461E-8E61-6EA37D5BD00E' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'E035E6C0-5A0B-461E-8E61-6EA37D5BD00E' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '66047E4A-1C58-438E-AB69-E4B9C6877EC3' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '66047E4A-1C58-438E-AB69-E4B9C6877EC3' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'B33EB41E-BD08-469B-AFD8-D907F2E45DC9' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'B33EB41E-BD08-469B-AFD8-D907F2E45DC9' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '44F8DF72-75C0-4641-B9F5-E2AE69E8BA1D' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '44F8DF72-75C0-4641-B9F5-E2AE69E8BA1D' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '1A67D6C4-7A2C-4A59-AF0E-6781BE1EBC95' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '1A67D6C4-7A2C-4A59-AF0E-6781BE1EBC95' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'D0B56552-AB28-4C39-A523-3A562D08377E' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'D0B56552-AB28-4C39-A523-3A562D08377E' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '796FCF62-5A26-4CC6-AF94-AEB5196804B2' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '796FCF62-5A26-4CC6-AF94-AEB5196804B2' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7686544F-FB45-4D7D-8101-A557C00F6876' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '7686544F-FB45-4D7D-8101-A557C00F6876' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'D795446E-DE47-4037-9849-2ABD52119E0A' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'D795446E-DE47-4037-9849-2ABD52119E0A' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'C689038D-DA83-47C9-8888-16044D39888E' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'C689038D-DA83-47C9-8888-16044D39888E' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '3345157C-8C2F-4642-82FD-E0AC20356A09' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '3345157C-8C2F-4642-82FD-E0AC20356A09' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F0DD129C-FC96-4D79-81F7-BFA96336F354' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F0DD129C-FC96-4D79-81F7-BFA96336F354' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '346CD081-311F-4A1A-91CD-ED65CEB7A9A5' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '346CD081-311F-4A1A-91CD-ED65CEB7A9A5' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'D0846C5C-F1A5-4C76-99B7-B46A3408935F' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'D0846C5C-F1A5-4C76-99B7-B46A3408935F' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F34918A3-8C82-42E6-A9A6-EF3FA8638CED' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = 'F34918A3-8C82-42E6-A9A6-EF3FA8638CED' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '953991C4-84BD-46E1-8807-C2D0F9107B8D' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '953991C4-84BD-46E1-8807-C2D0F9107B8D' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '4BF4DB64-D003-4675-B32D-A71B1137EAB1' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '4BF4DB64-D003-4675-B32D-A71B1137EAB1' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '6072F5AF-72D7-4AC7-9AD5-B0636301B1C3' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '6072F5AF-72D7-4AC7-9AD5-B0636301B1C3' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '7B179964-CC87-4B3E-9632-D76C8CC5C52C' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '7B179964-CC87-4B3E-9632-D76C8CC5C52C' END
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = '831FCABB-87B2-4F5B-98C6-07FD0AEF0D82' ) BEGIN DELETE FROM [dbo].[ContextElements] WHERE nContextElementUID = '831FCABB-87B2-4F5B-98C6-07FD0AEF0D82' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	-- set width of Facility Name field on FillGrdFacilityContactLink context
	IF EXISTS ( SELECT * FROM [dbo].[ContextElements] WHERE nContextElementUID = 'DA7C039E-E964-4ABD-9691-4A946F2AE4A0' ) BEGIN UPDATE [dbo].[ContextElements] SET nWidth = 400 WHERE nContextElementUID = 'DA7C039E-E964-4ABD-9691-4A946F2AE4A0' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	IF EXISTS ( SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '523AC279-4C6A-4FB8-B429-40CA4DF89146' ) BEGIN DELETE FROM [dbo].[UCIData] WHERE nUCIDataUID = '523AC279-4C6A-4FB8-B429-40CA4DF89146' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	IF EXISTS ( SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '963F23D2-5784-4F18-91BC-B7BA36CC036F' ) BEGIN DELETE FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '963F23D2-5784-4F18-91BC-B7BA36CC036F' END
	IF EXISTS ( SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '5062DEFC-ACE9-49A8-8B30-80D5E1912C8B' ) BEGIN DELETE FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '5062DEFC-ACE9-49A8-8B30-80D5E1912C8B' END
	IF EXISTS ( SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = 'DAD90605-08FD-4432-9F37-FDA8191C11B6' ) BEGIN DELETE FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = 'DAD90605-08FD-4432-9F37-FDA8191C11B6' END
	IF EXISTS ( SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '56A6EA61-125D-4FC8-B1CB-6DBA2EBAE806' ) BEGIN DELETE FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '56A6EA61-125D-4FC8-B1CB-6DBA2EBAE806' END
	IF EXISTS ( SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '53A02866-CFB7-4F3D-A6A7-9C97C50501AA' ) BEGIN DELETE FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '53A02866-CFB7-4F3D-A6A7-9C97C50501AA' END
	IF EXISTS ( SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '1FD56F68-CF18-4813-A0D9-D9DF031FF3A9' ) BEGIN DELETE FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '1FD56F68-CF18-4813-A0D9-D9DF031FF3A9' END
	IF EXISTS ( SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '72D89488-B67A-403E-A7CF-16561920DCF7' ) BEGIN DELETE FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '72D89488-B67A-403E-A7CF-16561920DCF7' END
	IF EXISTS ( SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = 'D313802A-080C-41BE-B3F1-6E20717A2B6A' ) BEGIN DELETE FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = 'D313802A-080C-41BE-B3F1-6E20717A2B6A' END
	IF EXISTS ( SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = 'AC0A61BF-D989-4760-BBF6-A7D49EF29AD3' ) BEGIN DELETE FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = 'AC0A61BF-D989-4760-BBF6-A7D49EF29AD3' END

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION                                
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-->>MTM-8666<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '9A1BE408-9C08-409A-B71B-2AA61F0DDC6C')
	BEGIN
		PRINT N'Adding System Default'

		INSERT INTO [dbo].[SystemDefaults] ([nSystemDefaultUID], [cAuthority], [cProperty], [cValue], [nOrder], [cAction], [cGraphic], [mNotes], 
			[lLocal], [lSystemic], [lWarehouse], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], 
			[nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('9A1BE408-9C08-409A-B71B-2AA61F0DDC6C', N'Default', N'Work Order - Clear QC Approval', N'(none)', 0, NULL, NULL, 
			N'AFFECTS: Work Orders, clearing QC Approved By and QC Approved Date fields whenever a work order is edited by a user that is not currently the QC Approved By user.\nACTION: When Active (the default state), if the Work Order has QC Approved By and/or QC Approved Date fields filled in and the work order is edited by a different user, then the QC Approved By and QC Approved Date fields will be cleared.\n\nWhen Inactive, the QC Approved By and QC Approved Date fields are not changed.', 
			0, 0, 0, -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20220906 20:42:29.283', 
			'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20220906 20:42:29.283', '20220906 20:42:29.283', NULL, NULL);

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	
	-->>MTM-8686<<--
IF OBJECT_ID(N'[dbo].[spl_Find_Deleted]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_Find_Deleted]'

		DROP PROCEDURE [dbo].[spl_Find_Deleted]

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_Find_Deleted]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_Find_Deleted]'

		EXEC sp_executesql N'
/****************************************************************
	spl_Find_Deleted

	(C) 2015-22 Fluke Calibration
-----------------------------------------------------------------
	CHANGE HISTORY
	07/09/2015  MM    Initially created
	08/06/2015  MM    Populate UIDs
	08/10/2015  MM    Add end date param
	02/22/2016  MM    Use ISO date format yyyyMMdd for end date
	04/04/2016  MM    Changes for GUIDs
	05/20/2016  RK    Changes for GUIDs
	09/15/2022  MM    Add CallSheetResultStandardLink table
	09/15/2022  MM    Add AssetFiles table
	09/16/2022  MM    Add ManualTemplateRowTolerances table
	09/16/2022  MM    Add TypePartsLink table
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_Find_Deleted]
	@EndDate DATETIME
AS
BEGIN
	DECLARE @sql NVARCHAR(MAX)
	DECLARE @sqlTable NVARCHAR(MAX)
 	DECLARE @tableName NVARCHAR(128)
 	DECLARE @uidColumnName NVARCHAR(128)
 	DECLARE @nOrder INT
	DECLARE @sqlu NVARCHAR(MAX)
	DECLARE @uidList NVARCHAR(MAX)
	DECLARE @uid [uniqueidentifier]
	DECLARE @strEndDate VARCHAR(32)
	SET @strEndDate = REPLACE(CONVERT(VARCHAR, @EndDate, 120),''-'','''');		--yyyyMMdd

	SELECT @sql = ''SELECT ''''FacilityContactLink'''' AS [TableName], COUNT(*) AS [nCount], 1 AS [nOrder] FROM [dbo].[FacilityContactLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''EstimateItems'''' AS [TableName], COUNT(*) AS [nCount], 2 AS [nOrder] FROM [dbo].[EstimateItems] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Estimates'''' AS [TableName], COUNT(*) AS [nCount], 3 AS [nOrder] FROM [dbo].[Estimates] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''FacilityEX'''' AS [TableName], COUNT(*) AS [nCount], 4 AS [nOrder] FROM [dbo].[FacilityEX] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''InvoiceItemDetails'''' AS [TableName], COUNT(*) AS [nCount], 5 AS [nOrder] FROM [dbo].[InvoiceItemDetails] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Pricing'''' AS [TableName], COUNT(*) AS [nCount], 6 AS [nOrder] FROM [dbo].[Pricing] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProblemReportEx'''' AS [TableName], COUNT(*) AS [nCount], 7 AS [nOrder] FROM [dbo].[ProblemReportEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProblemReportFiles'''' AS [TableName], COUNT(*) AS [nCount], 8 AS [nOrder] FROM [dbo].[ProblemReportFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProblemReports'''' AS [TableName], COUNT(*) AS [nCount], 9 AS [nOrder] FROM [dbo].[ProblemReports] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ToolAssignmentEx'''' AS [TableName], COUNT(*) AS [nCount], 10 AS [nOrder] FROM [dbo].[ToolAssignmentEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ToolAssignmentFiles'''' AS [TableName], COUNT(*) AS [nCount], 11 AS [nOrder] FROM [dbo].[ToolAssignmentFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ToolAssignments'''' AS [TableName], COUNT(*) AS [nCount], 12 AS [nOrder] FROM [dbo].[ToolAssignments] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetAccreditationLink'''' AS [TableName], COUNT(*) AS [nCount], 13 AS [nOrder] FROM [dbo].[CallSheetAccreditationLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Accreditations'''' AS [TableName], COUNT(*) AS [nCount], 14 AS [nOrder] FROM [dbo].[Accreditations] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetReadings'''' AS [TableName], COUNT(*) AS [nCount], 15 AS [nOrder] FROM [dbo].[CallSheetReadings] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''TemplateItems'''' AS [TableName], COUNT(*) AS [nCount], 16 AS [nOrder] FROM [dbo].[TemplateItems] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''InvoiceItems'''' AS [TableName], COUNT(*) AS [nCount], 17 AS [nOrder] FROM [dbo].[InvoiceItems] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Labor'''' AS [TableName], COUNT(*) AS [nCount], 18 AS [nOrder] FROM [dbo].[Labor] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointAmbients'''' AS [TableName], COUNT(*) AS [nCount], 19 AS [nOrder] FROM [dbo].[PointAmbients] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointExLogicals'''' AS [TableName], COUNT(*) AS [nCount], 20 AS [nOrder] FROM [dbo].[PointExLogicals] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointExNumerics'''' AS [TableName], COUNT(*) AS [nCount], 21 AS [nOrder] FROM [dbo].[PointExNumerics] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointExStrings'''' AS [TableName], COUNT(*) AS [nCount], 22 AS [nOrder] FROM [dbo].[PointExStrings] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointReadings'''' AS [TableName], COUNT(*) AS [nCount], 23 AS [nOrder] FROM [dbo].[PointReadings] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointStandardReadings'''' AS [TableName], COUNT(*) AS [nCount], 24 AS [nOrder] FROM [dbo].[PointStandardReadings] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointStandards'''' AS [TableName], COUNT(*) AS [nCount], 25 AS [nOrder] FROM [dbo].[PointStandards] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointStatistics'''' AS [TableName], COUNT(*) AS [nCount], 26 AS [nOrder] FROM [dbo].[PointStatistics] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointTolerances'''' AS [TableName], COUNT(*) AS [nCount], 27 AS [nOrder] FROM [dbo].[PointTolerances] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointUncertainties'''' AS [TableName], COUNT(*) AS [nCount], 28 AS [nOrder] FROM [dbo].[PointUncertainties] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Points'''' AS [TableName], COUNT(*) AS [nCount], 29 AS [nOrder] FROM [dbo].[Points] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetResultStandardLink'''' AS [TableName], COUNT(*) AS [nCount], 30 AS [nOrder] FROM [dbo].[CallSheetResultStandardLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetResultEx'''' AS [TableName], COUNT(*) AS [nCount], 31 AS [nOrder] FROM [dbo].[CallSheetResultEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetResults'''' AS [TableName], COUNT(*) AS [nCount], 32 AS [nOrder] FROM [dbo].[CallSheetResults] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetStandardLink'''' AS [TableName], COUNT(*) AS [nCount], 33 AS [nOrder] FROM [dbo].[CallSheetStandardLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetPartsLink'''' AS [TableName], COUNT(*) AS [nCount], 34 AS [nOrder] FROM [dbo].[CallSheetPartsLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetLog'''' AS [TableName], COUNT(*) AS [nCount], 35 AS [nOrder] FROM [dbo].[CallSheetLog] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetFiles'''' AS [TableName], COUNT(*) AS [nCount], 36 AS [nOrder] FROM [dbo].[CallSheetFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetEx'''' AS [TableName], COUNT(*) AS [nCount], 37 AS [nOrder] FROM [dbo].[CallSheetEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheets'''' AS [TableName], COUNT(*) AS [nCount], 38 AS [nOrder] FROM [dbo].[CallSheets] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetAttributes'''' AS [TableName], COUNT(*) AS [nCount], 39 AS [nOrder] FROM [dbo].[CallSheetAttributes] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Invoices'''' AS [TableName], COUNT(*) AS [nCount], 40 AS [nOrder] FROM [dbo].[Invoices] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''TypesEx'''' AS [TableName], COUNT(*) AS [nCount], 41 AS [nOrder] FROM [dbo].[TypesEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''TypeFiles'''' AS [TableName], COUNT(*) AS [nCount], 42 AS [nOrder] FROM [dbo].[TypeFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''TypeProcedureDefaults'''' AS [TableName], COUNT(*) AS [nCount], 43 AS [nOrder] FROM [dbo].[TypeProcedureDefaults] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''TypePartsLink'''' AS [TableName], COUNT(*) AS [nCount], 44 AS [nOrder] FROM [dbo].[TypePartsLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PartEx'''' AS [TableName], COUNT(*) AS [nCount], 45 AS [nOrder] FROM [dbo].[PartEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PartFiles'''' AS [TableName], COUNT(*) AS [nCount], 46 AS [nOrder] FROM [dbo].[PartFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProcedurePartDefaults'''' AS [TableName], COUNT(*) AS [nCount], 47 AS [nOrder] FROM [dbo].[ProcedurePartDefaults] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Parts'''' AS [TableName], COUNT(*) AS [nCount], 48 AS [nOrder] FROM [dbo].[Parts] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProcedureStandards'''' AS [TableName], COUNT(*) AS [nCount], 49 AS [nOrder] FROM [dbo].[ProcedureStandards] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProcedureEx'''' AS [TableName], COUNT(*) AS [nCount], 50 AS [nOrder] FROM [dbo].[ProcedureEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProcedureFiles'''' AS [TableName], COUNT(*) AS [nCount], 51 AS [nOrder] FROM [dbo].[ProcedureFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Procedures'''' AS [TableName], COUNT(*) AS [nCount], 52 AS [nOrder] FROM [dbo].[Procedures] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ShipmentItems'''' AS [TableName], COUNT(*) AS [nCount], 53 AS [nOrder] FROM [dbo].[ShipmentItems] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Shipments'''' AS [TableName], COUNT(*) AS [nCount], 54 AS [nOrder] FROM [dbo].[Shipments] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''FacilityUserLink'''' AS [TableName], COUNT(*) AS [nCount], 55 AS [nOrder] FROM [dbo].[FacilityUserLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''FacilityJobLink'''' AS [TableName], COUNT(*) AS [nCount], 56 AS [nOrder] FROM [dbo].[FacilityJobLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''JobNumberFiles'''' AS [TableName], COUNT(*) AS [nCount], 57 AS [nOrder] FROM [dbo].[JobNumberFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''JobNumbers'''' AS [TableName], COUNT(*) AS [nCount], 58 AS [nOrder] FROM [dbo].[JobNumbers] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AssetServices'''' AS [TableName], COUNT(*) AS [nCount], 59 AS [nOrder] FROM [dbo].[AssetServices] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ServiceTypes'''' AS [TableName], COUNT(*) AS [nCount], 60 AS [nOrder] FROM [dbo].[ServiceTypes] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AssetLog'''' AS [TableName], COUNT(*) AS [nCount], 61 AS [nOrder] FROM [dbo].[AssetLog] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AssetFiles'''' AS [TableName], COUNT(*) AS [nCount], 62 AS [nOrder] FROM [dbo].[AssetFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AssetEx'''' AS [TableName], COUNT(*) AS [nCount], 63 AS [nOrder] FROM [dbo].[AssetEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Assets'''' AS [TableName], COUNT(*) AS [nCount], 64 AS [nOrder] FROM [dbo].[Assets] WHERE lDeleted <> 0 AND nParentUID IS NOT NULL AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Assets'''' AS [TableName], COUNT(*) AS [nCount], 65 AS [nOrder] FROM [dbo].[Assets] WHERE lDeleted <> 0 AND nParentUID IS NULL AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AlertParameters'''' AS [TableName], COUNT(*) AS [nCount], 66 AS [nOrder] FROM [dbo].[AlertParameters] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AlertRecipients'''' AS [TableName], COUNT(*) AS [nCount], 67 AS [nOrder] FROM [dbo].[AlertRecipients] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AlertEvents'''' AS [TableName], COUNT(*) AS [nCount], 68 AS [nOrder] FROM [dbo].[AlertEvents] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Alerts'''' AS [TableName], COUNT(*) AS [nCount], 69 AS [nOrder] FROM [dbo].[Alerts] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AlertParameterSheet'''' AS [TableName], COUNT(*) AS [nCount], 70 AS [nOrder] FROM [dbo].[AlertParameterSheet] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Contacts'''' AS [TableName], COUNT(*) AS [nCount], 71 AS [nOrder] FROM [dbo].[Contacts] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Addresses'''' AS [TableName], COUNT(*) AS [nCount], 72 AS [nOrder] FROM [dbo].[Addresses] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Types'''' AS [TableName], COUNT(*) AS [nCount], 73 AS [nOrder] FROM [dbo].[Types] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''FacilityFiles'''' AS [TableName], COUNT(*) AS [nCount], 74 AS [nOrder] FROM [dbo].[FacilityFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Facilities'''' AS [TableName], COUNT(*) AS [nCount], 75 AS [nOrder] FROM [dbo].[Facilities] WHERE lDeleted <> 0 AND nParentFacilityUID IS NOT NULL AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Facilities'''' AS [TableName], COUNT(*) AS [nCount], 76 AS [nOrder] FROM [dbo].[Facilities] WHERE lDeleted <> 0 AND nParentFacilityUID IS NULL AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''DataCheckSQL'''' AS [TableName], COUNT(*) AS [nCount], 77 AS [nOrder] FROM [dbo].[DataCheckSQL] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Validations'''' AS [TableName], COUNT(*) AS [nCount], 78 AS [nOrder] FROM [dbo].[Validations] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ComboData'''' AS [TableName], COUNT(*) AS [nCount], 79 AS [nOrder] FROM [dbo].[ComboData] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Calendar'''' AS [TableName], COUNT(*) AS [nCount], 80 AS [nOrder] FROM [dbo].[Calendar] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''SubCategory'''' AS [TableName], COUNT(*) AS [nCount], 81 AS [nOrder] FROM [dbo].[SubCategory] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Category'''' AS [TableName], COUNT(*) AS [nCount], 82 AS [nOrder] FROM [dbo].[Category] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''SecurityGroupMembers'''' AS [TableName], COUNT(*) AS [nCount], 83 AS [nOrder] FROM [dbo].[SecurityGroupMembers] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''UserPreferences'''' AS [TableName], COUNT(*) AS [nCount], 84 AS [nOrder] FROM [dbo].[UserPreferences] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Users'''' AS [TableName], COUNT(*) AS [nCount], 85 AS [nOrder] FROM [dbo].[Users] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AvailableComboData'''' AS [TableName], COUNT(*) AS [nCount], 86 AS [nOrder] FROM [dbo].[AvailableComboData] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Files'''' AS [TableName], COUNT(*) AS [nCount], 87 AS [nOrder] FROM [dbo].[Files] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ManualTemplateRowTolerances'''' AS [TableName], COUNT(*) AS [nCount], 88 AS [nOrder] FROM [dbo].[ManualTemplateRowTolerances] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ManualTemplateRows'''' AS [TableName], COUNT(*) AS [nCount], 89 AS [nOrder] FROM [dbo].[ManualTemplateRows] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ManualTemplates'''' AS [TableName], COUNT(*) AS [nCount], 90 AS [nOrder] FROM [dbo].[ManualTemplates] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Units'''' AS [TableName], COUNT(*) AS [nCount], 91 AS [nOrder] FROM [dbo].[Units] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ImportLogs'''' AS [TableName], COUNT(*) AS [nCount], 92 AS [nOrder] FROM [dbo].[ImportLogs] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Imports'''' AS [TableName], COUNT(*) AS [nCount], 93 AS [nOrder] FROM [dbo].[Imports] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ImportDefaults'''' AS [TableName], COUNT(*) AS [nCount], 94 AS [nOrder] FROM [dbo].[ImportDefaults] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ImportSetups'''' AS [TableName], COUNT(*) AS [nCount], 95 AS [nOrder] FROM [dbo].[ImportSetups] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ImportDefinitionFields'''' AS [TableName], COUNT(*) AS [nCount], 96 AS [nOrder] FROM [dbo].[ImportDefinitionFields] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ImportDefinitions'''' AS [TableName], COUNT(*) AS [nCount], 97 AS [nOrder] FROM [dbo].[ImportDefinitions] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' HAVING COUNT(*) > 0 ''

	IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N''[DF_DataToolDelWip_nOrder]'') AND type = ''D'')
	BEGIN
		ALTER TABLE [dbo].[DataToolDelWip] DROP CONSTRAINT [DF_DataToolDelWip_nOrder]
	END

	IF OBJECT_ID(N''[dbo].[DataToolDelWip]'', ''U'') IS NOT NULL
	BEGIN
		DROP TABLE [dbo].[DataToolDelWip]
	END

	IF OBJECT_ID(N''[dbo].[DataToolDelWip]'', ''U'') IS NULL
	BEGIN
		SELECT @sqlTable = ''CREATE TABLE [dbo].[DataToolDelWip](''
		SELECT @sqlTable = @sqlTable + ''[TableName] NVARCHAR(128) NULL, ''
		SELECT @sqlTable = @sqlTable + ''[UIDColumn] NVARCHAR(128) NULL, ''
		SELECT @sqlTable = @sqlTable + ''[nCount] INT NULL,''
		SELECT @sqlTable = @sqlTable + ''[UIDs] [nvarchar](max) NULL,''
		SELECT @sqlTable = @sqlTable + ''[nOrder] INT NOT NULL,''
		SELECT @sqlTable = @sqlTable + ''[TableNameDisplay] NVARCHAR(MAX) NULL)''
		SELECT @sqlTable = REPLACE(@sqlTable, '''', '''''''')
		EXEC sp_executesql @sqlTable;
	END

	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N''[DF_DataToolDelWip_nOrder]'') AND type = ''D'')
	BEGIN
		ALTER TABLE [dbo].[DataToolDelWip] ADD CONSTRAINT [DF_DataToolDelWip_nOrder] DEFAULT ((0)) FOR [nOrder]
	END

	SELECT @sql = REPLACE(@sql, '''', '''''''')
 	INSERT INTO [dbo].[DataToolDelWip]([TableName], [nCount], [nOrder])
 	EXEC sp_executesql @sql;

	IF OBJECT_ID(N''[dbo].[UidsWip2]'', ''U'') IS NULL
	BEGIN
		SELECT @sqlTable = ''CREATE TABLE [dbo].[UidsWip2]([TableName] NVARCHAR(128) NULL, [UID] [uniqueidentifier] NULL, [nOrder] INT NULL)''
		EXEC sp_executesql @sqlTable;
	END

	SELECT @sql = ''SELECT ''''FacilityContactLink'''' AS [TableName], nFacilityContactLinkUID AS [UID], 1 AS [nOrder] FROM [dbo].[FacilityContactLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''EstimateItems'''' AS [TableName], nEstimateItemUID AS [UID], 2 AS [nOrder] FROM [dbo].[EstimateItems] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Estimates'''' AS [TableName], nEstimateUID AS [UID], 3 AS [nOrder] FROM [dbo].[Estimates] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''FacilityEX'''' AS [TableName], nFacilityEXUID AS [UID], 4 AS [nOrder] FROM [dbo].[FacilityEX] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''InvoiceItemDetails'''' AS [TableName], nInvoiceItemDetailUID AS [UID], 5 AS [nOrder] FROM [dbo].[InvoiceItemDetails] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Pricing'''' AS [TableName], nPricingUID AS [UID], 6 AS [nOrder] FROM [dbo].[Pricing] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProblemReportEx'''' AS [TableName], nProblemReportExUID AS [UID], 7 AS [nOrder] FROM [dbo].[ProblemReportEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProblemReportFiles'''' AS [TableName], nProblemReportFileUID [UID], 8 AS [nOrder]  FROM [dbo].[ProblemReportFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProblemReports'''' AS [TableName], nProblemReportsUID AS [UID], 9 AS [nOrder] FROM [dbo].[ProblemReports] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ToolAssignmentEx'''' AS [TableName], nToolAssignmentExUID AS [UID], 10 AS [nOrder] FROM [dbo].[ToolAssignmentEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ToolAssignmentFiles'''' AS [TableName], nToolAssignmentFileUID AS [UID], 11 AS [nOrder] FROM [dbo].[ToolAssignmentFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ToolAssignments'''' AS [TableName], nToolAssignmentUID AS [UID], 12 AS [nOrder] FROM [dbo].[ToolAssignments] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetAccreditationLink'''' AS [TableName], nCallSheetAccreditationLinkUID AS [UID], 13 AS [nOrder] FROM [dbo].[CallSheetAccreditationLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Accreditations'''' AS [TableName], nAccreditationUID AS [UID], 14 AS [nOrder] FROM [dbo].[Accreditations] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetReadings'''' AS [TableName], nCallSheetReadingUID AS [UID], 15 AS [nOrder] FROM [dbo].[CallSheetReadings] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''TemplateItems'''' AS [TableName], nTemplateItemUID AS [UID], 16 AS [nOrder] FROM [dbo].[TemplateItems] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''InvoiceItems'''' AS [TableName], nInvoiceItemUID AS [UID], 17 AS [nOrder] FROM [dbo].[InvoiceItems] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Labor'''' AS [TableName], nLaborUID AS [UID], 18 AS [nOrder] FROM [dbo].[Labor] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointAmbients'''' AS [TableName], nPointAmbientUID AS [UID], 19 AS [nOrder] FROM [dbo].[PointAmbients] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointExLogicals'''' AS [TableName], nPointExLogicalUID AS [UID], 20 AS [nOrder] FROM [dbo].[PointExLogicals] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointExNumerics'''' AS [TableName], nPointExNumericUID AS [UID], 21 AS [nOrder] FROM [dbo].[PointExNumerics] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointExStrings'''' AS [TableName], nPointExStringUID AS [UID], 22 AS [nOrder] FROM [dbo].[PointExStrings] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointReadings'''' AS [TableName], nPointReadingUID AS [UID], 23 AS [nOrder] FROM [dbo].[PointReadings] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointStandardReadings'''' AS [TableName], nPointStandardReadingUID AS [UID], 24 AS [nOrder] FROM [dbo].[PointStandardReadings] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointStandards'''' AS [TableName], nPointStandardUID AS [UID], 25 AS [nOrder] FROM [dbo].[PointStandards] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointStatistics'''' AS [TableName], nPointStatisticUID AS [UID], 26 AS [nOrder] FROM [dbo].[PointStatistics] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointTolerances'''' AS [TableName], nPointToleranceUID AS [UID], 27 AS [nOrder] FROM [dbo].[PointTolerances] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PointUncertainties'''' AS [TableName], nPointUncertaintyUID AS [UID], 28 AS [nOrder] FROM [dbo].[PointUncertainties] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Points'''' AS [TableName], nPointUID AS [UID], 29 AS [nOrder] FROM [dbo].[Points] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetResultStandardLink'''' AS [TableName], nCallSheetResultStandardLinkUID AS [UID], 30 AS [nOrder] FROM [dbo].[CallSheetResultStandardLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetResultEx'''' AS [TableName], nCallSheetResultExUID AS [UID], 31 AS [nOrder] FROM [dbo].[CallSheetResultEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetResults'''' AS [TableName], nCallSheetResultUID AS [UID], 32 AS [nOrder] FROM [dbo].[CallSheetResults] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetStandardLink'''' AS [TableName], nCallSheetStandardLinkUID AS [UID], 33 AS [nOrder] FROM [dbo].[CallSheetStandardLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetPartsLink'''' AS [TableName], nCallSheetPartLinkUID AS [UID], 34 AS [nOrder] FROM [dbo].[CallSheetPartsLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetLog'''' AS [TableName], nCallSheetLogUID AS [UID], 35 AS [nOrder] FROM [dbo].[CallSheetLog] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetFiles'''' AS [TableName], nCallSheetFileUID AS [UID], 36 AS [nOrder] FROM [dbo].[CallSheetFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetEx'''' AS [TableName], nCallSheetExUID AS [UID], 37 AS [nOrder] FROM [dbo].[CallSheetEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheets'''' AS [TableName], nCallSheetUID AS [UID], 38 AS [nOrder] FROM [dbo].[CallSheets] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''CallSheetAttributes'''' AS [TableName], nCallSheetAttributeUID AS [UID], 39 AS [nOrder] FROM [dbo].[CallSheetAttributes] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Invoices'''' AS [TableName], nInvoiceUID AS [UID], 40 AS [nOrder] FROM [dbo].[Invoices] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''TypesEx'''' AS [TableName], nTypeExUID AS [UID], 41 AS [nOrder] FROM [dbo].[TypesEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''TypeFiles'''' AS [TableName], nTypeFileUID AS [UID], 42 AS [nOrder] FROM [dbo].[TypeFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''TypeProcedureDefaults'''' AS [TableName], nTypeProcedureDefaultUID AS [UID], 43 AS [nOrder] FROM [dbo].[TypeProcedureDefaults] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''TypePartsLink'''' AS [TableName], nTypePartLinkUID AS [UID], 44 AS [nOrder] FROM [dbo].[TypePartsLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PartEx'''' AS [TableName], nPartExUID AS [UID], 45 AS [nOrder] FROM [dbo].[PartEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''PartFiles'''' AS [TableName], nPartFileUID AS [UID], 46 AS [nOrder] FROM [dbo].[PartFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProcedurePartDefaults'''' AS [TableName], nProcedurePartDefaultUID AS [UID], 47 AS [nOrder] FROM [dbo].[ProcedurePartDefaults] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Parts'''' AS [TableName], nPartUID AS [UID], 48 AS [nOrder] FROM [dbo].[Parts] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProcedureStandards'''' AS [TableName], nProcedureStandardUID AS [UID], 49 AS [nOrder] FROM [dbo].[ProcedureStandards] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProcedureEx'''' AS [TableName], nProcedureExUID AS [UID], 50 AS [nOrder] FROM [dbo].[ProcedureEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ProcedureFiles'''' AS [TableName], nProcedureFileUID AS [UID], 51 AS [nOrder] FROM [dbo].[ProcedureFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Procedures'''' AS [TableName], nProcedureUID AS [UID], 52 AS [nOrder] FROM [dbo].[Procedures] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ShipmentItems'''' AS [TableName], nShipmentItemUID AS [UID], 53 AS [nOrder] FROM [dbo].[ShipmentItems] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Shipments'''' AS [TableName], nShipmentUID AS [UID], 54 AS [nOrder] FROM [dbo].[Shipments] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''FacilityUserLink'''' AS [TableName], nFacilityUserLinkUID AS [UID], 55 AS [nOrder] FROM [dbo].[FacilityUserLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''FacilityJobLink'''' AS [TableName], nFacilityJobLinkUID AS [UID], 56 AS [nOrder] FROM [dbo].[FacilityJobLink] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''JobNumberFiles'''' AS [TableName], nJobNumberFileUID AS [UID], 57 AS [nOrder] FROM [dbo].[JobNumberFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''JobNumbers'''' AS [TableName], nJobNumberUID AS [UID], 58 AS [nOrder] FROM [dbo].[JobNumbers] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AssetServices'''' AS [TableName], nAssetServiceUID AS [UID], 59 AS [nOrder] FROM [dbo].[AssetServices] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ServiceTypes'''' AS [TableName], nServiceTypeUID AS [UID], 60 AS [nOrder] FROM [dbo].[ServiceTypes] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AssetLog'''' AS [TableName], nAssetLogUID AS [UID], 61 AS [nOrder] FROM [dbo].[AssetLog] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AssetFiles'''' AS [TableName], nAssetFileUID AS [UID], 62 AS [nOrder] FROM [dbo].[AssetFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AssetEx'''' AS [TableName], nAssetExUID AS [UID], 63 AS [nOrder] FROM [dbo].[AssetEx] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Assets'''' AS [TableName], nAssetUID AS [UID], 64 AS [nOrder] FROM [dbo].[Assets] WHERE lDeleted <> 0 AND nParentUID IS NOT NULL AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Assets'''' AS [TableName], nAssetUID AS [UID], 65 AS [nOrder] FROM [dbo].[Assets] WHERE lDeleted <> 0 AND nParentUID IS NULL AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AlertParameters'''' AS [TableName], nAlertParameterUID AS [UID], 66 AS [nOrder] FROM [dbo].[AlertParameters] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AlertRecipients'''' AS [TableName], nAlertRecipientUID AS [UID], 67 AS [nOrder] FROM [dbo].[AlertRecipients] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AlertEvents'''' AS [TableName], nAlertEventUID AS [UID], 68 AS [nOrder] FROM [dbo].[AlertEvents] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Alerts'''' AS [TableName], nAlertUID AS [UID], 69 AS [nOrder] FROM [dbo].[Alerts] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AlertParameterSheet'''' AS [TableName], nAlertParameterSheetUID AS [UID], 70 AS [nOrder] FROM [dbo].[AlertParameterSheet] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Contacts'''' AS [TableName], nContactUID AS [UID], 71 AS [nOrder] FROM [dbo].[Contacts] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Addresses'''' AS [TableName], nAddressUID AS [UID], 72 AS [nOrder] FROM [dbo].[Addresses] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Types'''' AS [TableName], nTypeUID AS [UID], 73 AS [nOrder] FROM [dbo].[Types] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''FacilityFiles'''' AS [TableName], nFacilityFileUID AS [UID], 74 AS [nOrder] FROM [dbo].[FacilityFiles] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Facilities'''' AS [TableName], nFacilityUID AS [UID], 75 AS [nOrder] FROM [dbo].[Facilities] WHERE lDeleted <> 0 AND nParentFacilityUID IS NOT NULL AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Facilities'''' AS [TableName], nFacilityUID AS [UID], 76 AS [nOrder] FROM [dbo].[Facilities] WHERE lDeleted <> 0 AND nParentFacilityUID IS NULL AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''DataCheckSQL'''' AS [TableName], nDataCheckSQLUID AS [UID], 77 AS [nOrder] FROM [dbo].[DataCheckSQL] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Validations'''' AS [TableName], nValidationUID AS [UID], 78 AS [nOrder] FROM [dbo].[Validations] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ComboData'''' AS [TableName], nComboDataUID AS [UID], 79 AS [nOrder] FROM [dbo].[ComboData] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Calendar'''' AS [TableName], nCalendarUID AS [UID], 80 AS [nOrder] FROM [dbo].[Calendar] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''SubCategory'''' AS [TableName], nSubCategoryUID AS [UID], 81 AS [nOrder] FROM [dbo].[SubCategory] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Category'''' AS [TableName], nCategoryUID AS [UID], 82 AS [nOrder] FROM [dbo].[Category] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''SecurityGroupMembers'''' AS [TableName], nSecurityGroupMemberUID AS [UID], 83 AS [nOrder] FROM [dbo].[SecurityGroupMembers] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''UserPreferences'''' AS [TableName], nUserPreferenceUID AS [UID], 84 AS [nOrder] FROM [dbo].[UserPreferences] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Users'''' AS [TableName], nUserUID AS [UID], 85 AS [nOrder] FROM [dbo].[Users] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''AvailableComboData'''' AS [TableName], nAvailableComboDataUID AS [UID], 86 AS [nOrder] FROM [dbo].[AvailableComboData] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Files'''' AS [TableName], nFileUID AS [UID], 87 AS [nOrder] FROM [dbo].[Files] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ManualTemplateRowTolerances'''' AS [TableName], nManualTemplateRowToleranceUID AS [UID], 88 AS [nOrder] FROM [dbo].[ManualTemplateRowTolerances] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ManualTemplateRows'''' AS [TableName], nManualTemplateRowUID AS [UID], 89 AS [nOrder] FROM [dbo].[ManualTemplateRows] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ManualTemplates'''' AS [TableName], nManualTemplateUID AS [UID], 90 AS [nOrder] FROM [dbo].[ManualTemplates] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Units'''' AS [TableName], nUnitUID AS [UID], 91 AS [nOrder] FROM [dbo].[Units] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ImportLogs'''' AS [TableName], nImportLogUID AS [UID], 92 AS [nOrder] FROM [dbo].[ImportLogs] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''Imports'''' AS [TableName], nImportUID AS [UID], 93 AS [nOrder] FROM [dbo].[Imports] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ImportDefaults'''' AS [TableName], nImportDefaultUID AS [UID], 94 AS [nOrder] FROM [dbo].[ImportDefaults] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ImportSetups'''' AS [TableName], nImportSetupUID AS [UID], 95 AS [nOrder] FROM [dbo].[ImportSetups] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ImportDefinitionFields'''' AS [TableName], nImportDefinitionFieldUID AS [UID], 96 AS [nOrder] FROM [dbo].[ImportDefinitionFields] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''
	SELECT @sql = @sql + '' UNION ''
	SELECT @sql = @sql + ''SELECT ''''ImportDefinitions'''' AS [TableName], nImportDefinitionUID AS [UID], 97 AS [nOrder] FROM [dbo].[ImportDefinitions] WHERE lDeleted <> 0 AND tUpdateTime <= '''''' + @strEndDate + '''''' ''

 	SELECT @sql = REPLACE(@sql, '''', '''''''')
	INSERT INTO [dbo].[UidsWip2](TableName, UID, nOrder)
 	EXEC sp_executesql @sql;

	DECLARE wipc CURSOR LOCAL FORWARD_ONLY FOR
	SELECT
		[TableName],
		[nOrder]
	FROM
		[dbo].[DataToolDelWip];

	OPEN wipc
	FETCH NEXT FROM wipc INTO @tableName, @nOrder
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SELECT @uidList = ''''

		DECLARE uc CURSOR LOCAL	FORWARD_ONLY FOR
		SELECT
			[UID]
		FROM
			[dbo].[UidsWip2]
		WHERE
			[TableName] = @tableName
		AND
			[nOrder] = @nOrder;

		OPEN uc
		FETCH NEXT FROM uc INTO @uid
		IF(@@FETCH_STATUS = 0)
		BEGIN
			SELECT @uidList = @uidList + CONVERT(NVARCHAR(36), @uid)
			FETCH NEXT FROM uc INTO @uid
		END
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @uidList = @uidList + '','' + CONVERT(NVARCHAR(36), @uid)
			FETCH NEXT FROM uc INTO @uid
		END
		CLOSE uc;
		DEALLOCATE uc;

		SELECT @sqlu = ''UPDATE [dbo].[DataToolDelWip] SET [UIDs] = '''''' + @uidList + '''''' WHERE [TableName] = '''''' + @tableName + '''''' AND [nOrder] = '' + CONVERT(VARCHAR, @nOrder) + '' ;''
		--PRINT @sqlu
		EXEC sp_executesql @sqlu;

		SELECT @uidColumnName = sc.name FROM syscolumns sc JOIN sysobjects so ON sc.id = so.id WHERE sc.colid = 1 AND sc.name LIKE ''%UID%'' AND so.NAME = @tableName
		SELECT @sqlu = ''UPDATE [dbo].[DataToolDelWip] SET [UIDColumn] = '''''' + @uidColumnName + '''''' WHERE [TableName] = '''''' + @tableName + '''''' AND [nOrder] = '' + CONVERT(VARCHAR, @nOrder) + '' ;''
		--PRINT @sqlu
		EXEC sp_executesql @sqlu;

		FETCH NEXT FROM wipc INTO @tableName, @nOrder
	END

	CLOSE wipc;
	DEALLOCATE wipc;

	IF OBJECT_ID(N''[dbo].[UidsWip2]'', ''U'') IS NOT NULL
	BEGIN
		SELECT @sqlTable = ''DROP TABLE [dbo].[UidsWip2]''
		EXEC sp_executesql @sqlTable;
	END

END		
'
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	
	UPDATE 
		[dbo].[CallSheetResultEx]
	SET 
		[lDeleted] = -1,
		[tUpdateTime] = '20220916 16:14:40.277'
	WHERE 
		[nCallSheetResultUID] IN (SELECT [nCallSheetResultUID] FROM [dbo].[CallSheetResults] WHERE lDeleted <> 0)
	AND
		[lDeleted] = 0
	
	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	UPDATE 
		[dbo].[ManualTemplateRows]
	SET 
		[lDeleted] = -1,
		[tUpdateTime] = '20220916 16:14:40.277'
	WHERE 
		[nManualTemplateUID] IN (SELECT [nManualTemplateUID] FROM [dbo].[ManualTemplates] WHERE lDeleted <> 0)
	AND
		[lDeleted] = 0
	
	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END		


	-->>MTM-8910<<--
	IF OBJECT_ID(N'[dbo].[udf_GET_METCALResultField]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_METCALResultField]'
		DROP FUNCTION [dbo].[udf_GET_METCALResultField]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
	
	IF OBJECT_ID(N'[dbo].[udf_GET_METCALResultField]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_METCALResultField]'

		EXEC sp_executesql N'/********************************************************************************
udf_GET_METCALResultField
Gets the MET/CAL Runtime view RESULT field

Parameters:
Points.cPointPassFailStatus
Points.cCondition
PointUncertainties.GuardBandLower
PointUncertainties.GuardBandUpper

(C) 2022 Fluke Calibration
-----------------------------------------------------------------
CHANGE HISTORY
10/06/2022  MM      Initially created
*********************************************************************************/

CREATE FUNCTION [dbo].[udf_GET_METCALResultField] 
( 
	@PointPassFailStatus NVARCHAR(50), 
	@Condition NVARCHAR(50), 
	@GuardBandLower float, 
	@GuardBandUpper float 
)				
RETURNS NVARCHAR(128)

AS
BEGIN
	DECLARE @result NVARCHAR(128);
	
	-- if guardbanding is utilized, do not append the condition (Marginal)
	IF (@GuardBandLower IS NULL AND @GuardBandUpper IS NULL)
		SET @result = COALESCE(@PointPassFailStatus,'''') + '' '' + COALESCE(@Condition,'''')
	ELSE
		SET @result = COALESCE(@PointPassFailStatus,'''')

	RETURN @result;

END'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	
	IF OBJECT_ID(N'[dbo].[udf_GET_FormattedValue]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_FormattedValue]'
		DROP FUNCTION [dbo].[udf_GET_FormattedValue]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
	
	IF OBJECT_ID(N'[dbo].[udf_GET_FormattedValue]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_FormattedValue]'

		EXEC sp_executesql N'/*****************************************************************************
    udf_GET_FormattedValue

    (C) 2013-22 Fluke Calibration
--------------------------------------------------------------------------
    CHANGE HISTORY
    07/23/2013  MM  Initially created
    07/31/2013  MM  Format numbers exponentially that were not
                    formatted exponentially when passed in
    08/28/2014  KW  Some numbers were not being
                    formatted correctly if the number was
                    exponential in the database and the format
                    was set to fixed.
    03/25/2016  MM  Changes for GUIDs
    05/12/2016  MM  Format exponential values as 1.xE3 rather than 10.xE2
    10/06/2022  MM  Never return NULL from this function
******************************************************************************/

CREATE FUNCTION [dbo].[udf_GET_FormattedValue]
(
    @number FLOAT(53)
   ,@nFormatUID [UNIQUEIDENTIFIER]
)
RETURNS NVARCHAR(64)

AS
BEGIN
	IF @nFormatUID IS NULL
		RETURN @number;

	-- blank format
	IF (@nFormatUID = ''7A66899D-0C17-44BD-9BB0-035864EB3028'' OR @number IS NULL)
		RETURN '''';

	IF NOT EXISTS(SELECT * FROM [dbo].[Formats] WHERE nFormatUID = @nFormatUID)
		RETURN @number;

	-- this requires SQL Server 2012 or newer
	--DECLARE @cFormatUI nvarchar(50);
	--SELECT @cFormatUI = cFormatUI FROM [dbo].[Formats] WHERE nFormatUID = @nFormatUID;
	--RETURN FORMAT(@number, @cFormatUI);

	DECLARE @cNumber varchar(64),
            @nScale int,
            @exponent varchar(64),
            @indexE INT,
            @inverseExponent VARCHAR(64),
            @isNegE INT,
            @formatE INT,
            @mantissa NUMERIC(38,18),
            @counter INT,
            @cExponent VARCHAR(3);

	--SELECT @formatE = 0;
	SELECT @nScale = nScale FROM [dbo].[Formats] WHERE nFormatUID = @nFormatUID;
	IF @nScale >= 1000
		BEGIN
			SELECT @formatE = 1;
			SELECT @nScale = @nScale - 1000;
		END
	----PRINT @nScale;

	SELECT @cNumber = @number +''''
	--PRINT @cNumber;
	SELECT @indexE = CHARINDEX(''E'',@cNumber);
	--PRINT @indexE;
	--MTM-5386 - This if was prevented numbers that are in EXP format from being fixed format.
	--IF(@indexE > 0)
	IF(@indexE > 0 AND @formatE > 0)
	    BEGIN
	        SELECT @exponent = SUBSTRING(@cNumber,@indexE,DATALENGTH(@cNumber)-@indexE+1);
	        --PRINT @exponent;
	        SELECT @isNegE = CHARINDEX(''-'',@exponent);
	        IF @isNegE > 0
				SELECT @inverseExponent = REPLACE(@exponent, ''-'',''+'');
			ELSE
				SELECT @inverseExponent = REPLACE(@exponent, ''+'',''-'');
	        --PRINT @inverseExponent;

	        SELECT @number = @number * CONVERT(FLOAT(53), ''1'' + @inverseExponent);
			SELECT @mantissa = LTRIM(STR(@number,64,64));
			--PRINT @mantissa;
	        SELECT @cNumber = LTRIM(STR(@mantissa,64,@nScale)) + @exponent;
	        --PRINT @cNumber;
	    END
	ELSE IF(@formatE > 0)
		BEGIN
			IF(@number = 0)
				SELECT @cNumber = LTRIM(STR(0, 64, @nScale)) + ''e+000'';
			ELSE
				IF(ABS(@number) >= 1)
				BEGIN
					SELECT @mantissa = @number;
					SELECT @counter = 0;
					WHILE (ABS(@mantissa) >= 10.0)
						BEGIN
							SELECT @mantissa = @mantissa / 10.0
							SELECT @counter = @counter + 1
						END
					SELECT @cExponent = LTRIM(STR(@counter,3,0));
					WHILE (DATALENGTH(@cExponent) < 3)
						SELECT @cExponent = ''0'' + @cExponent;
					SELECT @cNumber = LTRIM(STR(@mantissa, 64, @nScale)) + ''e+'' + @cExponent;
				END
			ELSE
				BEGIN
					SELECT @mantissa = @number;
					SELECT @counter = 0;
					WHILE (ABS(@mantissa) < 1)
						BEGIN
							SELECT @mantissa = @mantissa * 10.0
							SELECT @counter = @counter + 1
						END
					SELECT @cExponent = LTRIM(STR(@counter,3,0));
					WHILE (DATALENGTH(@cExponent) < 3)
						SELECT @cExponent = ''0'' + @cExponent;
					SELECT @cNumber = LTRIM(STR(@mantissa, 64, @nScale)) + ''e-'' + @cExponent;
				END
		END
	ELSE
		BEGIN
			SELECT @cNumber = LTRIM(STR(@number, 64, @nScale));
			--PRINT @cNumber;
		END

	RETURN @cNumber;
END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[udf_GET_FormattedValueExWithUnit]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_FormattedValueExWithUnit]'
		
		DROP FUNCTION [dbo].[udf_GET_FormattedValueExWithUnit]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
	
	IF OBJECT_ID(N'[dbo].[udf_GET_FormattedValueExWithUnit]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_FormattedValueExWithUnit]'

		EXEC sp_executesql N'/*************************************************************************

udf_GET_FormattedValueExWithUnit

	(C) 2022 Fluke Calibration
-----------------------------------------------------------------
	CHANGE HISTORY
	10/06/2022  MM      Initially created
*********************************************************************************/

CREATE FUNCTION [dbo].[udf_GET_FormattedValueExWithUnit]
(
    @number FLOAT(53)
   ,@nFormatUID [UNIQUEIDENTIFIER]
   ,@nUnitUID [UNIQUEIDENTIFIER]
)
RETURNS NVARCHAR(64)

AS
    BEGIN
    	RETURN [dbo].[udf_GET_FormattedValueEx](@number, @nFormatUID) + '' '' + [dbo].[udf_GET_Unit](@nUnitUID)
    END	
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	
	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_MCRT]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_MCRT]'
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_MCRT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_MCRT]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_MCRT]'

		EXEC sp_executesql N'/********************************************************************************
	udf_GetMETCAL_Results_MCRT
	Gets the MET/CAL results data for the Runtime view

	Parameters:
	@nCallSheetResultUID - UID for call sheet result record

	(C) 2016-2022 Fluke Calibration
-----------------------------------------------------------------
	CHANGE HISTORY
	09/21/2016  MM      Initially created
	11/30/2021  AC      Account for Marginal condition in RESULT column
	12/15/2021  AC      Changed PERCENT_TOL field to return >500 % when nToleranceErrorPercent > 500
	04/11/2022  AC      Place all nToleranceErrorPercent statements on a single line to support Editing Results
	10/05/2022  MM      Do not show Pass Marginal if Guardbanding was used
	10/05/2022  MM      Simplify

    NOTES: All of the statements that make up one fields formatting MUST be on a single line.
           Test editing results in MET/TEAM after adding or altering any field.
*********************************************************************************/

CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_MCRT] ( @nCallSheetResultUID [uniqueidentifier] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17'' )      -- new record GUID
RETURNS TABLE
AS
RETURN
(
	SELECT
		p.nPointUID,
		p.nPointOrdinal AS [ROW NUMBER],
		[dbo].[udf_GET_METCALResultField](p.cPointPassFailStatus, p.cCondition, pun.nGuardbandLower, pun.nGuardbandUpper) AS [RESULT],
		pes.cField009 AS [NO],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nUUTRange, p.nUUTRangeFormatUID, p.nUUTRangeUnitUID) AS [RANGE],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nUUT, p.nUUTFormatUID, p.nUUTUnitUID) AS [UUT_INDICATED],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nReference, p.nReferenceFormatUID, p.nReferenceUnitUID) AS [SYSTEM_ACTUAL],
		pel.lField001 AS [C],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nModifier1, pun.nModifier1FormatUID, pun.nModifier1UnitUID) AS [MODIFIER],
		[dbo].[udf_GET_FormattedValueExWithUnit](tol.nError, tol.nErrorFormatUID, tol.nErrorUnitUID) AS [ERROR],
		CASE WHEN tol.nToleranceErrorPercent > 500 THEN ''>500 %'' ELSE [dbo].[udf_GET_FormattedValueEx](tol.nToleranceErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)) + CASE WHEN tol.nToleranceErrorPercent IS NULL THEN '''' ELSE '' %'' END END AS [PERCENT_TOL]
	FROM
		CallSheetResults csr
		LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
		LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
		LEFT JOIN PointUncertainties pun ON pun.nPointUID = p.nPointUID
		LEFT JOIN PointTolerances tol ON tol.nPointUID = p.nPointUID
		LEFT JOIN PointExLogicals pel ON pel.nPointUID = p.nPointUID
	WHERE
		csr.nCallSheetResultUID = @nCallSheetResultUID
	AND
		p.lDeleted = 0 AND p.lActive <> 0
	AND
		csr.lDeleted = 0 AND csr.lActive <> 0
);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[udf_GetCOMPASS_Results]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetCOMPASS_Results]'
		
		DROP FUNCTION [dbo].[udf_GetCOMPASS_Results]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetCOMPASS_Results]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetCOMPASS_Results]'

		EXEC sp_executesql N'/***********************************************************************
	udf_GetCOMPASS_Results
	
	Gets the COMPASS results
		paramters:
	@nCallSheetResultUID - call sheet result identifier

	(C) 2014-22 Fluke Calibration
-----------------------------------------------------------------
	CHANGE HISTORY
	05/11/2014	MM		Initially created
	04/04/2016  MM		Changes for GUIDs
	04/18/2022  KW		Added User Defined, Aux and String data fields
	10/06/2022  MM      Simplify
***********************************************************************/

CREATE FUNCTION [dbo].[udf_GetCOMPASS_Results] 
(
	@nCallSheetResultUID [UNIQUEIDENTIFIER] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17''      -- new record GUID
)
RETURNS TABLE

AS
RETURN
	(
	SELECT
		p.nPointUID,
		COALESCE(pes.cField009,'''') AS [ID100001],
		--'''' AS [ID100002],
		--'''' AS [ID100003],
		-- [ID100002] + '' '' + [ID100003]
		COALESCE(p.tPointDateTime,'''') AS [tPointDateTime],
		'''' AS [ID100004],
		COALESCE(p.cPointPassFailStatus,'''') AS [ID100005],
		COALESCE(pes.cField021,'''') AS [ID100006],
		COALESCE(pes.cField022,'''') AS [ID100007],
		COALESCE(pes.cField023,'''') AS [ID100008],
		COALESCE(pes.cField024,'''') AS [ID100009],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nCardinalPoint, p.nCardinalPointFormatUID, p.nCardinalPointUnitUID) AS [ID100010],
		[dbo].[udf_GET_FormattedValueExWithUnit](pa.nAmbientPressure, pa.nAmbientPressureFormatUID, pa.nAmbientPressureUnitUID) AS [ID100011],
		[dbo].[udf_GET_FormattedValueExWithUnit](pa.nAmbientTemperature, pa.nAmbientTemperatureFormatUID, pa.nAmbientTemperatureUnitUID) AS [ID100012],
		[dbo].[udf_GET_FormattedValueExWithUnit](pa.nAmbientHumidity, pa.nAmbientHumidityFormatUID, pa.nAmbientHumidityUnitUID) AS [ID100013],
		'''' AS [ID100014],
		'''' AS [ID100015],
		'''' AS [ID100016],
		'''' AS [ID200001],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nReference, p.nReferenceFormatUID, p.nReferenceUnitUID) AS [ID200002],
		'''' AS [ID200003],
		'''' AS [ID200004],
		'''' AS [ID200005],
		'''' AS [ID200006],
		'''' AS [ID200007],
		'''' AS [ID200008],
		'''' AS [ID200009],
		'''' AS [ID200010],
		'''' AS [ID200011],
		'''' AS [ID200012],
		'''' AS [ID200013],
		'''' AS [ID200014],
		CASE WHEN COALESCE(pt.cToleranceReference,'''') = '''' THEN '''' ELSE CASE WHEN ISNUMERIC(pt.cToleranceReference) <> 0 THEN [dbo].[udf_GET_FormattedValueEx](pt.cToleranceReference, [dbo].[udf_GET_nFormatUIDFromScale](0)) ELSE pt.cToleranceReference END END AS [ID200015],
		'''' AS [ID200016],
		'''' AS [ID200017],
		'''' AS [ID200018],
		'''' AS [ID200082],
		'''' AS [ID200083],
		'''' AS [ID300001],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nUUT, p.nUUTFormatUID, p.nUUTUnitUID) AS [ID300002],
		--'''' AS [ID300003],
		--'''' AS [ID300004],
		-- ID300004 - ID300003
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nUUTRange, p.nUUTRangeFormatUID, p.nUUTRangeUnitUID) AS [UUT_Range],
		COALESCE(ps.nNumberOfSamplesUUT,0) AS [ID300005],
		[dbo].[udf_GET_FormattedValueExWithUnit](ps.nUUTStandardDeviation, ps.nUUTStandardDeviationFormatUID, ps.nUUTStandardDeviationUnitUID) AS [ID300006],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField027, pen.nField027FormatUID, pen.nField027UnitUID) AS [ID300007],
		'''' AS [ID300008],
		'''' AS [ID300009],
		'''' AS [ID300010],
		'''' AS [ID300011],
		'''' AS [ID300012],
		'''' AS [ID300013],
		'''' AS [ID300014],
		'''' AS [ID300016],
		'''' AS [ID300017],
		'''' AS [ID300018],
		'''' AS [ID300082],
		'''' AS [ID300083],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField006, pen.nField006FormatUID, pen.nField006UnitUID) AS [ID301001],
		[dbo].[udf_GET_FormattedValueExWithUnit](pt.nError, pt.nErrorFormatUID, pt.nErrorUnitUID) AS [ID301002],
		[dbo].[udf_GET_FormattedValueEx](pt.nReadingErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)) + CASE WHEN pt.nReadingErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [ID301003],
		[dbo].[udf_GET_FormattedValueExWithUnit](pt.nTolerance, pt.nToleranceFormatUID, pt.nToleranceUnitUID) AS [ID301004],
		'''' AS [ID301005],
		'''' AS [ID301006],
		'''' AS [ID301010],
		'''' AS [ID301011],
		'''' AS [ID301012],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField031, pen.nField031FormatUID, pen.nField031UnitUID) AS [ID400001],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField032, pen.nField032FormatUID, pen.nField032UnitUID) AS [ID400002],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField033, pen.nField033FormatUID, pen.nField033UnitUID) AS [ID400003],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField034, pen.nField034FormatUID, pen.nField034UnitUID) AS [ID400004],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField035, pen.nField035FormatUID, pen.nField035UnitUID) AS [ID400005],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField036, pen.nField036FormatUID, pen.nField036UnitUID) AS [ID400006],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField037, pen.nField037FormatUID, pen.nField037UnitUID) AS [ID400007],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField038, pen.nField038FormatUID, pen.nField038UnitUID) AS [ID400008],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField039, pen.nField039FormatUID, pen.nField039UnitUID) AS [ID400009],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField040, pen.nField040FormatUID, pen.nField040UnitUID) AS [ID400010],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField041, pen.nField041FormatUID, pen.nField041UnitUID) AS [ID400011],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField042, pen.nField042FormatUID, pen.nField042UnitUID) AS [ID400012],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField043, pen.nField043FormatUID, pen.nField043UnitUID) AS [ID400013],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField044, pen.nField044FormatUID, pen.nField044UnitUID) AS [ID400014],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField045, pen.nField045FormatUID, pen.nField045UnitUID) AS [ID400015],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField046, pen.nField046FormatUID, pen.nField046UnitUID) AS [ID400016],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField047, pen.nField047FormatUID, pen.nField047UnitUID) AS [ID400017],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField048, pen.nField048FormatUID, pen.nField048UnitUID) AS [ID400018],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField049, pen.nField049FormatUID, pen.nField049UnitUID) AS [ID400019],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField050, pen.nField050FormatUID, pen.nField050UnitUID) AS [ID400020],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField051, pen.nField051FormatUID, pen.nField051UnitUID) AS [ID410001],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField052, pen.nField052FormatUID, pen.nField052UnitUID) AS [ID410002],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField053, pen.nField053FormatUID, pen.nField053UnitUID) AS [ID410003],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField054, pen.nField054FormatUID, pen.nField054UnitUID) AS [ID410004],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField055, pen.nField055FormatUID, pen.nField055UnitUID) AS [ID410005],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField056, pen.nField056FormatUID, pen.nField056UnitUID) AS [ID410006],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField057, pen.nField057FormatUID, pen.nField057UnitUID) AS [ID410007],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField058, pen.nField058FormatUID, pen.nField058UnitUID) AS [ID410008],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField059, pen.nField059FormatUID, pen.nField059UnitUID) AS [ID410009],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField060, pen.nField060FormatUID, pen.nField060UnitUID) AS [ID410010],
		COALESCE(pes.cField025,'''') AS [ID410501],
		COALESCE(pes.cField026,'''') AS [ID410502],
		COALESCE(pes.cField027,'''') AS [ID410503],
		COALESCE(pes.cField028,'''') AS [ID410504],
		COALESCE(pes.cField029,'''') AS [ID410505],
		COALESCE(pes.cField030,'''') AS [ID410506],
		COALESCE(pes.cField031,'''') AS [ID410507],
		COALESCE(pes.cField032,'''') AS [ID410508],
		COALESCE(pes.cField033,'''') AS [ID410509],
		COALESCE(pes.cField034,'''') AS [ID410510],
		[dbo].[udf_GET_FormattedValueExWithUnit](pu.nLowerLimit, pu.nLowerLimitFormatUID, pu.nLowerLimitUnitUID) AS [Lower_Limit],
		[dbo].[udf_GET_FormattedValueExWithUnit](pu.nUpperLimit, pu.nUpperLimitFormatUID, pu.nUpperLimitUnitUID) AS [Upper_Limit],
		[dbo].[udf_GET_FormattedValueExWithUnit](pt.nToleranceNegative, pt.nToleranceNegativeFormatUID, pt.nToleranceNegativeUnitUID) AS [Tol_Neg],
		[dbo].[udf_GET_FormattedValueExWithUnit](pt.nTolerancePositive, pt.nTolerancePositiveFormatUID, pt.nTolerancePositiveUnitUID) AS [Tol_Pos],
		COALESCE(ps.lNoisy,0) AS [lNoisy],
		COALESCE(ps.lReliable,-1) AS [lReliable]
	FROM
		[dbo].[Points] p
	LEFT JOIN
		[dbo].[PointAmbients] pa ON pa.nPointUID = p.nPointUID
	LEFT JOIN
		[dbo].[PointExStrings] pes ON pes.nPointUID = p.nPointUID
	LEFT JOIN
		[dbo].[PointExNumerics] pen ON pen.nPointUID = p.nPointUID
	LEFT JOIN
		[dbo].[PointStatistics] ps ON ps.nPointUID = p.nPointUID
	LEFT JOIN
		[dbo].[PointTolerances] pt ON pt.nPointUID = p.nPointUID
	LEFT JOIN
		[dbo].[PointUncertainties] pu ON pu.nPointUID = p.nPointUID
	WHERE
		p.nCallSheetResultUID = @nCallSheetResultUID
);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_Classic]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_Classic]'
		
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_Classic]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_Classic]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_Classic]'

		EXEC sp_executesql N'/********************************************************************************
udf_GetMETCAL_Results_Classic

Gets the MET/CAL results data for the Classic view

Parameters:
@nCallSheetResultUID - UID for call sheet result record

(C) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
CHANGE HISTORY
05/22/2012  EdW     Initially created
06/08/2012  EdW     Added p.nPointUID, COALESCE for
                    pes.cField009, and modifed WHERE
08/17/2012  MM      Excluded deleted records
09/04/2012  MM      COALESCE point ordinal (may be NULL now)
03/18/2013  MM      Added csr.cDescription for tagged procedures
                    Exclude deleted call sheet results
04/08/2013  MM      Return numbers as numbers
                    Return NULL values as NULL
08/14/2013  MM      Changed parameter to be work order result
07/02/2014  MM      Format numeric values with the correct separator
04/04/2016  MM      Changes for GUIDs
09/21/2016  MM      Removed parent record fields from the data
10/06/2022  MM      Simplify

        NOTES: All of the statements that make up one fields formatting MUST be on a single line.
               Test editing results in MET/TEAM after adding or altering any field.
*********************************************************************************/

CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_Classic] ( @nCallSheetResultUID [UNIQUEIDENTIFIER] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17'' )      -- new record GUID
RETURNS TABLE
AS
RETURN
(
	SELECT
		p.nPointUID,
		p.nPointOrdinal AS [ROW NUMBER],
		pes.cField009 AS [TEST STEP],
		p.cPointDescription AS [TEST DESCRIPTION],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField010, pen.nField010FormatUID, pen.nField010UnitUID) AS [FIXQ],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField029, pen.nField029FormatUID, pen.nField029UnitUID) AS [VARQ],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nLowerLimit, pun.nLowerLimitFormatUID, pun.nLowerLimitUnitUID) AS [LOWER_LIMIT],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUpperLimit, pun.nUpperLimitFormatUID, pun.nUpperLimitUnitUID) AS [UPPER_LIMIT],
		[dbo].[udf_GET_FormattedValueExWithUnit](tol.nError, tol.nErrorFormatUID, tol.nErrorUnitUID) AS [ERROR_VALUE],
		p.cPointPassFailStatus AS [TEST STATUS],
		p.cCondition AS [CONDITION],
		pes.cField011 AS [TUR],
		p.cRemarks AS [REMARK]
	FROM
		CallSheetResults csr
		LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
		LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
		LEFT JOIN PointExNumerics pen ON pen.nPointUID = p.nPointUID
		LEFT JOIN PointUncertainties pun ON pun.nPointUID = p.nPointUID
		LEFT JOIN PointTolerances tol ON tol.nPointUID = p.nPointUID
	WHERE
		csr.nCallSheetResultUID = @nCallSheetResultUID
	AND
		p.lDeleted = 0 AND p.lActive <> 0
	AND
		csr.lDeleted = 0 AND csr.lActive <> 0
);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_FullData]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_FullData]'
		
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_FullData]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_FullData]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_FullData]'

	EXEC sp_executesql N'/****************************************************************
	
    udf_GetMETCAL_Results_FullData
    Gets the MET/CAL results for the Full Data view

    Parameters:
    @nCallSheetResultUID - UID for call sheet result record

    (C) 2011-2022 Fluke Calibration
    -----------------------------------------------------------------
    CHANGE HISTORY
    05/22/2012  EdW     Initially created
    06/08/2012  EdW     Added p.nPointUID and modifed WHERE
    08/17/2012  MM      Excluded deleted records
    09/04/2012  MM      COALESCE point ordinal, nClaim (may be NULL now)
    09/11/2012  MM      COALESCE nSetTime,nCoverageFactor,nSystemCoverageFactor,
                        nConfidenceLevel,nReadingErrorPercent,nReadingErrorReferencePercent,
                        nFullScaleErrorPercent,nFullScaleErrorReferencePercent,nSetErrorPercent,
                        nSetFullScaleErrorPercent,nToleranceErrorPercent,nChiSquared
    04/08/2013  MM      Return numbers as numbers
                        Return NULL values as NULL
    08/14/2013  MM      Changed parameter to be work order result
    05/16/2014  MM      References for ftol3 and utol3 were crossed
    07/02/2014  MM      Format numeric values with the correct separator
    10/22/2015  MM      Added ManualTemplateRow
    02/25/2016  MM      Added Data Condition
    04/04/2016  MM      Changed for GUIDs
    09/21/2016  MM      Removed parent record fields from the data
    12/15/2021  AC      Changed ToleranceErrorPercent field to return >500 % when nToleranceErrorPercent > 500
	04/11/2022  AC      Place all nToleranceErrorPercent statements on a single line to support Editing Results
	10/06/2022  MM      Simplify

            NOTES: All of the statements that make up one fields formatting MUST be on a single line.
                   Test editing results in MET/TEAM after adding or altering any field.
*******************************************************************************/

CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_FullData] 
(
	@nCallSheetResultUID [UNIQUEIDENTIFIER] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17''      -- new record GUID
)
RETURNS TABLE

AS
RETURN
(
	SELECT
		p.nPointUID,
		COALESCE(mt.cTemplateName, '''') + ''  '' + COALESCE(mtr.cDescription, '''') AS [ManualTemplateRow],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nUUT, p.nUUTFormatUID, p.nUUTUnitUID) AS [UUT],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nReference, p.nReferenceFormatUID, p.nReferenceUnitUID) AS [Reference],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nCardinalPoint, p.nCardinalPointFormatUID, p.nCardinalPointUnitUID) AS [CardinalPoint],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nCorrection, p.nCorrectionFormatUID, p.nCorrectionUnitUID) AS [Correction],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nUUTRange, p.nUUTRangeFormatUID, p.nUUTRangeUnitUID) AS [UUTRange],
		[dbo].[udf_GET_FormattedValueExWithUnit](p.nSystemAccuracy, p.nSystemAccuracyFormatUID, p.nSystemAccuracyUnitUID) AS [SystemAccuracy],
		p.nPointOrdinal,
		p.tPointDateTime,
		p.cPointLabel,
		p.cPointStatusFlags,
		p.cPointPassFailStatus,
		p.cFunctionSelectCode,
		p.cPointDescription,
		p.cRemarks,
		p.cOverrideRemarks,
		p.cDesignation,
		p.cTagId,
		p.nSetTime,
		p.cCondition,
		p.nClaim,
		p.lAccredited,
		p.lPrinted,
		p.lUUTIsFixed,
		p.lOverride,
		p.lHeader,
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField001, pen.nField001FormatUID, pen.nField001UnitUID) AS [Field001],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField002, pen.nField002FormatUID, pen.nField002UnitUID) AS [Field002],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField003, pen.nField003FormatUID, pen.nField003UnitUID) AS [Field003],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField004, pen.nField004FormatUID, pen.nField004UnitUID) AS [Field004],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField005, pen.nField005FormatUID, pen.nField005UnitUID) AS [Field005],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField006, pen.nField006FormatUID, pen.nField006UnitUID) AS [Field006],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField007, pen.nField007FormatUID, pen.nField007UnitUID) AS [Field007],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField008, pen.nField008FormatUID, pen.nField008UnitUID) AS [Field008],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField009, pen.nField009FormatUID, pen.nField009UnitUID) AS [Field009],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField010, pen.nField010FormatUID, pen.nField010UnitUID) AS [Field010],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField011, pen.nField011FormatUID, pen.nField011UnitUID) AS [Field011],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField012, pen.nField012FormatUID, pen.nField012UnitUID) AS [Field012],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField013, pen.nField013FormatUID, pen.nField013UnitUID) AS [Field013],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField014, pen.nField014FormatUID, pen.nField014UnitUID) AS [Field014],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField015, pen.nField015FormatUID, pen.nField015UnitUID) AS [Field015],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField016, pen.nField016FormatUID, pen.nField016UnitUID) AS [Field016],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField017, pen.nField017FormatUID, pen.nField017UnitUID) AS [Field017],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField018, pen.nField018FormatUID, pen.nField018UnitUID) AS [Field018],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField019, pen.nField019FormatUID, pen.nField019UnitUID) AS [Field019],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField020, pen.nField020FormatUID, pen.nField020UnitUID) AS [Field020],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField021, pen.nField021FormatUID, pen.nField021UnitUID) AS [Field021],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField022, pen.nField022FormatUID, pen.nField022UnitUID) AS [Field022],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField023, pen.nField023FormatUID, pen.nField023UnitUID) AS [Field023],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField024, pen.nField024FormatUID, pen.nField024UnitUID) AS [Field024],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField025, pen.nField025FormatUID, pen.nField025UnitUID) AS [Field025],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField026, pen.nField026FormatUID, pen.nField026UnitUID) AS [Field026],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField027, pen.nField027FormatUID, pen.nField027UnitUID) AS [Field027],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField028, pen.nField028FormatUID, pen.nField028UnitUID) AS [Field028],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField029, pen.nField029FormatUID, pen.nField029UnitUID) AS [Field029],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField030, pen.nField030FormatUID, pen.nField030UnitUID) AS [Field030],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField031, pen.nField031FormatUID, pen.nField031UnitUID) AS [Field031],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField032, pen.nField032FormatUID, pen.nField032UnitUID) AS [Field032],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField033, pen.nField033FormatUID, pen.nField033UnitUID) AS [Field033],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField034, pen.nField034FormatUID, pen.nField034UnitUID) AS [Field034],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField035, pen.nField035FormatUID, pen.nField035UnitUID) AS [Field035],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField036, pen.nField036FormatUID, pen.nField036UnitUID) AS [Field036],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField037, pen.nField037FormatUID, pen.nField037UnitUID) AS [Field037],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField038, pen.nField038FormatUID, pen.nField038UnitUID) AS [Field038],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField039, pen.nField039FormatUID, pen.nField039UnitUID) AS [Field039],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField040, pen.nField040FormatUID, pen.nField040UnitUID) AS [Field040],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField041, pen.nField041FormatUID, pen.nField041UnitUID) AS [Field041],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField042, pen.nField042FormatUID, pen.nField042UnitUID) AS [Field042],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField043, pen.nField043FormatUID, pen.nField043UnitUID) AS [Field043],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField044, pen.nField044FormatUID, pen.nField044UnitUID) AS [Field044],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField045, pen.nField045FormatUID, pen.nField045UnitUID) AS [Field045],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField046, pen.nField046FormatUID, pen.nField046UnitUID) AS [Field046],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField047, pen.nField047FormatUID, pen.nField047UnitUID) AS [Field047],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField048, pen.nField048FormatUID, pen.nField048UnitUID) AS [Field048],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField049, pen.nField049FormatUID, pen.nField049UnitUID) AS [Field049],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField050, pen.nField050FormatUID, pen.nField050UnitUID) AS [Field050],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField051, pen.nField051FormatUID, pen.nField051UnitUID) AS [Field051],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField052, pen.nField052FormatUID, pen.nField052UnitUID) AS [Field052],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField053, pen.nField053FormatUID, pen.nField053UnitUID) AS [Field053],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField054, pen.nField054FormatUID, pen.nField054UnitUID) AS [Field054],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField055, pen.nField055FormatUID, pen.nField055UnitUID) AS [Field055],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField056, pen.nField056FormatUID, pen.nField056UnitUID) AS [Field056],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField057, pen.nField057FormatUID, pen.nField057UnitUID) AS [Field057],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField058, pen.nField058FormatUID, pen.nField058UnitUID) AS [Field058],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField059, pen.nField059FormatUID, pen.nField059UnitUID) AS [Field059],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField060, pen.nField060FormatUID, pen.nField060UnitUID) AS [Field060],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID, pun.nGuardBandLowerUnitUID) AS [GuardBandLower],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID, pun.nGuardBandUpperUnitUID) AS [GuardBandUpper],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertainty, pun.nUncertaintyFormatUID, pun.nUncertaintyUnitUID) AS [Uncertainty],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID, pun.nUncertaintyExpandedUnitUID) AS [UncertaintyExpanded],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyDominant, pun.nUncertaintyDominantFormatUID, pun.nUncertaintyDominantUnitUID) AS [UncertaintyDominant],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyStandard, pun.nUncertaintyStandardFormatUID, pun.nUncertaintyStandardUnitUID) AS [UncertaintyStandard],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nLowerLimit, pun.nLowerLimitFormatUID, pun.nLowerLimitUnitUID) AS [LOWER_LIMIT],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUpperLimit, pun.nUpperLimitFormatUID, pun.nUpperLimitUnitUID) AS [UPPER_LIMIT],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter1, pun.nUncertaintyParameter1FormatUID, pun.nUncertaintyParameter1UnitUID) AS [UncertaintyParameter1],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter2, pun.nUncertaintyParameter2FormatUID, pun.nUncertaintyParameter2UnitUID) AS [UncertaintyParameter2],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter3, pun.nUncertaintyParameter3FormatUID, pun.nUncertaintyParameter3UnitUID) AS [UncertaintyParameter3],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter4, pun.nUncertaintyParameter4FormatUID, pun.nUncertaintyParameter4UnitUID) AS [UncertaintyParameter4],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter5, pun.nUncertaintyParameter5FormatUID, pun.nUncertaintyParameter5UnitUID) AS [UncertaintyParameter5],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter6, pun.nUncertaintyParameter6FormatUID, pun.nUncertaintyParameter6UnitUID) AS [UncertaintyParameter6],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter7, pun.nUncertaintyParameter7FormatUID, pun.nUncertaintyParameter7UnitUID) AS [UncertaintyParameter7],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter8, pun.nUncertaintyParameter8FormatUID, pun.nUncertaintyParameter8UnitUID) AS [UncertaintyParameter8],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter9, pun.nUncertaintyParameter9FormatUID, pun.nUncertaintyParameter9UnitUID) AS [UncertaintyParameter9],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter10, pun.nUncertaintyParameter10FormatUID, pun.nUncertaintyParameter10UnitUID) AS [UncertaintyParameter10],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nModifier1, pun.nModifier1FormatUID, pun.nModifier1UnitUID) AS [Modifier1],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nModifier2, pun.nModifier2FormatUID, pun.nModifier2UnitUID) AS [Modifier2],
	    [dbo].[udf_GET_FormattedValueExWithUnit](pun.nS1, pun.nS1FormatUID, pun.nS1UnitUID) AS [S1],
	    [dbo].[udf_GET_FormattedValueExWithUnit](pun.nS2, pun.nS2FormatUID, pun.nS2UnitUID) AS [S2],
		pun.cGuardBandMethod,
		pun.cUncertaintyMethod,
		pun.nCoverageFactor,
		pun.nSystemCoverageFactor,
		pun.nConfidenceLevel,
		pun.cStudentsT,
		pun.cSensitivity1,
		pun.cSensitivity2,
		pun.cSensitivity3,
		pun.cSensitivity4,
		pun.cSensitivity5,
		pun.cSensitivity6,
		pun.cSensitivity7,
		pun.cSensitivity8,
		pun.cSensitivity9,
		pun.cSensitivity10,
		pun.cDegreesOfFreedom1,
		pun.cDegreesOfFreedom2,
		pun.cDegreesOfFreedom3,
		pun.cDegreesOfFreedom4,
		pun.cDegreesOfFreedom5,
		pun.cDegreesOfFreedom6,
		pun.cDegreesOfFreedom7,
		pun.cDegreesOfFreedom8,
		pun.cDegreesOfFreedom9,
		pun.cDegreesOfFreedom10,
		pun.cEquilibrationParameters,
		pun.lStudentsT,
		pun.lDominant,
		pun.lWelchSatterthwaite,
		pel.lField001,
		pel.lField002,
		pel.lField003,
		pel.lField004,
		pel.lField005,
		pel.lField006,
		pel.lField007,
		pel.lField008,
		pel.lField009,
		pel.lField010,
		pel.lField011,
		pel.lField012,
		pel.lField013,
		pel.lField014,
		pel.lField015,
		pel.lField016,
		pel.lField017,
		pel.lField018,
		pel.lField019,
		pel.lField020,
		pel.lField021,
		pel.lField022,
		pel.lField023,
		pel.lField024,
		pel.lField025,
		pel.lField026,
		pel.lField027,
		pel.lField028,
		pel.lField029,
		pel.lField030,
		pel.lField031,
		pel.lField032,
		pel.lField033,
		pel.lField034,
		pel.lField035,
		pel.lField036,
		pel.lField037,
		pel.lField038,
		pel.lField039,
		pel.lField040,
		pel.lField041,
		pel.lField042,
		pel.lField043,
		pel.lField044,
		pel.lField045,
		pel.lField046,
		pel.lField047,
		pel.lField048,
		pel.lField049,
		pel.lField050,
		pel.lField051,
		pel.lField052,
		pel.lField053,
		pel.lField054,
		pel.lField055,
		pel.lField056,
		pel.lField057,
		pel.lField058,
		pel.lField059,
		pel.lField060,
		[dbo].[udf_GET_FormattedValueExWithUnit](tol.nTolerance, tol.nToleranceFormatUID, tol.nToleranceUnitUID) AS [Tolerance],
		[dbo].[udf_GET_FormattedValueExWithUnit](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID, tol.nTolerancePositiveUnitUID) AS [TolerancePositive],
		[dbo].[udf_GET_FormattedValueExWithUnit](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID, tol.nToleranceNegativeUnitUID) AS [ToleranceNegative],
		[dbo].[udf_GET_FormattedValueExWithUnit](tol.nReferenceTolerance, tol.nReferenceToleranceFormatUID, tol.nReferenceToleranceUnitUID) AS [ReferenceTolerance],
		[dbo].[udf_GET_FormattedValueExWithUnit](tol.nError, tol.nErrorFormatUID, tol.nErrorUnitUID) AS [Error],
		[dbo].[udf_GET_FormattedValueExWithUnit](tol.nToleranceError, tol.nToleranceErrorFormatUID, tol.nToleranceErrorUnitUID) AS [ToleranceError],
		[dbo].[udf_GET_FormattedValueEx](tol.nReadingErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)) + CASE WHEN tol.nReadingErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [ReadingErrorPercent],
		[dbo].[udf_GET_FormattedValueEx](tol.nReadingErrorReferencePercent, [dbo].[udf_GET_nFormatUIDFromScale](0)) + CASE WHEN tol.nReadingErrorReferencePercent IS NULL THEN '''' ELSE '' %'' END AS [ReadingErrorReferencePercent],
		[dbo].[udf_GET_FormattedValueEx](tol.nFullScaleErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)) + CASE WHEN tol.nFullScaleErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [FullScaleErrorPercent],
		[dbo].[udf_GET_FormattedValueEx](tol.nFullScaleErrorReferencePercent, [dbo].[udf_GET_nFormatUIDFromScale](0)) + CASE WHEN tol.nFullScaleErrorReferencePercent IS NULL THEN '''' ELSE '' %'' END AS [FullScaleErrorReferencePercent],
		[dbo].[udf_GET_FormattedValueEx](tol.nSetErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)) + CASE WHEN tol.nSetErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [SetErrorPercent],
		[dbo].[udf_GET_FormattedValueEx](tol.nSetFullScaleErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)) + CASE WHEN tol.nSetFullScaleErrorPercent IS NULL THEN '''' ELSE '' %'' END AS [SetFullScaleErrorPercent],
		CASE WHEN tol.nToleranceErrorPercent > 500 THEN ''>500 %'' ELSE [dbo].[udf_GET_FormattedValueEx](tol.nToleranceErrorPercent, [dbo].[udf_GET_nFormatUIDFromScale](0)) + CASE WHEN tol.nToleranceErrorPercent IS NULL THEN '''' ELSE '' %'' END END AS [ToleranceErrorPercent],
		tol.cToleranceReference,
		pes.cField001,
		pes.cField002,
		pes.cField003,
		pes.cField004,
		pes.cField005,
		pes.cField006,
		pes.cField007,
		pes.cField008,
		pes.cField009,
		pes.cField010,
		pes.cField011,
		pes.cField012,
		pes.cField013,
		pes.cField014,
		pes.cField015,
		pes.cField016,
		pes.cField017,
		pes.cField018,
		pes.cField019,
		pes.cField020,
		pes.cField021,
		pes.cField022,
		pes.cField023,
		pes.cField024,
		pes.cField025,
		pes.cField026,
		pes.cField027,
		pes.cField028,
		pes.cField029,
		pes.cField030,
		pes.cField031,
		pes.cField032,
		pes.cField033,
		pes.cField034,
		pes.cField035,
		pes.cField036,
		pes.cField037,
		pes.cField038,
		pes.cField039,
		pes.cField040,
		pes.cField041,
		pes.cField042,
		pes.cField043,
		pes.cField044,
		pes.cField045,
		pes.cField046,
		pes.cField047,
		pes.cField048,
		pes.cField049,
		pes.cField050,
		pes.cField051,
		pes.cField052,
		pes.cField053,
		pes.cField054,
		pes.cField055,
		pes.cField056,
		pes.cField057,
		pes.cField058,
		pes.cField059,
		pes.cField060,
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nMinimumUUT, stat.nMinimumUUTFormatUID, stat.nMinimumUUTUnitUID) AS [MinimumUUT],
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nMaximumUUT, stat.nMaximumUUTFormatUID, stat.nMaximumUUTUnitUID) AS [MaximumUUT],
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nMinimumReference, stat.nMinimumReferenceFormatUID, stat.nMinimumReferenceUnitUID) AS [MinimumReference],
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nMaximumReference, stat.nMaximumReferenceFormatUID, stat.nMaximumReferenceUnitUID) AS [MaximumReference],
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nUUTStandardDeviation, stat.nUUTStandardDeviationFormatUID, stat.nUUTStandardDeviationUnitUID) AS [UUTStandardDeviation],
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nUUTRawStandardDeviation, stat.nUUTRawStandardDeviationFormatUID, stat.nUUTRawStandardDeviationUnitUID) AS [UUTRawStandardDeviation],
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nReferenceStandardDeviation, stat.nReferenceStandardDeviationFormatUID, stat.nReferenceStandardDeviationUnitUID) AS [ReferenceStandardDeviation],
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nReference2StandardDeviation, stat.nReference2StandardDeviationFormatUID, stat.nReference2StandardDeviationUnitUID) AS [Reference2StandardDeviation],
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nReferenceRawStandardDeviation, stat.nReferenceRawStandardDeviationFormatUID, stat.nReferenceRawStandardDeviationUnitUID) AS [ReferenceRawStandardDeviation],
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nReferenceRaw2StandardDeviation, stat.nReferenceRaw2StandardDeviationFormatUID, stat.nReferenceRaw2StandardDeviationUnitUID) AS [ReferenceRaw2StandardDeviation],
		[dbo].[udf_GET_FormattedValueExWithUnit](stat.nSampleRate, stat.nSampleRateFormatUID, stat.nSampleRateUnitUID) AS [SampleRate],
		stat.nNumberOfSamplesReference,
		stat.nNumberOfSamplesUUT,
		stat.nNumberOfSamplesDiscarded,
		stat.nChiSquared,
		stat.lNoisy,
		stat.lReliable
	FROM
		CallSheetResults csr
		LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
		LEFT JOIN PointExNumerics pen ON pen.nPointUID = p.nPointUID
		LEFT JOIN PointUncertainties pun ON pun.nPointUID = p.nPointUID
		LEFT JOIN PointExLogicals pel ON pel.nPointUID = p.nPointUID
		LEFT JOIN PointTolerances tol ON tol.nPointUID = p.nPointUID
		LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
		LEFT JOIN PointStatistics stat ON stat.nPointUID = p.nPointUID
		LEFT JOIN ManualTemplateRows mtr ON p.nManualTemplateRowUID = mtr.nManualTemplateRowUID
		LEFT JOIN ManualTemplates mt ON mtr.nManualTemplateUID = mt.nManualTemplateUID
	WHERE
		csr.nCallSheetResultUID = @nCallSheetResultUID
	AND
		p.lDeleted = 0 AND p.lActive <> 0
);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_MeasUncert]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_MeasUncert]'
		
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_MeasUncert]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_MeasUncert]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_MeasUncert]'

		EXEC sp_executesql N'/******************************************************************************
	
    udf_GetMETCAL_Results_MeasUncert
    Gets the MET/CAL results for the Measurement Uncertainty view

    Parameters:
    @nCallSheetResultUID - UID for call sheet result record

    (C) 2011-2022 Fluke Calibration
    -----------------------------------------------------------------
    CHANGE HISTORY
    05/22/2012  EdW     Initially created
    06/08/2012  EdW     Added p.nPointUID, COALESCE for pes.cField009,
                        and modifed WHERE
    08/17/2012  MM      Excluded deleted records
    09/04/2012  MM      COALESCE point ordinal (may be NULL now)
    09/11/2012  MM      COALESCE nCoverageFactor
    03/18/2013  MM      Added csr.cDescription for tagged procedures
                        Exclude deleted call sheet results
    04/08/2013  MM      Return numbers as numbers
                        Return NULL values as NULL
    08/14/2013  MM      Changed parameter to be work order result
    07/02/2014  MM      Format numeric values with the correct separator
    04/04/2016  MM      Changes for GUIDs
    09/21/2016  MM      Removed parent record fields from the data
    10/06/2022  MM      Simplify

            NOTES: All of the statements that make up one fields formatting MUST be on a single line.
                   Test editing results in MET/TEAM after adding or altering any field.
********************************************************************************/

CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_MeasUncert] 
(
	@nCallSheetResultUID [UNIQUEIDENTIFIER] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17''      -- new record GUID
)
RETURNS TABLE

AS
RETURN
(
	SELECT
		p.nPointUID,
		p.nPointOrdinal AS [ROW NUMBER],
		pes.cField009 AS [TEST STEP],
		p.cPointDescription AS [TEST DESCRIPTION],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyStandard, pun.nUncertaintyStandardFormatUID, pun.nUncertaintyStandardUnitUID) AS [STD_UNCERT],
		[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID, pun.nUncertaintyExpandedUnitUID) AS [EXP_UNCERT],
		[dbo].[udf_GET_FormattedValueEx](pun.nCoverageFactor,[dbo].[udf_GET_nFormatUIDFromScale](2)) AS [COVERAGE FACTOR],
		pun.cUncertaintyMethod AS [UNCERTAINTY METHOD],
		ps.nNumberOfSamplesUUT AS [NUMBER OF MEASUREMENTS],
		[dbo].[udf_GET_FormattedValueExWithUnit](ps.nUUTStandardDeviation, ps.nUUTStandardDeviationFormatUID, ps.nUUTStandardDeviationUnitUID) AS [STANDARD DEVIATION]
	FROM
		CallSheetResults csr
		LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
		LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
		LEFT JOIN PointUncertainties pun ON pun.nPointUID = p.nPointUID
		LEFT JOIN PointStatistics ps ON ps.nPointUID = p.nPointUID
	WHERE
		csr.nCallSheetResultUID = @nCallSheetResultUID
	AND
		p.lDeleted = 0 AND p.lActive <> 0
	AND
		csr.lDeleted = 0 AND csr.lActive <> 0
);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END	


	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_ProcedureSteps]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetMETCAL_Results_ProcedureSteps]'
		
		DROP FUNCTION [dbo].[udf_GetMETCAL_Results_ProcedureSteps]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetMETCAL_Results_ProcedureSteps]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetMETCAL_Results_ProcedureSteps]'

		EXEC sp_executesql N'/***************************************************************************************************
    udf_GetMETCAL_Results_ProcedureSteps
    
    Gets the MET/CAL results data for the Procedure Steps view

    Parameters:
    @nCallSheetResultUID - UID for call sheet result record

    (C) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
    CHANGE HISTORY
    05/22/2012  EdW      Initially created
    06/08/2012  EdW      Added p.nPointUID, COALESCE for pes.cField009,
                         and modifed WHERE
    08/17/2012  MM       Excluded deleted records
    09/04/2012  MM       COALESCE point ordinal (may be NULL now)
    03/18/2013  MM       Added csr.cDescription for tagged procedures
                         Exclude deleted call sheet results
    08/14/2013  MM       Changed parameter to be work order result
    07/02/2014  MM       Format numeric values with the correct separator
    04/04/2016  MM       Changes for GUIDs
    09/21/2016  MM       Removed parent record fields from the data
    10/06/2022  MM       Simplify

            NOTES: All of the statements that make up one fields formatting MUST be on a single line.
                   Test editing results in MET/TEAM after adding or altering any field.
*****************************************************************************************************/

CREATE FUNCTION [dbo].[udf_GetMETCAL_Results_ProcedureSteps] 
(
	@nCallSheetResultUID [UNIQUEIDENTIFIER] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17''      -- new record GUID
)
RETURNS TABLE

AS
RETURN
(
	SELECT
		p.nPointUID,
		p.nPointOrdinal AS [ROW NUMBER],
		pes.cField009 AS [TEST STEP],
		p.cPointDescription AS [TEST DESCRIPTION],
		p.cPointPassFailStatus AS [TEST STATUS],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField010, pen.nField010FormatUID, pen.nField010UnitUID) AS [FIXQ],
		[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField029, pen.nField029FormatUID, pen.nField029UnitUID) AS [VARQ],
		p.cFunctionSelectCode AS [FUNCTION SELECT CODE],
		p.cPointLabel AS [RESULT TYPE],
		pes.cField011 AS [TUR]
	FROM
		CallSheetResults csr
		LEFT JOIN Points p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
		LEFT JOIN PointExStrings pes ON pes.nPointUID = p.nPointUID
		LEFT JOIN PointExNumerics pen ON pen.nPointUID = p.nPointUID
	WHERE
		csr.nCallSheetResultUID = @nCallSheetResultUID
	AND
		p.lDeleted = 0 AND p.lActive <> 0
	AND
		csr.lDeleted = 0 AND csr.lActive <> 0
);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	IF OBJECT_ID(N'[dbo].[udf_GetPointReadings]', 'IF') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GetPointReadings]'
		
		DROP FUNCTION [dbo].[udf_GetPointReadings]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GetPointReadings]', 'IF') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GetPointReadings]'

		EXEC sp_executesql N'/************************************************************************************************
    udf_GetPointReadings
    
    Gets the indvidual measurements (readings) that were averaged
    when the parent Points record was created

    Parameters:
    @nPointUID - UID for the Points record

    (C) 2014-22 Fluke Calibration
-----------------------------------------------------------------
    CHANGE HISTORY
    10/31/2014  MM    Initially created
    04/04/2016  MM    Changes for GUIDs
    09/21/2016  MM    Removed parent record fields from the data
    10/06/2022  MM    Simplify
    
    NOTES: All of the statements that make up one fields formatting MUST be on a single line.
       Test editing point readings in MET/TEAM after adding or altering any field.
*************************************************************************************************/

CREATE FUNCTION [dbo].[udf_GetPointReadings] ( @nPointUID [UNIQUEIDENTIFIER] = ''4CA22A04-0079-4033-84A5-E5968C7F3F17'' )      -- new record GUID
RETURNS TABLE
AS
RETURN
(
	SELECT
		pr.nPointReadingUID,
		ass.cBarcode,
		[dbo].[udf_GET_FormattedValueExWithUnit](pr.nReading, pr.nReadingFormatUID, pr.nReadingUnitUID) AS [Measurement],
		pr.tReadingDateTime,
		pr.nReadingOrdinal,
		pr.cReadingUnit,
		pr.cReadingLabel,
		pr.cReadingType
	FROM
		PointReadings pr
		JOIN Points p ON p.nPointUID = pr.nPointUID
		LEFT JOIN Assets ass ON ass.nAssetUID = pr.nAssetUID
	WHERE
		p.nPointUID = @nPointUID
	AND
		pr.lDeleted = 0 AND pr.lActive <> 0
	AND
		p.lDeleted = 0 AND p.lActive <> 0
);'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END	



	IF OBJECT_ID(N'[dbo].[vw_ManualTemplateInfo]', 'V') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[vw_ManualTemplateInfo]'
		
		DROP VIEW [dbo].[vw_ManualTemplateInfo]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
	
	IF OBJECT_ID(N'[dbo].[vw_ManualTemplateInfo]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_ManualTemplateInfo]'

		EXEC sp_executesql N'/****************************************************************
	vw_ManualTemplateInfo
	
	Gets formatted manual template info for reporting

	(C) 2014-22 Fluke Calibration
-----------------------------------------------------------------
	CHANGE HISTORY
	05/20/2014  MM      Initially created
	03/11/2015  MM      Exclude deleted rows
	11/10/2020  MM      Exclude units for empty limit values
	10/06/2022  MM      Simplify
*****************************************************************/
CREATE VIEW [dbo].[vw_ManualTemplateInfo]
AS
	SELECT
		[mt].[nManualTemplateUID]
		,[mt].[cTemplateName]
		,[mt].[mNotes]
		,[mt].[lAllowActual]
		,[mt].[lIsTransducer]
		,[mtr].[nManualTemplateRowUID]
		,[mtr].[nNominalUnitUID]
		,[mtr].[nRefUnitUID]
		,[mtr].[cDescription]
		,[mtr].[cLabel]
		,[mtr].[cNominal]
		,CASE WHEN [mtr].[nRowType] IN (1,2,3,10,11,12) THEN [dbo].[udf_GET_FormattedValueExWithUnit]([mtr].[cNominal], [dbo].[udf_GET_nFormatUIDFromScale]([mtr].[nResolution]), [mtr].[nNominalUnitUID]) ELSE '''' END AS [Nominal]
		,[mtr].[cRefNominal] 
		,CASE WHEN [mt].[lIsTransducer] <> 0 AND [mtr].[nRowType] IN (1,2,3,10,11,12) THEN [dbo].[udf_GET_FormattedValueExWithUnit]([mtr].[cRefNominal], [dbo].[udf_GET_nFormatUIDFromScale]([mtr].[nResolution]), [mtr].[nRefUnitUID]) ELSE '''' END AS [RefNominal]
		,[mtr].[cStep]
		,[mtr].[cUncertaintyNotes]
		,[mtr].[nLowerLimit]
		,CASE WHEN [mtr].[nRowType] IN (1,3) THEN [dbo].[udf_GET_FormattedValueExWithUnit]([mtr].[nLowerLimit], [dbo].[udf_GET_nFormatUIDFromScale]([mtr].[nResolution]), [mtr].[nNominalUnitUID])
		ELSE CASE WHEN [mtr].[nRowType] IN (10,12) THEN [dbo].[udf_GET_FormattedValueExWithUnit]([mtr].[nLowerLimit], [dbo].[udf_GET_nFormatUIDFromScale]([mtr].[nResolution]), [mtr].[nRefUnitUID])
		ELSE  '''' END END AS [LowerLimit]
		,[mtr].[nOrdinal]
		,[mtr].[nResolution]
		,[mtr].[nRowType]
		,[mtr].[nTur]
		,[mtr].[nUncertainty]
		,[mtr].[nUpperLimit]
		,CASE WHEN [mtr].[nRowType] IN (1,2) THEN [dbo].[udf_GET_FormattedValueExWithUnit]([mtr].[nUpperLimit], [dbo].[udf_GET_nFormatUIDFromScale]([mtr].[nResolution]), [mtr].[nNominalUnitUID])
		ELSE CASE WHEN [mtr].[nRowType] IN (10,11) THEN [dbo].[udf_GET_FormattedValueExWithUnit]([mtr].[nUpperLimit], [dbo].[udf_GET_nFormatUIDFromScale]([mtr].[nResolution]), [mtr].[nRefUnitUID])
		ELSE  '''' END END AS [UpperLimit]
		,[mtr].[lUUTIsSource]
	FROM
	  	[dbo].[ManualTemplates] mt
	JOIN
	  	[dbo].[ManualTemplateRows] mtr
	ON
	  	[mt].[nManualTemplateUID] = [mtr].[nManualTemplateUID]
	WHERE
		[mt].[lActive] <> 0
	AND
		[mt].[lDeleted] = 0
	AND
		[mtr].[lActive] <> 0
	AND
		[mtr].[lDeleted] = 0
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END	


	IF OBJECT_ID(N'[dbo].[Ver_8_Cert_Sp]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[Ver_8_Cert_Sp]'
		
		DROP PROCEDURE [dbo].[Ver_8_Cert_Sp]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
	
	IF OBJECT_ID(N'[dbo].[Ver_8_Cert_Sp]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[Ver_8_Cert_Sp]'

		EXEC sp_executesql N'
    -- ==============================================================================
    -- Author:      Fluke Calibration
    -- Create date: 20120504
    -- Description: MET/TEAM Certificates Stored Procedure
    -- Notes:       Compatibility with MET/TRACK report fields
    --
    -- Updated:     20120716 Parameter name changed, re-runnable script
    --              20120720 Bug fixes in mapping, remove cfg view link
    --              20120730 Bug fixes in mapping
    --              20120801 Remove N/A
    --              20120809 Add CallSheetResults workstation and description
    --                       Order by nCallSheetResultUID, then nPointOrdinal
    --              20120814 Added procedure used in CallSheetResults
    --                       Added nCallSheetResultUID, for breaking down points
    --              20120817 Added cPointPassFailStatus
    --              20120817 Exclude deleted points
    --              20120904 COALESCE point ordinal (may be NULL now)
    --              20130325 fixed manufacturer linkage (nManufacturerUID)
    --              20130329 Added Procedure .cVersion and .cRevision
    --              20130724 Use udf_GET_FormattedValue to format values
    --              20130806 Callsheet notes sometimes truncated after 32 characters
    --              20130822 Add data condition (cCallSheetResultType)
    --                       and a few more fields from CallSheetResults
    --              20140515 Use udf_GET_FormattedValueEx for getting values
    --                       Use udf_GET_Unit for getting units, eliminating 61 JOINs
    --                       Use udf_GET_User and udf_GET_UserFull for getting users
    --                       eliminating another 11 JOINs
    --              20150129 Only include tool assignment records where the
    --                       return date is null
    --              20150119 C2341 was truncated at 30 chars
    --              20150218 Exclude deleted work order results
    --              20150715 Remove obsolete columns from Assets table
    --              20150911 Fixed incorrect returned column for meas_flag
    --              20160317 Filter out inactive and deleted addresses
    --              20160317 Filter out deleted tool assignments
    --              20160526 changes for GUIDs, adjust conversions to NVARCHAR
    --              20190718 Added nPointUID
    --              20210720 Remap C2321 to CallSheetEx.cField5
    --              20221006 Simplify
    -- ==============================================================================
    CREATE PROCEDURE [dbo].[Ver_8_Cert_Sp]
        @nCallSheetUID [UNIQUEIDENTIFIER]
    AS
    BEGIN
        -- SET NOCOUNT ON added to prevent extra result sets from
        -- interfering with SELECT statements.
        SET NOCOUNT ON;
        
    SELECT
	    CONVERT(NVARCHAR(36), cs.nCallSheetUID) AS [Calibration_CTAG]
	    ,COALESCE(CONVERT(NVARCHAR(36),csr.nCallSheetUID),'''') AS [Results_ctag]
	    ,COALESCE(p.nPointOrdinal, 0) AS [row_num]
	    ,cs.tMaintDate AS [C2301]
	    ,COALESCE(cs.cInterval, '''') AS [C2302]
	    ,cs.tMaintNextDate AS [C2303]
	    ,COALESCE(cs.cCallSheetNumber, '''') AS [C2304]
	    ,COALESCE(csx.cField1, '''') AS [C2306]
	    ,[dbo].[udf_GET_User](cs.nAssignedTechUID) AS [C2307]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField1),'''') AS [C2309]
	    ,COALESCE(CONVERT(NVARCHAR,cs.nCost),'''') AS [C2310]
	    ,COALESCE(cs.cTemperature, '''') AS [C2311]
	    ,COALESCE(cs.cHumidity, '''') AS [C2312]
	    ,COALESCE(wf.cFacilityName, '''') AS [C2313]
	    ,COALESCE(csx.cField2, '''') AS [C2314]
	    ,cs.tOpenDate AS [C2316]
	    ,COALESCE(pr.cProcedureName, '''') AS [C2320]
	    ,COALESCE(csx.cField5, '''') AS [C2321]
	    ,COALESCE(CONVERT(NVARCHAR,csx.lField4),'''') AS [C2322]
	    ,COALESCE(cs.cWorkOrderResults,'''') AS [C2323]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField4),'''') AS [C2324]
	    ,COALESCE(cs.mOOTNotes, '''') AS [C2326]
	    ,[dbo].[udf_GET_User](cs.nTechnicianUID) AS [C2327]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField5),'''') AS [C2328]
	    ,COALESCE(csx.cField6, '''') AS [C2329]
	    ,COALESCE(csx.cField7, '''') AS [C2330]
	    ,COALESCE(cs.cIntervalUOM,'''') AS [C2331]
	    ,''NOT IMPLEMENTED'' AS [C2332]
	    ,cs.tMaintDate AS [C2333]
	    ,cs.tMaintNextDate AS [C2334]
	    ,cs.tAddTime AS [C2335]
	    ,[dbo].[udf_GET_User](cs.nTechnicianUID) AS [C2336]
	    ,cs.tUpdateTime AS [C2337]
	    ,[dbo].[udf_GET_User](cs.nUpdateUserUID) AS [C2338]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField6),'''') AS [C2339]
	    ,RTRIM(SUBSTRING(COALESCE(cs.mCallSheetNotes,''''),0,254)) AS [C2341]
	    ,COALESCE(CONVERT(NVARCHAR(36),cs.nAssetUID),'''') AS [Calibration_MTAG]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField15),'''') AS [C2362]
	    ,COALESCE(cs.cInitialCondition, '''') AS [C2308]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField3), '''') AS [C2315]
	    ,COALESCE(CONVERT(NVARCHAR,csx.tField6), '''') AS [C2342]
	    ,COALESCE(CONVERT(NVARCHAR,csx.tField6), '''') AS [C2343]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField29),'''') AS [C2317]
	    ,COALESCE(csx.cField4, '''') AS [C2318]
	    ,COALESCE(CONVERT(NVARCHAR,csx.lField3),'''') AS [C2319]
	    ,COALESCE(CONVERT(NVARCHAR,csx.lField6),'''') AS [C2325]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField11),'''') AS [C2350]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField12),'''') AS [C2351]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField13),'''') AS [C2352]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField14),'''') AS [C2353]
	    ,COALESCE(csx.cField17, '''') AS [C2354]
	    ,COALESCE(csx.cField18, '''') AS [C2355]
	    ,COALESCE(csx.cField19, '''') AS [C2356]
	    ,COALESCE(csx.cField20, '''') AS [C2357]
	    ,COALESCE(csx.cField21, '''') AS [C2358]
	    ,COALESCE(csx.cField22, '''') AS [C2359]
	    ,COALESCE(csx.cField23, '''') AS [C2360]
	    ,COALESCE(csx.cField24, '''') AS [C2361]
	    ,COALESCE(CONVERT(NVARCHAR,cs.lCancelled),'''') AS [C2363]
	    ,COALESCE(csx.cField3, '''') AS [cdsrc]
	    ,COALESCE(CONVERT(NVARCHAR,csx.tField5), '''') AS [C2381]
	    ,COALESCE(CONVERT(NVARCHAR,csx.lField7),'''') AS [C2382]
	    ,COALESCE(csx.cField8, '''') AS [C2364]
	    ,COALESCE(csx.cField9, '''') AS [C2365]
	    ,COALESCE(csx.cField10, '''') AS [C2366]
	    ,COALESCE(csx.cField11, '''') AS [C2367]
	    ,COALESCE(csx.cField12, '''') AS [C2368]
	    ,COALESCE(csx.cField13, '''') AS [C2369]
	    ,COALESCE(csx.cField14, '''') AS [C2370]
	    ,COALESCE(CONVERT(NVARCHAR,csx.tField1), '''') AS [C2371]
	    ,COALESCE(CONVERT(NVARCHAR,csx.tField2), '''') AS [C2372]
	    ,COALESCE(CONVERT(NVARCHAR,csx.tField3), '''') AS [C2373]
	    ,COALESCE(CONVERT(NVARCHAR,csx.tField4), '''') AS [C2374]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField16),'''') AS [C2375]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField17),'''') AS [C2376]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField18),'''') AS [C2377]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField19),'''') AS [C2378]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField20),'''') AS [C2379]
	    ,COALESCE(CONVERT(NVARCHAR,csx.tField5), '''') AS [C2380]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField21),'''') AS [C2383]
	    ,COALESCE(csx.mField1, '''') AS [C2384]
	    ,COALESCE(csx.cField26, '''') AS [C2385]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField7),'''') AS [C2344]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField8),'''') AS [C2345]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField9),'''') AS [C2346]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField10),'''') AS [C2347]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField22),'''') AS [C2386]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField23),'''') AS [C2387]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField24),'''') AS [C2388]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField25),'''') AS [C2389]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField26),'''') AS [C2390]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField27),'''') AS [C2391]
	    ,COALESCE(CONVERT(NVARCHAR,csx.nField28),'''') AS [C2392]
	    ,COALESCE(CONVERT(NVARCHAR,csx.lField8),'''') AS [C2393]
	    ,COALESCE(CONVERT(NVARCHAR,csx.lField9),'''') AS [C2394]
	    ,COALESCE(cs.cCertificationNumber, '''') AS [C2395]
	    ,COALESCE(jn.cJobOrderNumber, '''') AS [C2396]
	    ,CONVERT(NVARCHAR(36), cust.nFacilityUID) AS [Customers_KTAG]
	    ,COALESCE(cust.cFacilityNumber, '''') AS [K4601]
	    ,COALESCE(cust.cFacilityName, '''') AS [K4602]
	    ,COALESCE(da.cAddress1, '''') AS [K4603]
	    ,COALESCE(da.cCity, '''') AS [K4604]
	    ,COALESCE(da.cState, '''') AS [K4605]
	    ,COALESCE(da.cZip, '''') AS [K4606]
	    ,COALESCE(da.cAddress1, '''') AS [K4607]
	    ,COALESCE(da.cCity, '''') AS [K4608]
	    ,COALESCE(da.cState, '''') AS [K4609]
	    ,COALESCE(da.cZip, '''') AS [K4610]
	    ,COALESCE(CONVERT(NVARCHAR,cust.lNoTax),'''') AS [K4611]
	    ,COALESCE(custEx.cField1, '''') AS [K4612]
	    ,COALESCE(custEx.cField2, '''') AS [K4613]
	    ,COALESCE(custEx.cField3, '''') AS [K4614]
	    ,COALESCE(custEx.cField4, '''') AS [K4615]
	    ,COALESCE(custEx.cField5, '''') AS [K4616]
	    ,COALESCE(custEx.cField6, '''') AS [K4617]
	    ,COALESCE(custEx.cField7, '''') AS [K4618]
	    ,COALESCE(custEx.cField8, '''') AS [K4619]
	    ,COALESCE(custEx.cField9, '''') AS [K4620]
	    ,COALESCE(CONVERT(NVARCHAR,custEx.tField1), '''') AS [K4621]
	    ,COALESCE(CONVERT(NVARCHAR,custEx.tField2), '''') AS [K4622]
	    ,COALESCE(CONVERT(NVARCHAR,custEx.tField3), '''') AS [K4623]
	    ,COALESCE(CONVERT(NVARCHAR,custEx.tField4), '''') AS [K4624]
	    ,COALESCE(CONVERT(NVARCHAR,custEx.nField1),'''') AS [K4625]
	    ,COALESCE(CONVERT(NVARCHAR,custEx.nField2),'''') AS [K4626]
	    ,COALESCE(CONVERT(NVARCHAR,custEx.nField3),'''') AS [K4627]
	    ,COALESCE(CONVERT(NVARCHAR,custEx.nField4),'''') AS [K4628]
	    ,COALESCE(CONVERT(NVARCHAR(36),cust.nParentFacilityUID),'''') AS [K4640]
	    ,cust.tAddTime AS [K4629]
	    ,[dbo].[udf_GET_User](cust.nAddUserUID) AS [K4630]
	    ,cust.tUpdateTime AS [K4631]
	    ,[dbo].[udf_GET_User](cust.nUpdateUserUID) AS [K4632]
	    ,COALESCE(custEx.cField15, '''') AS [KDSRC]
	    ,COALESCE(CONVERT(NVARCHAR,custEx.lField1),'''') AS [kreplic]
	    ,COALESCE(custEx.cField10, '''') AS [K4633]
	    ,COALESCE(custEx.cField11, '''') AS [K4634]
	    ,COALESCE(custEx.cField12, '''') AS [K4635]
	    ,COALESCE(custEx.cField13, '''') AS [K4636]
	    ,COALESCE(custEx.cField14, '''') AS [K4637]
	    ,COALESCE(ass.cID, '''') AS [I4201]
	    ,COALESCE(assg.cFacilityName, '''') AS [I4202]
	    ,COALESCE(ass.cModelNumber, '''') AS [I4203]
	    ,COALESCE(ass.cDescription, '''') AS [I4204]
	    ,COALESCE(assx.cField14, '''') AS [I4205]
	    ,COALESCE(ass.cSerialNumber, '''') AS [I4206]
	    ,COALESCE(assx.cField15, '''') AS [I4207]
	    ,COALESCE(assx.cField16, '''') AS [I4208]
	    ,COALESCE(assx.cField33, '''') AS [I4209]
	    ,COALESCE(assx.cField17, '''') AS [I4210]
	    ,COALESCE(assx.cField18, '''') AS [I4211]
	    ,COALESCE(CONVERT(NVARCHAR,assx.tField5), '''') AS [I4212]
	    ,COALESCE(assx.cField19, '''') AS [I4213]
	    ,COALESCE(ass.cPhysicalLocation, '''') AS [I4214]
	    ,COALESCE(assx.cField20, '''') AS [I4215]
	    ,COALESCE(assx.cField21, '''') AS [I4216]
	    ,COALESCE(assx.cField22, '''') AS [I4217]
	    ,COALESCE(dept.cFacilityName, '''') AS [I4218]
	    ,COALESCE(CONVERT(NVARCHAR,ass.nItemCost),'''') AS [I4219]
	    ,COALESCE(assx.cField6, '''') AS [I4220]
	    ,ass.tPurchaseDate AS [I4221]
	    ,COALESCE(assx.cField7, '''') AS [I4222]
	    ,COALESCE(assx.cField25, '''') AS [I4223]
	    ,COALESCE(CONVERT(NVARCHAR,assx.tField5), '''') AS [I4224]
	    ,COALESCE(ass.cStatus, '''') AS [I4225]
	    ,COALESCE(assx.lField1, '''') AS [I4226]
	    ,'''' AS [I4228]
	    ,'''' AS [I4229]
	    ,COALESCE(CONVERT(NVARCHAR,ass.nUseCount),'''') AS [I4230]
	    ,COALESCE(assx.cField1, '''') AS [I4231]
	    ,COALESCE(assx.cField2, '''') AS [I4232]
	    ,COALESCE(assx.cField3, '''') AS [I4233]
	    ,COALESCE(assx.cField4, '''') AS [I4234]
	    ,COALESCE(assx.cField5, '''') AS [I4235]
	    ,ass.tAddTime AS [I4236]
	    ,[dbo].[udf_GET_User](ass.nAddUserUID) AS [I4237]
	    ,ass.tUpdateTime AS [I4238]
	    ,[dbo].[udf_GET_User](ass.nUpdateUserUID) AS [I4239]
	    ,COALESCE(lab.cFacilityName, '''') AS [I4240]
	    ,COALESCE(ass.cDisposition, '''') AS [I4299]
	    ,COALESCE(CONVERT(NVARCHAR(36),ass.nAssetUID),'''') AS [Inventory_MTAG]
	    ,COALESCE(assx.cField23, '''') AS [I4241]
	    ,COALESCE(assx.cField24, '''') AS [I4242]
	    ,COALESCE(assx.cField26, '''') AS [I4243]
	    ,COALESCE(assx.cField29, '''') AS [idsrc]
	    ,COALESCE(CONVERT(NVARCHAR(36),ass.nFacilityUID),'''') AS [Inventory_ktag]
	    ,COALESCE(assx.cField27, '''') AS [replic]
	    ,COALESCE(CONVERT(NVARCHAR,ass.lInAbeyance),'''') AS [I4258]
	    ,COALESCE(assx.cField8, '''') AS [I4244]
	    ,COALESCE(assx.cField9, '''') AS [I4245]
	    ,COALESCE(assx.cField10, '''') AS [I4246]
	    ,COALESCE(assx.cField11, '''') AS [I4247]
	    ,COALESCE(assx.cField12, '''') AS [I4248]
	    ,COALESCE(assx.cField13, '''') AS [I4249]
	    ,COALESCE(CONVERT(NVARCHAR,assx.tField1), '''') AS [I4250]
	    ,COALESCE(CONVERT(NVARCHAR,assx.tField2), '''') AS [I4251]
	    ,COALESCE(CONVERT(NVARCHAR,assx.tField3), '''') AS [I4252]
	    ,COALESCE(CONVERT(NVARCHAR,assx.tField4), '''') AS [I4253]
	    ,COALESCE(CONVERT(NVARCHAR,assx.nField1),'''') AS [I4254]
	    ,COALESCE(CONVERT(NVARCHAR,assx.nField2),'''') AS [I4255]
	    ,COALESCE(CONVERT(NVARCHAR,assx.nField3),'''') AS [I4256]
	    ,COALESCE(CONVERT(NVARCHAR,assx.nField4),'''') AS [I4257]
	    ,COALESCE(CONVERT(NVARCHAR,ass.nAbeyanceInterval),'''') AS [I4259]
	    ,COALESCE(ass.mNotes, '''') AS [I4260]
	    ,COALESCE(assx.cField31, '''') AS [I4261]
	    ,COALESCE(assx.cField32, '''') AS [I4262]
	    ,COALESCE(tac.cFirstName, '''') + '' '' + COALESCE(tac.cMiddleName, '''') + '' '' + COALESCE(tac.cLastName, '''') AS [L2801]
	    ,COALESCE(ta.cAssignedLocation, '''') AS [L2802]
	    ,COALESCE(tax.cField11, '''') AS [L2803]
	    ,COALESCE(tax.cField12, '''') AS [L2804]
	    ,COALESCE(tax.cField13, '''') AS [L2805]
	    ,ta.tReturnDate AS [L2806]
	    ,COALESCE(CONVERT(NVARCHAR,tax.tField5), '''') AS [L2807]
	    ,COALESCE(CONVERT(NVARCHAR,ta.nUseCount),'''') AS [L2808]
	    ,ta.tLoanDate AS [L2809]
	    ,ta.tLoanDate AS [L2810]
	    ,ta.tAddTime AS [L2811]
	    ,[dbo].[udf_GET_User](ta.nAddUserUID) AS [L2812]
	    ,ta.tUpdateTime AS [L2813]
	    ,[dbo].[udf_GET_User](ta.nUpdateUserUID) AS [L2814]
	    ,COALESCE(CONVERT(NVARCHAR,ta.lActive),'''') AS [L2815]
	    ,COALESCE(CONVERT(NVARCHAR(36),ta.nAssetUID),'''') AS [Location_MTAG]
	    ,COALESCE(CONVERT(NVARCHAR(36),ta.nToolAssignmentUID),'''') AS [ltag]
	    ,COALESCE(tax.cField15, '''') AS [ldsrc]
	    ,COALESCE(tax.cField14, '''') AS [L2816]
	    ,COALESCE(CONVERT(NVARCHAR,tax.nField5),'''') AS [L2817]
	    ,COALESCE(CONVERT(NVARCHAR,tax.nField1),'''') AS [L2818]
	    ,COALESCE(CONVERT(NVARCHAR,tax.nField2),'''') AS [L2819]
	    ,COALESCE(CONVERT(NVARCHAR,tax.nField3),'''') AS [L2820]
	    ,COALESCE(CONVERT(NVARCHAR,tax.nField4),'''') AS [L2821]
	    ,COALESCE(CONVERT(NVARCHAR,tax.tField1), '''') AS [L2822]
	    ,COALESCE(CONVERT(NVARCHAR,tax.tField2), '''') AS [L2823]
	    ,COALESCE(CONVERT(NVARCHAR,tax.tField3), '''') AS [L2824]
	    ,COALESCE(CONVERT(NVARCHAR,tax.tField4), '''') AS [L2825]
	    ,COALESCE(tax.cField1, '''') AS [L2826]
	    ,COALESCE(tax.cField2, '''') AS [L2827]
	    ,COALESCE(tax.cField3, '''') AS [L2828]
	    ,COALESCE(tax.cField4, '''') AS [L2829]
	    ,COALESCE(tax.cField5, '''') AS [L2830]
	    ,COALESCE(tax.cField6, '''') AS [L2831]
	    ,COALESCE(tax.cField7, '''') AS [L2832]
	    ,COALESCE(tax.cField8, '''') AS [L2833]
	    ,COALESCE(tax.cField9, '''') AS [L2834]
	    ,COALESCE(tax.cField10, '''') AS [L2835]
	    ,COALESCE(tax.mField1, '''') AS [L2836]
	    ,COALESCE(tax.cField21, '''') AS [L2837]
	    ,COALESCE(p.cPointDescription, '''') AS [test_desc]
	    ,COALESCE(p.cPointPassFailStatus, '''') AS [PointPassFail]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField010, pen.nField010FormatUID, pen.nField010UnitUID) AS [fixq]
	    ,'''' AS [fixq_p]
	    ,'''' AS [fixq_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField029, pen.nField029FormatUID, pen.nField029UnitUID) AS [varq]
	    ,'''' AS [varq_p]
	    ,'''' AS [varq_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nLowerLimit, pun.nLowerLimitFormatUID, pun.nLowerLimitUnitUID) AS [lower_limit]
	    ,'''' AS [lower_limit_p]
	    ,'''' AS [lower_limit_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUpperLimit, pun.nUpperLimitFormatUID, pun.nUpperLimitUnitUID) AS [upper_limit]
	    ,'''' AS [upper_limit_p]
	    ,'''' AS [upper_limit_u]
	    ,COALESCE(csr.cStatus, '''') AS [test_status]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID, pun.nUncertaintyExpandedUnitUID) AS [exp_uncert]
	    ,'''' AS [exp_uncert_p]
	    ,'''' AS [exp_uncert_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyStandard, pun.nUncertaintyStandardFormatUID, pun.nUncertaintyStandardUnitUID) AS [std_uncert]
	    ,'''' AS [std_uncert_p]
	    ,'''' AS [std_uncert_u]
	    ,[dbo].[udf_GET_FormattedValueEx](pun.nCoverageFactor, [dbo].[udf_GET_nFormatUID](1.11)) AS [cov_fac]
	    ,COALESCE(p.cCondition, '''') AS [condition]
	    ,COALESCE(p.cRemarks, '''') AS [remark]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](p.nCardinalPoint, p.nCardinalPointFormatUID, p.nCardinalPointUnitUID) AS [cpt]
	    ,'''' AS [cpt_p]
	    ,'''' AS [cpt_u]
	    ,COALESCE(CONVERT(NVARCHAR,p.lUUTIsFixed),'''') AS [fix_flag]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField015, pen.nField015FormatUID, pen.nField015UnitUID) AS [nominal]
	    ,'''' AS [nominal_p]
	    ,'''' AS [nominal_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nModifier1, pun.nModifier1FormatUID, pun.nModifier1UnitUID) AS [mod1]
	    ,'''' AS [mod1_p]
	    ,'''' AS [mod1_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](p.nReference, p.nReferenceFormatUID, p.nReferenceUnitUID) AS [sys_actual]
	    ,'''' AS [sys_actual_p]
	    ,'''' AS [sys_actual_u]
	    ,COALESCE(CONVERT(NVARCHAR,pel.lField001),'''') AS [corr_flag]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField027, pen.nField027FormatUID, pen.nField027UnitUID) AS [uut_ind]
	    ,'''' AS [uut_ind_p]
	    ,'''' AS [uut_ind_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField008, pen.nField008FormatUID, pen.nField008UnitUID) AS [expv]
	    ,'''' AS [expv_p]
	    ,'''' AS [expv_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](p.nUUT, p.nUUTFormatUID, p.nUUTUnitUID) AS [measurement]
	    ,'''' AS [measurement_p]
	    ,'''' AS [measurement_u]
	    ,COALESCE(CONVERT(NVARCHAR,pel.lField002),'''') AS [meas_flag]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField006, pen.nField006FormatUID, pen.nField006UnitUID) AS [dev]
	    ,'''' AS [dev_p]
	    ,'''' AS [dev_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](tol.nError, tol.nErrorFormatUID, tol.nErrorUnitUID) AS [error]
	    ,'''' AS [error_p]
	    ,'''' AS [error_u]
	    ,[dbo].[udf_GET_FormattedValueEx](tol.nReadingErrorPercent, NULL) AS [rel_err]
	    ,'''' AS [rel_err_p]
	    ,'''' AS [rel_err_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](p.nCorrection, p.nCorrectionFormatUID, p.nCorrectionUnitUID) AS [corr]
	    ,'''' AS [corr_p]
	    ,'''' AS [corr_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField004, pen.nField004FormatUID, pen.nField004UnitUID) AS [corr_unc]
	    ,'''' AS [corr_unc_p]
	    ,'''' AS [corr_unc_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](tol.nReferenceTolerance, tol.nReferenceToleranceFormatUID, tol.nReferenceToleranceUnitUID) AS [tol_ref]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID, tol.nToleranceNegativeUnitUID) AS [tol_neg]
	    ,'''' AS [tol_neg_p]
	    ,'''' AS [tol_neg_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID, tol.nTolerancePositiveUnitUID) AS [tol_pos]
	    ,'''' AS [tol_pos_p]
	    ,'''' AS [tol_pos_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](tol.nTolerance, tol.nToleranceFormatUID, tol.nToleranceUnitUID) AS [tol]
	    ,'''' AS [tol_p]
	    ,'''' AS [tol_u]
	    ,COALESCE(pes.cField011,'''') AS [tur]
	    ,[dbo].[udf_GET_FormattedValueEx](tol.nToleranceErrorPercent, NULL) AS [tol_err]
	    ,'''' AS [tol_err_p]
	    ,'''' AS [tol_err_u]
	    ,COALESCE(pun.cUncertaintyMethod,'''') AS [uncert_method]
	    ,COALESCE(CONVERT(NVARCHAR,stat.nNumberOfSamplesDiscarded),'''') AS [nthrow]
	    ,COALESCE(CONVERT(NVARCHAR,stat.nNumberOfSamplesUUT),'''') AS [num_meas]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](stat.nUUTStandardDeviation, stat.nUUTStandardDeviationFormatUID, stat.nUUTStandardDeviationUnitUID) AS [sdev]
	    ,'''' AS [sdev_p]
	    ,'''' AS [sdev_u]
	    ,COALESCE(CONVERT(NVARCHAR,stat.lNoisy),'''') AS [noisy_flag]
	    ,COALESCE(CONVERT(NVARCHAR,stat.lReliable),'''') AS [reliable_flag]
	    ,COALESCE(pun.cStudentsT,'''') AS [st_t]
	    ,COALESCE(CONVERT(NVARCHAR,pun.lStudentsT),'''') AS [st_t_flag]
	    ,COALESCE(CONVERT(NVARCHAR,pel.lField003),'''') AS [ws_flag]
	    ,COALESCE(CONVERT(NVARCHAR,pun.lDominant),'''') AS [dominant]
	    ,COALESCE(pun.cDegreesOfFreedom1,'''') AS [df1]
	    ,COALESCE(pun.cDegreesOfFreedom2,'''') AS [df2]
	    ,COALESCE(pun.cDegreesOfFreedom3,'''') AS [df3]
	    ,COALESCE(pun.cDegreesOfFreedom4,'''') AS [df4]
	    ,COALESCE(pun.cDegreesOfFreedom5,'''') AS [df5]
	    ,COALESCE(pun.cDegreesOfFreedom6,'''') AS [df6]
	    ,COALESCE(pun.cDegreesOfFreedom7,'''') AS [df7]
	    ,COALESCE(pun.cDegreesOfFreedom8,'''') AS [df8]
	    ,COALESCE(pun.cDegreesOfFreedom9,'''') AS [df9]
	    ,COALESCE(pun.cDegreesOfFreedom10,'''') AS [df10]
	    ,COALESCE(pes.cField001,'''') AS [deg_free]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter1, pun.nUncertaintyParameter1FormatUID, pun.nUncertaintyParameter1UnitUID) AS [u1]
	    ,'''' AS [u1_p]
	    ,'''' AS [u1_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter2, pun.nUncertaintyParameter2FormatUID, pun.nUncertaintyParameter2UnitUID) AS [u2]
	    ,'''' AS [u2_p]
	    ,'''' AS [u2_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter3, pun.nUncertaintyParameter3FormatUID, pun.nUncertaintyParameter3UnitUID) AS [u3]
	    ,'''' AS [u3_p]
	    ,'''' AS [u3_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter4, pun.nUncertaintyParameter4FormatUID, pun.nUncertaintyParameter4UnitUID) AS [u4]
	    ,'''' AS [u4_p]
	    ,'''' AS [u4_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter5, pun.nUncertaintyParameter5FormatUID, pun.nUncertaintyParameter5UnitUID) AS [u5]
	    ,'''' AS [u5_p]
	    ,'''' AS [u5_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter6, pun.nUncertaintyParameter6FormatUID, pun.nUncertaintyParameter6UnitUID) AS [u6]
	    ,'''' AS [u6_p]
	    ,'''' AS [u6_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter7, pun.nUncertaintyParameter7FormatUID, pun.nUncertaintyParameter7UnitUID) AS [u7]
	    ,'''' AS [u7_p]
	    ,'''' AS [u7_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter8, pun.nUncertaintyParameter8FormatUID, pun.nUncertaintyParameter8UnitUID) AS [u8]
	    ,'''' AS [u8_p]
	    ,'''' AS [u8_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter9, pun.nUncertaintyParameter9FormatUID, pun.nUncertaintyParameter9UnitUID) AS [u9]
	    ,'''' AS [u9_p]
	    ,'''' AS [u9_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyParameter10, pun.nUncertaintyParameter10FormatUID, pun.nUncertaintyParameter10UnitUID) AS [u10]
	    ,'''' AS [u10_p]
	    ,'''' AS [u10_u]
	    ,COALESCE(pun.cSensitivity1,'''') AS [c1]
	    ,COALESCE(pun.cSensitivity2,'''') AS [c2]
	    ,COALESCE(pun.cSensitivity3,'''') AS [c3]
	    ,COALESCE(pun.cSensitivity4,'''') AS [c4]
	    ,COALESCE(pun.cSensitivity5,'''') AS [c5]
	    ,COALESCE(pun.cSensitivity6,'''') AS [c6]
	    ,COALESCE(pun.cSensitivity7,'''') AS [c7]
	    ,COALESCE(pun.cSensitivity8,'''') AS [c8]
	    ,COALESCE(pun.cSensitivity9,'''') AS [c9]
	    ,COALESCE(pun.cSensitivity10,'''') AS [c10]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nS1, pun.nS1FormatUID, pun.nS1UnitUID) AS [s1]
	    ,'''' AS [s1_p]
	    ,'''' AS [s1_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nS2, pun.nS2FormatUID, pun.nS2UnitUID) AS [s2]
	    ,'''' AS [s2_p]
	    ,'''' AS [s2_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nUncertaintyDominant, pun.nUncertaintyDominantFormatUID, pun.nUncertaintyDominantUnitUID) AS [dom_uncert]
	    ,'''' AS [dom_uncert_p]
	    ,'''' AS [dom_uncert_u]
	    ,COALESCE(pes.cField009,'''') AS [test_step]
	    ,COALESCE(p.cFunctionSelectCode,'''') AS [fsc]
	    ,COALESCE(p.cPointLabel,'''') AS [result_type]
	    ,COALESCE(CONVERT(NVARCHAR,p.lAccredited),'''') AS [accred]
	    ,COALESCE(pun.cGuardBandMethod,'''') AS [guardband_meth]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID, pun.nGuardBandLowerUnitUID) AS [guardband_ll]
	    ,'''' AS [guardband_ll_p]
	    ,'''' AS [guardband_ll_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID, pun.nGuardBandUpperUnitUID) AS [guardband_ul]
	    ,'''' AS [guardband_ul_p]
	    ,'''' AS [guardband_ul_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](p.nSystemAccuracy, p.nSystemAccuracyFormatUID, p.nSystemAccuracyUnitUID) AS [sys_acc]
	    ,'''' AS [sys_acc_p]
	    ,'''' AS [sys_acc_u]
	    ,COALESCE(CONVERT(NVARCHAR,pun.nSystemCoverageFactor),'''') AS [sys_cov_fac]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](p.nUUTRange, p.nUUTRangeFormatUID, p.nUUTRangeUnitUID) AS [uut_range]
	    ,'''' AS [uut_range_p]
	    ,'''' AS [uut_range_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField028, pen.nField028FormatUID, pen.nField028UnitUID) AS [uut_res]
	    ,'''' AS [uut_res_p]
	    ,'''' AS [uut_res_u]
	    ,COALESCE(pes.cField007,'''') AS [sense]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField014, pen.nField014FormatUID, pen.nField014UnitUID) AS [i_imped]
	    ,'''' AS [i_imped_p]
	    ,'''' AS [i_imped_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField016, pen.nField016FormatUID, pen.nField016UnitUID) AS [o_imped1]
	    ,'''' AS [o_imped1_p]
	    ,'''' AS [o_imped1_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField017, pen.nField017FormatUID, pen.nField017UnitUID) AS [o_imped2]
	    ,'''' AS [o_imped2_p]
	    ,'''' AS [o_imped2_u]
	    ,COALESCE(pes.cField013,'''') AS [wave1]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField002, pen.nField002FormatUID, pen.nField002UnitUID) AS [ampl1]
	    ,'''' AS [ampl1_p]
	    ,'''' AS [ampl1_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField012, pen.nField012FormatUID, pen.nField012UnitUID) AS [freq1]
	    ,'''' AS [freq1_p]
	    ,'''' AS [freq1_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField018, pen.nField018FormatUID, pen.nField018UnitUID) AS [per1]
	    ,'''' AS [per1_p]
	    ,'''' AS [per1_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField023, pen.nField023FormatUID, pen.nField023UnitUID) AS [pulse_width]
	    ,'''' AS [pulse_width_p]
	    ,'''' AS [pulse_width_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField005, pen.nField005FormatUID, pen.nField005UnitUID) AS [dc_offset]
	    ,'''' AS [dc_offset_p]
	    ,'''' AS [dc_offset_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField007, pen.nField007FormatUID, pen.nField007UnitUID) AS [duty_cycle]
	    ,'''' AS [duty_cycle_p]
	    ,'''' AS [duty_cycle_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField024, pen.nField024FormatUID, pen.nField024UnitUID) AS [rise]
	    ,'''' AS [rise_p]
	    ,'''' AS [rise_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField009, pen.nField009FormatUID, pen.nField009UnitUID) AS [fall]
	    ,'''' AS [fall_p]
	    ,'''' AS [fall_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField026, pen.nField026FormatUID, pen.nField026UnitUID) AS [trigger_skew]
	    ,'''' AS [trigger_skew_p]
	    ,'''' AS [trigger_skew_u]
	    ,COALESCE(pes.cField012,'''') AS [video]
	    ,COALESCE(pes.cField005,'''') AS [polarity]
	    ,COALESCE(pes.cField006,'''') AS [rtd_type]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField025, pen.nField025FormatUID, pen.nField025UnitUID) AS [rtd_nom_res]
	    ,'''' AS [rtd_nom_res_p]
	    ,'''' AS [rtd_nom_res_u]
	    ,COALESCE(pes.cField008,'''') AS [tc_type]
	    ,COALESCE(pes.cField004,'''') AS [mod_source]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField001, pen.nField001FormatUID, pen.nField001UnitUID) AS [am_depth]
	    ,'''' AS [am_depth_p]
	    ,'''' AS [am_depth_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField011, pen.nField011FormatUID, pen.nField011UnitUID) AS [fm_dev]
	    ,'''' AS [fm_dev_p]
	    ,'''' AS [fm_dev_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField021, pen.nField021FormatUID, pen.nField021UnitUID) AS [phase_dev]
	    ,'''' AS [phase_dev_p]
	    ,'''' AS [phase_dev_u]
	    ,COALESCE(pes.cField014,'''') AS [wave2]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField003, pen.nField003FormatUID, pen.nField003UnitUID) AS [ampl2]
	    ,'''' AS [ampl2_p]
	    ,'''' AS [ampl2_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField013, pen.nField013FormatUID, pen.nField013UnitUID) AS [freq2]
	    ,'''' AS [freq2_p]
	    ,'''' AS [freq2_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField019, pen.nField019FormatUID, pen.nField019UnitUID) AS [per2]
	    ,'''' AS [per2_p]
	    ,'''' AS [per2_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField022, pen.nField022FormatUID, pen.nField022UnitUID) AS [power]
	    ,'''' AS [power_p]
	    ,'''' AS [power_u]
	    ,[dbo].[udf_GET_FormattedValueExWithUnit](pen.nField020, pen.nField020FormatUID, pen.nField020UnitUID) AS [phase]
	    ,'''' AS [phase_p]
	    ,'''' AS [phase_u]
	    ,COALESCE(pes.cField002,'''') AS [dpf]
	    ,COALESCE(pes.cField003,'''') AS [dpf_polarity]
	    ,COALESCE(CONVERT(NVARCHAR(36),cs.nAssetUID),'''') AS [Results_mtag]
	    ,p.tAddTime AS [created]
	    ,[dbo].[udf_GET_User](p.nAddUserUID) AS [createdby]
	    ,p.tUpdateTime AS [editlogtime]
	    ,[dbo].[udf_GET_User](p.nUpdateUserUID) AS [modifiedby]
	    ,COALESCE(pes.cField010,'''') AS [test_step2]
	    ,[dbo].[udf_GET_User](cs.nTechnicianUID) AS [Logon_User]
	    ,'''' AS [User_level]
	    ,[dbo].[udf_GET_UserFull](cs.nTechnicianUID) AS [User_Full_Name]
	    ,'''' AS [User_Segregate]
	    ,COALESCE(u.cPayGrade,'''') AS [User_Rate]
	    ,COALESCE(csr.cWorkstationName,'''') AS [WorkStation]
	    ,COALESCE(csr.cDescription,'''') AS [CSR]
	    ,COALESCE(prcsr.cProcedureName,''No Procedure'') AS [Procedure]
	    ,COALESCE(CONVERT(NVARCHAR(36), csr.nCallSheetResultUID), '''') AS [ResultUID]
	    ,ISNULL(pr.cRevision, '''') AS [cRevision]
	    ,ISNULL(pr.cVersion, '''') AS [cVersion]
	    ,CONVERT(NVARCHAR(36), csr.nTechnicianUID) AS [nTechnicianUID]
	    ,CONVERT(NVARCHAR(36), csr.nRunAtFacilityUID) AS [nRunAtFacilityUID]
	    ,csr.nCallSheetResultOrdinal
	    ,ISNULL(csr.cDataOrigin,'''') AS [cDataOrigin]
	    ,ISNULL(csr.cCallSheetResultType,'''') AS [cCallSheetResultType]
	    ,csr.tStartTime
	    ,csr.tEndTime
	    ,p.nPointUID
    FROM
    [dbo].[CallSheets] cs
        LEFT JOIN [dbo].[CallSheetEx] csx ON csx.nCallSheetUID = cs.nCallSheetUID
        LEFT JOIN [dbo].[users] u ON u.nUserUID = cs.nTechnicianUID
        LEFT JOIN [dbo].[CallSheetResults] csr ON csr.nCallSheetUID = cs.nCallSheetUID AND csr.lDeleted = 0 AND csr.lActive <> 0
        LEFT JOIN [dbo].[Points] p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
        LEFT JOIN [dbo].[facilities] wf ON wf.nFacilityUID = cs.nWorkingFacilityUID
        LEFT JOIN [dbo].[procedures] pr ON pr.nProcedureUID = cs.nProcedureUID
        LEFT JOIN [dbo].[procedures] prcsr ON prcsr.nProcedureUID = csr.nProcedureUID
        LEFT JOIN [dbo].[jobnumbers] jn ON jn.nJobNumberUID = cs.nJobNumberUID
        LEFT JOIN [dbo].[assets] ass ON ass.nAssetUID = cs.nAssetUID
        LEFT JOIN [dbo].[facilities] cust ON COALESCE(cust.lCustomer, 0) = -1 AND cust.nFacilityUID = ass.nFacilityUID
        LEFT JOIN [dbo].[facilityex] custEx ON custEx.nFacilityUID = cust.nFacilityUID
        LEFT JOIN [dbo].[addresses] da ON da.cType = ''Default'' AND da.nFacilityUID = cust.nFacilityUID AND da.lDeleted = 0 AND da.lActive <> 0
        LEFT JOIN [dbo].[AssetEx] assx ON assx.nAssetUID = ass.nAssetUID
        LEFT JOIN [dbo].[facilities] assg ON assg.nFacilityUID = ass.nManufacturerUID
        LEFT JOIN [dbo].[facilities] dept ON dept.nFacilityUID = ass.nDepartmentUID
        LEFT JOIN [dbo].[facilities] lab ON lab.nFacilityUID = ass.nFacilityUID
        LEFT JOIN [dbo].[toolassignments] ta ON ta.lActive <> 0 AND ta.lDeleted = 0 AND ta.tReturnDate IS NULL AND ta.nAssetUID = ass.nAssetUID
        LEFT JOIN [dbo].[toolassignmentex] tax ON tax.nToolAssignmentUID = ta.nToolAssignmentUID
        LEFT JOIN [dbo].[contacts] tac ON tac.nContactUID = ta.nContactUID
        LEFT JOIN [dbo].[PointExNumerics] pen ON pen.nPointUID = p.nPointUID
        LEFT JOIN [dbo].[PointUncertainties] pun ON pun.nPointUID = p.nPointUID
        LEFT JOIN [dbo].[PointExLogicals] pel ON pel.nPointUID = p.nPointUID
        LEFT JOIN [dbo].[PointTolerances] tol ON tol.nPointUID = p.nPointUID
        LEFT JOIN [dbo].[PointExStrings] pes ON pes.nPointUID = p.nPointUID
        LEFT JOIN [dbo].[PointStatistics] stat ON stat.nPointUID = p.nPointUID
    WHERE
        cs.nCallSheetUID = @nCallSheetUID
    AND
        COALESCE(p.lDeleted, 0) = 0
    AND
        COALESCE(p.lActive, -1) <> 0
    ORDER BY
        COALESCE(csr.nCallSheetResultOrdinal, 0), COALESCE(p.nPointOrdinal, 0)
    END'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	

	IF EXISTS( SELECT * FROM sysobjects WHERE type='V' AND name='vw_METCONNECT_RESULTS' )
	BEGIN
		PRINT N'Dropping [dbo].[vw_METCONNECT_RESULTS]'

		DROP VIEW [dbo].vw_METCONNECT_RESULTS

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
		
	IF OBJECT_ID(N'[dbo].[vw_METCONNECT_RESULTS]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_METCONNECT_RESULTS]'

		EXEC sp_executesql N'
	/****************************************************************
		vw_METCONNECT_RESULTS
		(C) 2019-22 Fluke Calibration
	-----------------------------------------------------------------
		CHANGE HISTORY
		11/06/2019  MM      Initial development
		11/25/2019  MM      Add cFunctionSelectCode
		11/23/2020  MM      Add Test Step
		02/23/2021  MM      Add Upper and Lower Limit
		03/05/2021  AC      Add FixedQuantity and VariableQuantity
		04/20/2021  MM      Add DUT Resolution
		04/22/2021  MM      Add Group Run Id and Tag Ordinal
		05/02/2022  AC      Add TUR
		08/22/2022  KW      Add Points cCondition
		09/29/2022  MM      Remove Status field (duplicate)
	*****************************************************************/
	CREATE VIEW [dbo].[vw_METCONNECT_RESULTS]
	AS
		SELECT
			csr.nCallSheetResultUID AS [ResultKey],
			p.nPointUID AS [PointKey],
			p.nPointOrdinal AS [Ordinal],
			p.cPointDescription AS [Description],
			p.cFunctionSelectCode AS [FSC],
			p.cRemarks AS [Remarks],
			ISNULL([dbo].[udf_get_formattedValue](p.nCardinalPoint, p.nCardinalPointFormatUID),'''') AS [CardinalPoint],
			up3.cUnitSymbol AS [CardinalPointUnit],
			ISNULL([dbo].[udf_get_formattedValue](p.nReference, p.nReferenceFormatUID),'''') AS [Reference],
			up2.cUnitSymbol AS [ReferenceUnit],
			ISNULL([dbo].[udf_get_formattedValue](p.nUUT, p.nUUTFormatUID),'''') AS [Dut],
			up1.cUnitSymbol AS [DutUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nError, tol.nErrorFormatUID),'''') AS [Error],
			utol1.cUnitSymbol AS [ErrorUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nToleranceNegative, tol.nToleranceNegativeFormatUID),'''') AS [ToleranceNegative],
			utol5.cUnitSymbol AS [ToleranceNegativeUnit],
			ISNULL([dbo].[udf_get_formattedValue](tol.nTolerancePositive, tol.nTolerancePositiveFormatUID),'''') AS [TolerancePositive],
			utol6.cUnitSymbol AS [TolerancePositiveUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandLower, pun.nGuardBandLowerFormatUID),'''') AS [GuardbandLowerLimit],
			upun18.cUnitSymbol AS [GuardbandLowerLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nGuardBandUpper, pun.nGuardBandUpperFormatUID),'''') AS [GuardbandUpperLimit],
			upun19.cUnitSymbol AS [GuardbandUpperLimitUnit],
			ISNULL(p.cPointPassFailStatus, '''') AS [PointPassFail],
			ISNULL(p.cCondition, '''') AS [Condition],
			ISNULL([dbo].[udf_get_formattedValue](pun.nUncertaintyExpanded, pun.nUncertaintyExpandedFormatUID),'''') AS [ExpandedUncertainty],
			upun3.cUnitSymbol AS [ExpandedUncertaintyUnit],
			ISNULL(pes.cField009,'''') AS [TestStep],
			ISNULL([dbo].[udf_get_formattedValue](pun.nLowerLimit, pun.nLowerLimitFormatUID),'''') AS [LowerLimit],
			upun1.cUnitSymbol AS [LowerLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pun.nUpperLimit, pun.nUpperLimitFormatUID),'''') AS [UpperLimit],
			upun2.cUnitSymbol AS [UpperLimitUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField010, pen.nField010FormatUID),'''') AS [FixedQuantity],
			upen1.cUnitSymbol AS [FixedQuantityUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField029, pen.nField029FormatUID),'''') AS [VariableQuantity],
			upen2.cUnitSymbol AS [VariableQuantityUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField028, pen.nField028FormatUID),'''') AS [DutResolution],
			upen3.cUnitSymbol AS [DutResolutionUnit],
			ISNULL([dbo].[udf_get_formattedValue](pen.nField030, pen.nField030FormatUID),'''') AS [TUR],
			ISNULL(csrx.cField049,'''') AS [ProcedureTagOrdinal],
			ISNULL(csrx.cField050,'''') AS [ProcedureRunId]
		FROM
			[dbo].[CallSheetResults] csr
			INNER JOIN [dbo].[Points] p ON p.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN [dbo].[CallSheetResultEx] csrx ON csrx.nCallSheetResultUID = csr.nCallSheetResultUID
			LEFT JOIN [dbo].[Units] up1 ON up1.nUnitUID = p.nUUTUnitUID
			LEFT JOIN [dbo].[Units] up2 ON up2.nUnitUID = p.nReferenceUnitUID
			LEFT JOIN [dbo].[Units] up3 ON up3.nUnitUID = p.nCardinalPointUnitUID
			LEFT JOIN [dbo].[PointExNumerics] pen ON pen.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] upen1 ON upen1.nUnitUID = pen.nField010UnitUID
			LEFT JOIN [dbo].[Units] upen2 ON upen2.nUnitUID = pen.nField029UnitUID
			LEFT JOIN [dbo].[Units] upen3 ON upen3.nUnitUID = pen.nField028UnitUID
			LEFT JOIN [dbo].[PointUncertainties] pun ON pun.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] upun1 ON upun1.nUnitUID = pun.nLowerLimitUnitUID
			LEFT JOIN [dbo].[Units] upun2 ON upun2.nUnitUID = pun.nUpperLimitUnitUID
			LEFT JOIN [dbo].[Units] upun3 ON upun3.nUnitUID = pun.nUncertaintyExpandedUnitUID
			LEFT JOIN [dbo].[Units] upun4 ON upun4.nUnitUID = pun.nUncertaintyStandardUnitUID
			LEFT JOIN [dbo].[Units] upun18 ON upun18.nUnitUID = pun.nGuardBandLowerUnitUID
			LEFT JOIN [dbo].[Units] upun19 ON upun19.nUnitUID = pun.nGuardBandUpperUnitUID
			LEFT JOIN [dbo].[PointTolerances] tol ON tol.nPointUID = p.nPointUID
			LEFT JOIN [dbo].[Units] utol1 ON utol1.nUnitUID = tol.nErrorUnitUID
			LEFT JOIN [dbo].[Units] utol5 ON utol5.nUnitUID = tol.nToleranceNegativeUnitUID
			LEFT JOIN [dbo].[Units] utol6 ON utol6.nUnitUID = tol.nTolerancePositiveUnitUID
			LEFT JOIN [dbo].[PointExStrings] pes ON pes.nPointUID = p.nPointUID
			WHERE
				p.lDeleted = 0
			AND
				p.lActive <> 0
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-9052<<--	
	UPDATE
		[dbo].[UCIData]
	SET
		[lDeleted] = -1
	WHERE
		[cModel] = N'MainMenu'
	AND	
		[cField] = N'mnuSystemMetCalPromptsMenu'
	AND
		[cProperty] = N'Label'
	AND
		[nUCIDataUID] <> 'DAB314D7-F39D-4082-BA79-445B40FCBAB9'
		
	
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'DAB314D7-F39D-4082-BA79-445B40FCBAB9')
	BEGIN

		INSERT INTO [dbo].[UCIData] ([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) 
		VALUES ('DAB314D7-F39D-4082-BA79-445B40FCBAB9', N'MainMenu', N'mnuSystemMetCalPromptsMenu', N'Label', N'MET_CAL_Prompts', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20221028 23:01:08', 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20221028 23:01:08', '20221028 23:01:08', NULL, NULL)


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		
	END
	
	
	-->>MTM-8974<<--	
	IF OBJECT_ID(N'[dbo].[AlertEngineConfig]', 'U') IS NULL
	BEGIN
		CREATE TABLE [dbo].[AlertEngineConfig]
		(
			[nAlertEngineConfigUID] [uniqueidentifier] NOT NULL ROWGUIDCOL,
			[cEmailUserName] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
			[cEmailPassword] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
			[cEmailAddress] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
			[cSmtpHostName] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
			[cFromName] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
			[cGlobalCC] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cGlobalBCC] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
			[cLanguage] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL CONSTRAINT [DF_AlertEngineConfig_cLanguage] DEFAULT ('EN'),
			[nPort] [int] NOT NULL CONSTRAINT [DF_AlertEngineConfig_nPort] DEFAULT (25),
			[lUseSSL] [int] NOT NULL CONSTRAINT [DF_AlertEngineConfig_lUseSSL] DEFAULT (0),
			[lActive] [int] NOT NULL CONSTRAINT [DF_AlertEngineConfig_lActive] DEFAULT (-1),
			[lDeleted] [int] NOT NULL CONSTRAINT [DF_AlertEngineConfig_lDeleted] DEFAULT (0),
			[lApproved] [int] NOT NULL CONSTRAINT [DF_AlertEngineConfig_lApproved] DEFAULT (0),
			[lAdded] [int] NOT NULL CONSTRAINT [DF_AlertEngineConfig_lAdded] DEFAULT (0),
			[nAddFacilityUID] [uniqueidentifier] NOT NULL,
			[nAddUserUID] [uniqueidentifier] NOT NULL,
			[tAddTime] [datetime] NOT NULL,
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL,
			[nUpdateUserUID] [uniqueidentifier] NOT NULL,
			[tUpdateTime] [datetime] NOT NULL,
			[tMobileTime] [datetime] NOT NULL,
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL
		)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END		
	END

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[pk_AlertEngineConfig_nAlertEngineConfigUID]', 'PK') AND parent_object_id = OBJECT_ID(N'[dbo].[AlertEngineConfig]', 'U'))
	ALTER TABLE [dbo].[AlertEngineConfig] ADD CONSTRAINT [pk_AlertEngineConfig_nAlertEngineConfigUID] PRIMARY KEY NONCLUSTERED ([nAlertEngineConfigUID])
	
	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END	

	
	IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[DF_AlertEngineConfig_cEmailPassword]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[AlertEngineConfig] ADD CONSTRAINT [DF_AlertEngineConfig_cEmailPassword] DEFAULT '' FOR [cEmailPassword]
	END
	
	
	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'CCE5B814-F217-4B9D-B8A6-D160F4086D3B')
	BEGIN

		INSERT INTO [dbo].[UCIData] ([nUCIDataUID], [cModel], [cField], [cProperty], [cValue], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) 
		VALUES ('CCE5B814-F217-4B9D-B8A6-D160F4086D3B', N'MainMenu', N'mnuAlertingEngine', N'Label', N'ALERT_ENGINE_CONFIG', -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20221031 23:40:18.393', 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20221031 23:40:18.393', '20221031 23:40:18.393', NULL, NULL)


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
		
	END		

	IF OBJECT_ID(N'[dbo].[udf_GET_SystemDefault]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_SystemDefault]'
		DROP FUNCTION [dbo].[udf_GET_SystemDefault]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF OBJECT_ID(N'[dbo].[udf_GET_SystemDefault]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_SystemDefault]'

		EXEC sp_executesql N'/********************************************************************************
udf_GET_SystemDefault
Gets cValue from a system default, regardless of active or deleted status

Parameters:
SystemDefaults.cProperty

(C) 2022 Fluke Calibration
-----------------------------------------------------------------
CHANGE HISTORY
11/01/2022  MM      Initially created
*********************************************************************************/

CREATE FUNCTION [dbo].[udf_GET_SystemDefault] 
( 
	@cProperty [nvarchar](50)
)				
RETURNS NVARCHAR(150)

AS
BEGIN
	DECLARE @result NVARCHAR(150);	
	SELECT @result = [cValue] FROM [dbo].[SystemDefaults] WHERE [cProperty] = @cProperty;
	RETURN @result;
END'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END



	IF OBJECT_ID(N'[dbo].[vw_SmtpSettings]', 'V') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[vw_SmtpSettings]'
		
		DROP VIEW [dbo].[vw_SmtpSettings]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
	
	IF OBJECT_ID(N'[dbo].[vw_SmtpSettings]', 'V') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[vw_SmtpSettings]'

		EXEC sp_executesql N'/****************************************************************
	vw_SmtpSettings	
	Gets the SMTP settings for Alering

	(C) 2022 Fluke Calibration
-----------------------------------------------------------------
	CHANGE HISTORY
	11/01/2022  MM      Initially created
*****************************************************************/
CREATE VIEW [dbo].[vw_SmtpSettings]
AS
SELECT
	[dbo].[udf_GET_SystemDefault](''Alerts.Smtp.Host'') AS [Host],
	CONVERT(int, [dbo].[udf_GET_SystemDefault](''Alerts.Smtp.Port'')) AS [Port],
	[dbo].[udf_GET_SystemDefault](''Alerts.Smtp.User'') AS [User],
	[dbo].[udf_GET_SystemDefault](''Alerts.Smtp.Password'') AS [Password],
	IIF(LOWER([dbo].[udf_GET_SystemDefault](''Alerts.Smtp.UseSSL'')) = ''false'', 0, -1) AS [Ssl], 
	[dbo].[udf_GET_SystemDefault](''Alerts.Language'') AS [Language],
	[dbo].[udf_GET_SystemDefault](''Alerts.Email.FromAddress'') AS [FromAddress],
	[dbo].[udf_GET_SystemDefault](''Alerts.Email.FromName'') AS [FromName],
	[dbo].[udf_GET_SystemDefault](''Alerts.GlobalBCC'') AS [GlobalBCC],
	[dbo].[udf_GET_SystemDefault](''Alerts.GlobalCC'') AS [GlobalCC]	
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END	

	If((SELECT COUNT(*) FROM [dbo].[AlertEngineConfig]) = 0)
	BEGIN
		INSERT INTO [dbo].[AlertEngineConfig]
		SELECT 
			'DA0927BA-5CC0-4BDA-9121-4B3B3E1CCFD1',
			[User],
			[Password],
			[FromAddress],
			[Host],
			[FromName],
		    [GlobalBCC],
		    [GlobalCC],
		    [Language],
		    [Port],    
		    [Ssl],
		    -1, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20221103 00:03:59.783', 'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172', '20221103 00:03:59.783', '20221103 00:03:59.783', NULL, NULL
		FROM
			[dbo].[vw_SmtpSettings]
	
	
		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END	
		
	IF OBJECT_ID(N'[dbo].[spl_AlertEngineConfig_RETRIEVE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_AlertEngineConfig_RETRIEVE]'
		DROP PROCEDURE [dbo].[spl_AlertEngineConfig_RETRIEVE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_AlertEngineConfig_RETRIEVE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_AlertEngineConfig_RETRIEVE]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_AlertEngineConfig_RETRIEVE
	Retrieves a single record by ID from the AlertEngineConfig table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 11/3/2022 (R)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_AlertEngineConfig_RETRIEVE]
	
@nAlertEngineConfigUID uniqueidentifier


AS
BEGIN

	SELECT
[nAlertEngineConfigUID]
		,[cEmailUserName]
		,[cEmailPassword]
		,[cEmailAddress]
		,[cSmtpHostName]
		,[cFromName]
		,[cGlobalCC]
		,[cGlobalBCC]
		,[cLanguage]
		,[nPort]
		,[lUseSSL]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[AlertEngineConfig]
	WHERE
[nAlertEngineConfigUID] = @nAlertEngineConfigUID

	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF OBJECT_ID(N'[dbo].[spl_AlertEngineConfig_LIST]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_AlertEngineConfig_LIST]'
		DROP PROCEDURE [dbo].[spl_AlertEngineConfig_LIST]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_AlertEngineConfig_LIST]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_AlertEngineConfig_LIST]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_AlertEngineConfig_LIST
	Retrieves all records from the AlertEngineConfig table
	Optionally includes inactive records
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 11/3/2022 (L)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_AlertEngineConfig_LIST]
	
@includeInactive	INT	= 0

AS
BEGIN

	SELECT
[nAlertEngineConfigUID]
		,[cEmailUserName]
		,[cEmailPassword]
		,[cEmailAddress]
		,[cSmtpHostName]
		,[cFromName]
		,[cGlobalCC]
		,[cGlobalBCC]
		,[cLanguage]
		,[nPort]
		,[lUseSSL]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[tAddTime]
		,[nUpdateFacilityUID]
		,[nUpdateUserUID]
		,[tUpdateTime]
		,[tMobileTime]
		,[tSystemUpdateTime]
		,[nImportUID]

	FROM
		[dbo].[AlertEngineConfig]
	WHERE
		ABS(lActive) + @includeInactive > 0
		AND
		lDeleted = 0
	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_AlertEngineConfig_INSERT]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_AlertEngineConfig_INSERT]'
		DROP PROCEDURE [dbo].[spl_AlertEngineConfig_INSERT]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_AlertEngineConfig_INSERT]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_AlertEngineConfig_INSERT]'
		
		EXEC sp_executesql N'	
/****************************************************************
	spl_AlertEngineConfig_INSERT
	Inserts a new record into the AlertEngineConfig table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 11/3/2022 (I)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_AlertEngineConfig_INSERT]
	
@cEmailUserName nvarchar(150) 
	,@cEmailPassword nvarchar(150) 
	,@cEmailAddress nvarchar(150) 
	,@cSmtpHostName nvarchar(150) 
	,@cFromName nvarchar(150) 
	,@cGlobalCC nvarchar(150)  = NULL 
	,@cGlobalBCC nvarchar(150)  = NULL 
	,@cLanguage nvarchar(150)  = ''EN'' 
	,@nPort int  = 25 
	,@lUseSSL int  = 0 
	,@lActive int  = -1 
	,@lDeleted int  = 0 
	,@lApproved int  = 0 
	,@lAdded int  = 0 
	,@nAddFacilityUID uniqueidentifier 
	,@nAddUserUID uniqueidentifier 
	,@nImportUID uniqueidentifier  = NULL 

	,@nAlertEngineConfigUID [uniqueidentifier] = NULL OUTPUT

AS
BEGIN

	DECLARE @ID [uniqueidentifier] = NEWID()

	INSERT INTO [dbo].[AlertEngineConfig] (
		[nAlertEngineConfigUID]
,[cEmailUserName]
		,[cEmailPassword]
		,[cEmailAddress]
		,[cSmtpHostName]
		,[cFromName]
		,[cGlobalCC]
		,[cGlobalBCC]
		,[cLanguage]
		,[nPort]
		,[lUseSSL]
		,[lActive]
		,[lDeleted]
		,[lApproved]
		,[lAdded]
		,[nAddFacilityUID]
		,[nAddUserUID]
		,[nImportUID]

		,[tAddTime]
		,[nUpdateUserUID]
		,[nUpdateFacilityUID]
		,[tUpdateTime]
		,[tMobileTime]
	)
	VALUES (
		@ID
,@cEmailUserName
		,@cEmailPassword
		,@cEmailAddress
		,@cSmtpHostName
		,@cFromName
		,@cGlobalCC
		,@cGlobalBCC
		,@cLanguage
		,@nPort
		,@lUseSSL
		,@lActive
		,@lDeleted
		,@lApproved
		,@lAdded
		,@nAddFacilityUID
		,@nAddUserUID
		,@nImportUID

		,GetUTCDate()
		,@nAddUserUID
		,@nAddFacilityUID
		,GetUTCDate()
		,GetUTCDate()
	)

	-- Return the new GUID for the UID of this record to the caller
	SET @nAlertEngineConfigUID = @ID

	-- Avoids warning in VS2010
	RETURN 1
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
	IF OBJECT_ID(N'[dbo].[spl_AlertEngineConfig_DELETE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_AlertEngineConfig_DELETE]'
		DROP PROCEDURE [dbo].[spl_AlertEngineConfig_DELETE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_AlertEngineConfig_DELETE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_AlertEngineConfig_DELETE]'

		EXEC sp_executesql N'	
/****************************************************************
	spl_AlertEngineConfig_DELETE
	Deletes a single record by ID from the AlertEngineConfig table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 11/3/2022 (D)
*****************************************************************/

CREATE PROCEDURE [dbo].[spl_AlertEngineConfig_DELETE]

	@nAlertEngineConfigUID uniqueidentifier,
	@nUpdateUserUID 		[uniqueidentifier],
	@nUpdateFacilityUID		[uniqueidentifier],
	@retMsg					tinyint OUTPUT
	
AS
BEGIN

	DECLARE @recordID nvarchar(50)
	DECLARE @userID nvarchar(50)
	DECLARE @facilityUID nvarchar(50)
	DECLARE @now nvarchar(50)

	SELECT
		@recordID = CONVERT( nvarchar(50), @nAlertEngineConfigUID ),
		@now = CONVERT( nvarchar(50), GetUTCDate() ),
		@userID = CONVERT( nvarchar(50), @nUpdateUserUID ),
		@facilityUID = CONVERT( nvarchar(50), @nUpdateFacilityUID ) 

	EXEC sp_CheckAndDelete
		1,							-- MarkDeleted
		''AlertEngineConfig'',		-- TableName
		@recordID,					-- PrimaryKeyValue
		1,							-- IsPrimaryKeyString
		'''',	-- TableExceptions
		1,							-- ExceptDeletions
		@facilityUID,				-- FacilityUID
		@userID,					-- UpdateUserUID
		@now,						-- UpdateTime
		@retMsg OUTPUT
	
	RETURN @retMsg
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_AlertEngineConfig_UPDATE]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_AlertEngineConfig_UPDATE]'
		DROP PROCEDURE [dbo].[spl_AlertEngineConfig_UPDATE]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF OBJECT_ID(N'[dbo].[spl_AlertEngineConfig_UPDATE]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_AlertEngineConfig_UPDATE]'

		EXEC sp_executesql N'		
/****************************************************************
	spl_AlertEngineConfig_UPDATE
	Updates a single record by ID in the AlertEngineConfig table
	(c) 2011-2022 Fluke Calibration
-----------------------------------------------------------------
	Automatically generated on 11/3/2022 (U)
*****************************************************************/
	
CREATE PROCEDURE [dbo].[spl_AlertEngineConfig_UPDATE]
	
@nAlertEngineConfigUID uniqueidentifier
	,@cEmailUserName nvarchar(150)
	,@cEmailPassword nvarchar(150)
	,@cEmailAddress nvarchar(150)
	,@cSmtpHostName nvarchar(150)
	,@cFromName nvarchar(150)
	,@cGlobalCC nvarchar(150)
	,@cGlobalBCC nvarchar(150)
	,@cLanguage nvarchar(150)
	,@nPort int
	,@lUseSSL int
	,@lActive int
	,@lDeleted int
	,@lApproved int
	,@lAdded int
	,@nUpdateFacilityUID uniqueidentifier
	,@nUpdateUserUID uniqueidentifier
	,@nImportUID uniqueidentifier


AS
BEGIN
	DECLARE @DateNow datetime = GetUTCDate();

	UPDATE [dbo].[AlertEngineConfig]
	SET
[cEmailUserName] = @cEmailUserName
		,[cEmailPassword] = @cEmailPassword
		,[cEmailAddress] = @cEmailAddress
		,[cSmtpHostName] = @cSmtpHostName
		,[cFromName] = @cFromName
		,[cGlobalCC] = @cGlobalCC
		,[cGlobalBCC] = @cGlobalBCC
		,[cLanguage] = @cLanguage
		,[nPort] = @nPort
		,[lUseSSL] = @lUseSSL
		,[lActive] = @lActive
		,[lDeleted] = @lDeleted
		,[lApproved] = @lApproved
		,[lAdded] = @lAdded
		,[nUpdateFacilityUID] = @nUpdateFacilityUID
		,[nUpdateUserUID] = @nUpdateUserUID
		,[nImportUID] = @nImportUID

		,[tUpdateTime] = @DateNow
		,[tMobileTime] = @DateNow
	WHERE
[nAlertEngineConfigUID] = @nAlertEngineConfigUID

	
	RETURN
		
END
'
	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	
    IF NOT EXISTS(SELECT * FROM [dbo].[AuditTables] WHERE [TableID] = 89)
    BEGIN
        PRINT 'Adding table [AlertEngineConfig] to [AuditTables]'

        SET IDENTITY_INSERT [dbo].[AuditTables] ON
        INSERT INTO [dbo].[AuditTables] ([TableID], [Owner], [TableName], [AuditTable], [AuditInserts], [AuditUpdates], [AuditDeletes], [AuditDeletesAll], [UniqueKeyType], [UserColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) 
        VALUES (89, N'dbo', N'AlertEngineConfig', 1, 1, 1, 0, 1, 'P', N' ', -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditTables] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'c129f1d9-d75d-4137-9792-0c361b7916de')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[nAlertEngineConfigUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('c129f1d9-d75d-4137-9792-0c361b7916de', 89, 3134, N'nAlertEngineConfigUID', 1, 0, 0, 1, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'ba07fd4b-1cc2-41d4-9a58-259bd6992516')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[cEmailUserName] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('ba07fd4b-1cc2-41d4-9a58-259bd6992516', 89, 3135, N'cEmailUserName', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'd036e81e-cc8e-425f-a384-23218a68198d')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[cEmailPassword] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('d036e81e-cc8e-425f-a384-23218a68198d', 89, 3136, N'cEmailPassword', 0, 0, 0, 0, 0, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '03be9069-13b7-439d-af13-7d53eca913e7')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[cEmailAddress] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('03be9069-13b7-439d-af13-7d53eca913e7', 89, 3137, N'cEmailAddress', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '126d0adf-a983-448d-b0bd-4e597d7e5d00')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[cSmtpHostName] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('126d0adf-a983-448d-b0bd-4e597d7e5d00', 89, 3138, N'cSmtpHostName', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'cc923be7-300d-4a69-8b6d-98af1220736d')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[cFromName] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('cc923be7-300d-4a69-8b6d-98af1220736d', 89, 3139, N'cFromName', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '5bffac53-9b11-416d-819b-933d3afbefe4')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[cGlobalCC] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('5bffac53-9b11-416d-819b-933d3afbefe4', 89, 3140, N'cGlobalCC', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '738e1f9b-6fe1-4b5d-89ac-8835e96a248f')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[cGlobalBCC] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('738e1f9b-6fe1-4b5d-89ac-8835e96a248f', 89, 3141, N'cGlobalBCC', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'eca7c5a7-909e-47ce-b923-6b6f08f04806')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[cLanguage] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('eca7c5a7-909e-47ce-b923-6b6f08f04806', 89, 3142, N'cLanguage', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '7e391bcb-98a2-4bdf-9d62-c31c69508121')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[nPort] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('7e391bcb-98a2-4bdf-9d62-c31c69508121', 89, 3143, N'nPort', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '3ef87849-5e89-4f1d-970b-b67171f0d730')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[lUseSSL] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('3ef87849-5e89-4f1d-970b-b67171f0d730', 89, 3144, N'lUseSSL', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'c4f0348f-f1f2-46ff-ab26-2668ba1b2a55')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[lActive] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('c4f0348f-f1f2-46ff-ab26-2668ba1b2a55', 89, 3145, N'lActive', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'af660282-5d83-42af-a110-95504f27da4b')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[lDeleted] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('af660282-5d83-42af-a110-95504f27da4b', 89, 3146, N'lDeleted', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'd1498156-0615-47db-aa0d-030e51bae066')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[lApproved] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('d1498156-0615-47db-aa0d-030e51bae066', 89, 3147, N'lApproved', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '50645af7-56bc-4e6d-9db5-fc3fcd04a5e0')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[lAdded] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('50645af7-56bc-4e6d-9db5-fc3fcd04a5e0', 89, 3148, N'lAdded', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '8e913a2e-8303-4c2e-bfe8-3ecc3af60605')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[nAddFacilityUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('8e913a2e-8303-4c2e-bfe8-3ecc3af60605', 89, 3149, N'nAddFacilityUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'f61d7f3e-37ad-4e43-b552-961d1d4b2405')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[nAddUserUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('f61d7f3e-37ad-4e43-b552-961d1d4b2405', 89, 3150, N'nAddUserUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '3dc03d05-eeb1-4d20-a787-0b3e893dfd78')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[tAddTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('3dc03d05-eeb1-4d20-a787-0b3e893dfd78', 89, 3151, N'tAddTime', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '5057df55-69b7-4cf7-aa0b-4ec06ae35430')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[nUpdateFacilityUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('5057df55-69b7-4cf7-aa0b-4ec06ae35430', 89, 3152, N'nUpdateFacilityUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'f4f94c11-25e8-4974-a66d-ba4cc3a177f9')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[nUpdateUserUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('f4f94c11-25e8-4974-a66d-ba4cc3a177f9', 89, 3153, N'nUpdateUserUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'a11ff464-2eed-4337-bbd4-1b70c063cfe2')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[tUpdateTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('a11ff464-2eed-4337-bbd4-1b70c063cfe2', 89, 3154, N'tUpdateTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'd1ce67a0-af65-456f-9b76-9dc362cb2d3c')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[tMobileTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('d1ce67a0-af65-456f-9b76-9dc362cb2d3c', 89, 3155, N'tMobileTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'eafbe353-2685-427e-bdbf-bbfe65f78c3c')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[tSystemUpdateTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('eafbe353-2685-427e-bdbf-bbfe65f78c3c', 89, 3156, N'tSystemUpdateTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '3c2374cc-7a72-4321-a1f7-7fb8fb0ed716')
    BEGIN
        PRINT 'Adding column [AlertEngineConfig].[nImportUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('3c2374cc-7a72-4321-a1f7-7fb8fb0ed716', 89, 3157, N'nImportUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20221103 17:43:55', '20221103 17:43:55', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertEngineConfig_Del]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_AlertEngineConfig_Del] from [dbo].[AlertEngineConfig]'

    	DROP TRIGGER [dbo].[tr_kr_audit_AlertEngineConfig_Del]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertEngineConfig_Del]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_AlertEngineConfig_Del] on [dbo].[AlertEngineConfig]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_AlertEngineConfig_Del] ON [dbo].[AlertEngineConfig] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20221103 17:43:55

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3137,
            0,
            CONVERT( NVARCHAR(max), [cEmailAddress] )
        FROM
            DELETED

        --INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        --SELECT
        --    @AuditID,
        --    ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
        --    3136,
        --    0,
        --    CONVERT( NVARCHAR(max), [cEmailPassword] )
        --FROM
        --    DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3135,
            0,
            CONVERT( NVARCHAR(max), [cEmailUserName] )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3139,
            0,
            CONVERT( NVARCHAR(max), [cFromName] )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3141,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cGlobalBCC], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3140,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cGlobalCC], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3142,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cLanguage], '''') )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3138,
            0,
            CONVERT( NVARCHAR(max), [cSmtpHostName] )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3145,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3148,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3147,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3146,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3144,
            0,
            CONVERT(NVARCHAR, [lUseSSL])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3149,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3150,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3134,
            0,
            CONVERT(NVARCHAR( 36 ), [nAlertEngineConfigUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3157,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3143,
            0,
            CONVERT(NVARCHAR, [nPort])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3152,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3153,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3151,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3155,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3156,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3154,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 89, @RowsAffected, ''D'', @AuditedUser
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_AlertEngineConfig_Del]', 'last', 'delete', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertEngineConfig_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_AlertEngineConfig_Ins] from [dbo].[AlertEngineConfig]'

    	DROP TRIGGER [dbo].[tr_kr_audit_AlertEngineConfig_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertEngineConfig_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_AlertEngineConfig_Ins] on [dbo].[AlertEngineConfig]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_AlertEngineConfig_Ins] ON [dbo].[AlertEngineConfig] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20221103 17:43:55

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3137,
            0,
            CONVERT( NVARCHAR(max), [cEmailAddress] )
        FROM
            INSERTED

        --INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        --SELECT
        --    @AuditID,
        --    ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
        --    3136,
        --    0,
        --    CONVERT( NVARCHAR(max), [cEmailPassword] )
        --FROM
        --    INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3135,
            0,
            CONVERT( NVARCHAR(max), [cEmailUserName] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3139,
            0,
            CONVERT( NVARCHAR(max), [cFromName] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3141,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cGlobalBCC], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3140,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cGlobalCC], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3142,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cLanguage], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3138,
            0,
            CONVERT( NVARCHAR(max), [cSmtpHostName] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3145,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3148,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3147,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3146,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3144,
            0,
            CONVERT(NVARCHAR, [lUseSSL])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3149,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3150,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3134,
            0,
            CONVERT(NVARCHAR( 36 ), [nAlertEngineConfigUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3143,
            0,
            CONVERT(NVARCHAR, [nPort])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), [nAlertEngineConfigUID]),
            3151,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 89, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_AlertEngineConfig_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertEngineConfig_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_AlertEngineConfig_Upd] from [dbo].[AlertEngineConfig]'

    	DROP TRIGGER [dbo].[tr_kr_audit_AlertEngineConfig_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertEngineConfig_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_AlertEngineConfig_Upd] on [dbo].[AlertEngineConfig]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_AlertEngineConfig_Upd] ON [dbo].[AlertEngineConfig] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20221103 17:43:55

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cEmailAddress] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3137,
                0,
                CONVERT( NVARCHAR(max), d.[cEmailAddress] ),
                CONVERT( NVARCHAR(max), i.[cEmailAddress] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[cEmailAddress] <> i.[cEmailAddress] ) OR
                ( d.[cEmailAddress] IS NULL AND i.[cEmailAddress] IS NOT NULL ) OR
                ( i.[cEmailAddress] IS NULL AND d.[cEmailAddress] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        --IF( UPDATE( [cEmailPassword] ) )
        --BEGIN
        --    INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
        --    SELECT
        --        @AuditID,
        --        ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
        --        3136,
        --        0,
        --        CONVERT( NVARCHAR(max), d.[cEmailPassword] ),
        --        CONVERT( NVARCHAR(max), i.[cEmailPassword] )
        --    FROM
        --        INSERTED i
        --        FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
        --    WHERE
        --        ( d.[cEmailPassword] <> i.[cEmailPassword] ) OR
        --        ( d.[cEmailPassword] IS NULL AND i.[cEmailPassword] IS NOT NULL ) OR
        --        ( i.[cEmailPassword] IS NULL AND d.[cEmailPassword] IS NOT NULL )
        --
        --    SELECT @CaptureCount = @CaptureCount + @@RowCount
        --END

        IF( UPDATE( [cEmailUserName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3135,
                0,
                CONVERT( NVARCHAR(max), d.[cEmailUserName] ),
                CONVERT( NVARCHAR(max), i.[cEmailUserName] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[cEmailUserName] <> i.[cEmailUserName] ) OR
                ( d.[cEmailUserName] IS NULL AND i.[cEmailUserName] IS NOT NULL ) OR
                ( i.[cEmailUserName] IS NULL AND d.[cEmailUserName] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFromName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3139,
                0,
                CONVERT( NVARCHAR(max), d.[cFromName] ),
                CONVERT( NVARCHAR(max), i.[cFromName] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[cFromName] <> i.[cFromName] ) OR
                ( d.[cFromName] IS NULL AND i.[cFromName] IS NOT NULL ) OR
                ( i.[cFromName] IS NULL AND d.[cFromName] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cGlobalBCC] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3141,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cGlobalBCC], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cGlobalBCC], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( NULLIF(d.[cGlobalBCC], '''') <> NULLIF(i.[cGlobalBCC], '''') ) OR
                ( NULLIF(d.[cGlobalBCC], '''') IS NULL AND NULLIF(i.[cGlobalBCC], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cGlobalBCC], '''') IS NULL AND NULLIF(d.[cGlobalBCC], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cGlobalCC] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3140,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cGlobalCC], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cGlobalCC], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( NULLIF(d.[cGlobalCC], '''') <> NULLIF(i.[cGlobalCC], '''') ) OR
                ( NULLIF(d.[cGlobalCC], '''') IS NULL AND NULLIF(i.[cGlobalCC], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cGlobalCC], '''') IS NULL AND NULLIF(d.[cGlobalCC], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cLanguage] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3142,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cLanguage], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cLanguage], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( NULLIF(d.[cLanguage], '''') <> NULLIF(i.[cLanguage], '''') ) OR
                ( NULLIF(d.[cLanguage], '''') IS NULL AND NULLIF(i.[cLanguage], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cLanguage], '''') IS NULL AND NULLIF(d.[cLanguage], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cSmtpHostName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3138,
                0,
                CONVERT( NVARCHAR(max), d.[cSmtpHostName] ),
                CONVERT( NVARCHAR(max), i.[cSmtpHostName] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[cSmtpHostName] <> i.[cSmtpHostName] ) OR
                ( d.[cSmtpHostName] IS NULL AND i.[cSmtpHostName] IS NOT NULL ) OR
                ( i.[cSmtpHostName] IS NULL AND d.[cSmtpHostName] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3145,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3148,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3147,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3146,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lUseSSL] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3144,
                0,
                CONVERT(NVARCHAR, d.[lUseSSL]),
                CONVERT(NVARCHAR, i.[lUseSSL])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[lUseSSL] <> i.[lUseSSL] ) OR
                ( d.[lUseSSL] IS NULL AND i.[lUseSSL] IS NOT NULL ) OR
                ( i.[lUseSSL] IS NULL AND d.[lUseSSL] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3149,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3150,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAlertEngineConfigUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3134,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAlertEngineConfigUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAlertEngineConfigUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[nAlertEngineConfigUID] <> i.[nAlertEngineConfigUID] ) OR
                ( d.[nAlertEngineConfigUID] IS NULL AND i.[nAlertEngineConfigUID] IS NOT NULL ) OR
                ( i.[nAlertEngineConfigUID] IS NULL AND d.[nAlertEngineConfigUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nPort] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3143,
                0,
                CONVERT(NVARCHAR, d.[nPort]),
                CONVERT(NVARCHAR, i.[nPort])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[nPort] <> i.[nPort] ) OR
                ( d.[nPort] IS NULL AND i.[nPort] IS NOT NULL ) OR
                ( i.[nPort] IS NULL AND d.[nPort] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertEngineConfigUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertEngineConfigUID], d.[nAlertEngineConfigUID] )),
                3151,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertEngineConfigUID] = i.[nAlertEngineConfigUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN
        
            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED
        
            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 89, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_AlertEngineConfig_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


	UPDATE [dbo].[SystemDefaults] SET lDeleted = -1, tUpdateTime = '20221104 20:23:35.027' WHERE nSystemDefaultUID = '66737C9B-2540-4E7A-A2C9-BC2F22176E8F'
	UPDATE [dbo].[SystemDefaults] SET lDeleted = -1, tUpdateTime = '20221104 20:23:35.027' WHERE nSystemDefaultUID = '14E00BAD-949C-4C85-9D8C-417784741025'
	UPDATE [dbo].[SystemDefaults] SET lDeleted = -1, tUpdateTime = '20221104 20:23:35.027' WHERE nSystemDefaultUID = 'C127B8C5-D1AF-4099-B427-2941D7CCCF99'
	UPDATE [dbo].[SystemDefaults] SET lDeleted = -1, tUpdateTime = '20221104 20:23:35.027' WHERE nSystemDefaultUID = '39F3A395-1818-4219-863A-8F2352A694A7'
	UPDATE [dbo].[SystemDefaults] SET lDeleted = -1, tUpdateTime = '20221104 20:23:35.027' WHERE nSystemDefaultUID = 'D843A08F-2FDC-4516-804B-921BE6168B44'
	UPDATE [dbo].[SystemDefaults] SET lDeleted = -1, tUpdateTime = '20221104 20:23:35.027' WHERE nSystemDefaultUID = 'DFA36B70-5EB7-45D6-970E-A9404FCC2042'
	UPDATE [dbo].[SystemDefaults] SET lDeleted = -1, tUpdateTime = '20221104 20:23:35.027' WHERE nSystemDefaultUID = 'A8F3A310-8B6F-4BA7-9DB4-D0705463FC1D'
	UPDATE [dbo].[SystemDefaults] SET lDeleted = -1, tUpdateTime = '20221104 20:23:35.027' WHERE nSystemDefaultUID = '157F9FFD-7B9A-4CF3-A2FF-D7995665BA6C'
	UPDATE [dbo].[SystemDefaults] SET lDeleted = -1, tUpdateTime = '20221104 20:23:35.027' WHERE nSystemDefaultUID = '6DCAB6A7-01E0-4E37-9479-E764A491BC27'
	UPDATE [dbo].[SystemDefaults] SET lDeleted = -1, tUpdateTime = '20221104 20:23:35.027' WHERE nSystemDefaultUID = '8D4FA46D-294D-439B-BF79-93381935B89E'

    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '6256bab9-156d-4048-99aa-475b3e7fb82e')
	BEGIN 
	    PRINT N'Adding UCI Data Item for nAlertEngineConfigUID'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('6256bab9-156d-4048-99aa-475b3e7fb82e', N'AlertEngineConfig', N'nAlertEngineConfigUID', N'Label', N'Alert Engine Config UID',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '14eb3d88-e18e-47d4-a53f-e9b142c6a04b')
	BEGIN 
	    PRINT N'Adding UCI Data Item for cEmailUserName'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('14eb3d88-e18e-47d4-a53f-e9b142c6a04b', N'AlertEngineConfig', N'cEmailUserName', N'Label', N'Email User Name',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '1725b3db-23fe-40ee-87e0-fb5ef64aac29')
	BEGIN 
	    PRINT N'Adding UCI Data Item for cEmailPassword'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('1725b3db-23fe-40ee-87e0-fb5ef64aac29', N'AlertEngineConfig', N'cEmailPassword', N'Label', N'Email Password',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '176c2fdc-d77e-4284-967d-8cf3732e6af9')
	BEGIN 
	    PRINT N'Adding UCI Data Item for cEmailAddress'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('176c2fdc-d77e-4284-967d-8cf3732e6af9', N'AlertEngineConfig', N'cEmailAddress', N'Label', N'Email Address',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '3852f135-3b4a-468f-ac3e-2ac18c9bb515')
	BEGIN 
	    PRINT N'Adding UCI Data Item for cSmtpHostName'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('3852f135-3b4a-468f-ac3e-2ac18c9bb515', N'AlertEngineConfig', N'cSmtpHostName', N'Label', N'Smtp Host Name',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'a6a9dfa5-60e4-4aa9-b8f0-2ad969d99ef8')
	BEGIN 
	    PRINT N'Adding UCI Data Item for cFromName'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('a6a9dfa5-60e4-4aa9-b8f0-2ad969d99ef8', N'AlertEngineConfig', N'cFromName', N'Label', N'From Name',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '0de9fda7-4850-4f0c-9507-8a3a2f2db233')
	BEGIN 
	    PRINT N'Adding UCI Data Item for cGlobalCC'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0de9fda7-4850-4f0c-9507-8a3a2f2db233', N'AlertEngineConfig', N'cGlobalCC', N'Label', N'Global CC',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '0a923c38-864e-4d2e-8620-360db5966c12')
	BEGIN 
	    PRINT N'Adding UCI Data Item for cGlobalBCC'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('0a923c38-864e-4d2e-8620-360db5966c12', N'AlertEngineConfig', N'cGlobalBCC', N'Label', N'Global BCC',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '4ec48803-658b-4f35-82a6-4bdbe47da1b7')
	BEGIN 
	    PRINT N'Adding UCI Data Item for cLanguage'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('4ec48803-658b-4f35-82a6-4bdbe47da1b7', N'AlertEngineConfig', N'cLanguage', N'Label', N'Language',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = 'b2cb9cfc-a504-4be4-bf96-6d7166f6b008')
	BEGIN 
	    PRINT N'Adding UCI Data Item for nPort'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('b2cb9cfc-a504-4be4-bf96-6d7166f6b008', N'AlertEngineConfig', N'nPort', N'Label', N'Port',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '010a4e57-9597-4659-8918-f4470570ba13')
	BEGIN 
	    PRINT N'Adding UCI Data Item for lUseSSL'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('010a4e57-9597-4659-8918-f4470570ba13', N'AlertEngineConfig', N'lUseSSL', N'Label', N'Use SSL',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END 

	IF NOT EXISTS(SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '30548059-b1eb-4516-a5d2-225eab9c4b5a')
	BEGIN 
	    PRINT N'Adding UCI Data Item for lActive'
	    INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime])
	    VALUES('30548059-b1eb-4516-a5d2-225eab9c4b5a', N'AlertEngineConfig', N'lActive', N'Label', N'Active',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221107 16:44:53.000','20221107 16:44:53.000')

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-5317<<--
	UPDATE 
		[dbo].[SecurityGroupFieldLinks]
	SET 
		lDeleted = -1,
		tUpdateTime = '20221111 21:37:06.977'
	WHERE 
		nSecurityGroupUID = '28EEF7A0-A9C7-44E0-9B44-4AC74E4E548B'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	UPDATE
		[dbo].[SecurityGroupMembers]
	SET
		lDeleted = -1,
		tUpdateTime = '20221111 21:37:06.977'
	WHERE
		nSecurityGroupUID = '28EEF7A0-A9C7-44E0-9B44-4AC74E4E548B'
	
	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	
	UPDATE
		[dbo].[SecurityGroups]
	SET
		lDeleted = -1,
		tUpdateTime = '20221111 21:37:06.977'
	WHERE
		nSecurityGroupUID = '28EEF7A0-A9C7-44E0-9B44-4AC74E4E548B'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '1CBDC09C-0918-45C2-85E1-480C0EDAA216')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],
			[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('1CBDC09C-0918-45C2-85E1-480C0EDAA216', N'MET/CAL General Options', N'RUN_EDITOR', 'Visible', N'1',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172',
			'20221111 21:37:06.977','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221111 21:37:06.977','20221111 21:37:06.977',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END

	IF NOT EXISTS (SELECT * FROM [dbo].[UCIData] WHERE nUCIDataUID = '91048CEA-B044-479E-9485-39F7BF62CFD8')
	BEGIN
		PRINT N'Creating UCI data item'

		INSERT INTO [dbo].[UCIData]([nUCIDataUID],[cModel],[cField],[cProperty],[cValue],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],
			[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('91048CEA-B044-479E-9485-39F7BF62CFD8', N'MET/CAL General Options', N'RUN_EDITOR', 'Enabled', N'1',-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172',
			'20221111 21:37:06.977','DBA97ADF-F868-459D-8343-DE1DF0FFB398','915F9722-3175-4E4D-A571-4A478E8E5172','20221111 21:37:06.977','20221111 21:37:06.977',NULL,NULL)

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END
	

	-->>MTM-9282<<--
	IF NOT EXISTS(SELECT * FROM [dbo].[SystemDefaults] WHERE nSystemDefaultUID = '3D90E3B5-479A-4090-8BF0-3927074B2D1A')
	BEGIN
		PRINT N'Adding System Default'

		INSERT INTO [dbo].[SystemDefaults] ([nSystemDefaultUID], [cAuthority], [cProperty], [cValue], [nOrder], [cAction], [cGraphic], [mNotes], 
			[lLocal], [lSystemic], [lWarehouse], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], 
			[nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
		VALUES ('3D90E3B5-479A-4090-8BF0-3927074B2D1A', N'Default', N'Asset - Use Receiving Screen', N'(none)', 0, NULL, NULL, 
			N'AFFECTS: Asset and Receiving - Specifies whether or not the Receiving screen is launched when using the Receive button on the Asset screen\n\nACTION: If Active, clicking the Receive button on the Asset screen will cause the Receiving screen to be launched, with the source asset selected for receiving.\nIf Inactive, clicking the Receive button on the Asset screen will receive the asset and open the created Work Order (legacy behavior). No data checks configured for the Receiving screen will be run.', 
			0, 0, 0, 0, 0, 0, 0, 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20221216 18:49:06.843', 
			'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20221216 18:49:06.843', '20221216 18:49:06.843', NULL, NULL);

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END


	-->>MTM-9431<<--
    IF NOT EXISTS(SELECT * FROM [dbo].[AuditTables] WHERE [TableID] = 90)
    BEGIN
        PRINT 'Adding table [SecurityGroupFieldLinks] to [AuditTables]'

        SET IDENTITY_INSERT [dbo].[AuditTables] ON
        INSERT INTO [dbo].[AuditTables] ([TableID], [Owner], [TableName], [AuditTable], [AuditInserts], [AuditUpdates], [AuditDeletes], [AuditDeletesAll], [UniqueKeyType], [UserColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID]) 
        VALUES (90, N'dbo', N'SecurityGroupFieldLinks', 1, 1, 1, 0, 1, 'P', N' ', -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditTables] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'b3b0e6d0-6cf9-4f17-829a-aebd68fc9261')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[nSecurityGroupFieldLinkUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('b3b0e6d0-6cf9-4f17-829a-aebd68fc9261', 90, 3158, N'nSecurityGroupFieldLinkUID', 1, 0, 0, 1, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '6cb50b7a-3a0e-49eb-90c0-07435a16fd74')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[nSecurityGroupUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('6cb50b7a-3a0e-49eb-90c0-07435a16fd74', 90, 3159, N'nSecurityGroupUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '82b8f359-68af-4aea-bea4-6380f8bd9a1c')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[nUCIDataUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('82b8f359-68af-4aea-bea4-6380f8bd9a1c', 90, 3160, N'nUCIDataUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '79797aef-52f8-4ef8-b810-2f385180ea3d')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[lActive] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('79797aef-52f8-4ef8-b810-2f385180ea3d', 90, 3161, N'lActive', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '8b5ba57d-e72f-448a-82b2-d5460d02a07f')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[lDeleted] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('8b5ba57d-e72f-448a-82b2-d5460d02a07f', 90, 3162, N'lDeleted', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '13b83dfa-18a9-4ccb-91a8-69881100fa06')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[lApproved] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('13b83dfa-18a9-4ccb-91a8-69881100fa06', 90, 3163, N'lApproved', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '4008d071-77e3-4bee-b917-144f8998d06e')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[lAdded] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('4008d071-77e3-4bee-b917-144f8998d06e', 90, 3164, N'lAdded', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'bf60d9da-803f-42ec-a10c-0eabff4cdd10')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[nAddFacilityUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('bf60d9da-803f-42ec-a10c-0eabff4cdd10', 90, 3165, N'nAddFacilityUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'f0258370-be12-455d-89ba-335be1fa0a3e')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[nAddUserUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('f0258370-be12-455d-89ba-335be1fa0a3e', 90, 3166, N'nAddUserUID', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '565a87f8-5c42-4dc7-bf13-70a3d70b636a')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[tAddTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('565a87f8-5c42-4dc7-bf13-70a3d70b636a', 90, 3167, N'tAddTime', 1, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '38179106-2dca-4d23-a3b0-8b991ae8162f')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[nUpdateFacilityUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('38179106-2dca-4d23-a3b0-8b991ae8162f', 90, 3168, N'nUpdateFacilityUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = 'f8473143-00a9-49e7-a8f4-b53cc0e1c0e1')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[nUpdateUserUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('f8473143-00a9-49e7-a8f4-b53cc0e1c0e1', 90, 3169, N'nUpdateUserUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '11ba4168-6593-4697-b328-7c0a2e24798f')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[tUpdateTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('11ba4168-6593-4697-b328-7c0a2e24798f', 90, 3170, N'tUpdateTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '77828690-0bae-41f0-9e67-c7404a5a029a')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[tMobileTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON

        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('77828690-0bae-41f0-9e67-c7404a5a029a', 90, 3171, N'tMobileTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '80881b35-93ee-4bed-b93a-51e69a4ceef4')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[tSystemUpdateTime] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('80881b35-93ee-4bed-b93a-51e69a4ceef4', 90, 3172, N'tSystemUpdateTime', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END

    IF NOT EXISTS(SELECT * FROM [dbo].[AuditColumns] WHERE [AuditColumnID] = '2c30174c-148d-4e10-803e-a295a55cd9cd')
    BEGIN
        PRINT 'Adding column [SecurityGroupFieldLinks].[nImportUID] to [AuditColumns]'

        SET IDENTITY_INSERT [dbo].[AuditColumns] ON
        INSERT INTO [dbo].[AuditColumns] ([AuditColumnID], [TableID], [ColumnID], [ColumnName], [AuditColumn], [CaptureColumn], [IsLookup], [KeyColumn], [lActive], [lDeleted], [lApproved], [lAdded], [nAddFacilityUID], [nAddUserUID], [tAddTime], [nUpdateFacilityUID], [nUpdateUserUID], [tUpdateTime], [tMobileTime], [tSystemUpdateTime], [nImportUID])
        VALUES ('2c30174c-148d-4e10-803e-a295a55cd9cd', 90, 3173, N'nImportUID', 0, 0, 0, 0, -1, 0, 0, 0, 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', 'dba97adf-f868-459d-8343-de1df0ffb398', '915f9722-3175-4e4d-a571-4a478e8e5172', '20230103 23:20:16', '20230103 23:20:16', NULL, NULL)
        SET IDENTITY_INSERT [dbo].[AuditColumns] OFF

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_SecurityGroupFieldLinks_Del]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Del] from [dbo].[SecurityGroupFieldLinks]'

    	DROP TRIGGER [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Del]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_SecurityGroupFieldLinks_Del]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Del] on [dbo].[SecurityGroupFieldLinks]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Del] ON [dbo].[SecurityGroupFieldLinks] FOR DELETE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230103 23:20:16

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM DELETED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3161,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3164,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3163,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3162,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3165,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3166,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3173,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3158,
            0,
            CONVERT(NVARCHAR( 36 ), [nSecurityGroupFieldLinkUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3159,
            0,
            CONVERT(NVARCHAR( 36 ), [nSecurityGroupUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3160,
            0,
            CONVERT(NVARCHAR( 36 ), [nUCIDataUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3168,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateFacilityUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3169,
            0,
            CONVERT(NVARCHAR( 36 ), [nUpdateUserUID])
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3167,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3171,
            0,
            CONVERT( NVARCHAR( 34 ), [tMobileTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3172,
            0,
            CONVERT( NVARCHAR( 34 ), [tSystemUpdateTime], 121 )
        FROM
            DELETED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3170,
            0,
            CONVERT( NVARCHAR( 34 ), [tUpdateTime], 121 )
        FROM
            DELETED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 90, @RowsAffected, ''D'', @AuditedUser
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_SecurityGroupFieldLinks_Del]', 'last', 'delete', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_SecurityGroupFieldLinks_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Ins] from [dbo].[SecurityGroupFieldLinks]'

    	DROP TRIGGER [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_SecurityGroupFieldLinks_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Ins] on [dbo].[SecurityGroupFieldLinks]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Ins] ON [dbo].[SecurityGroupFieldLinks] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230103 23:20:16

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3161,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3164,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3163,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3162,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3165,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3166,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3158,
            0,
            CONVERT(NVARCHAR( 36 ), [nSecurityGroupFieldLinkUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3159,
            0,
            CONVERT(NVARCHAR( 36 ), [nSecurityGroupUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3160,
            0,
            CONVERT(NVARCHAR( 36 ), [nUCIDataUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), [nSecurityGroupFieldLinkUID]),
            3167,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 90, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_SecurityGroupFieldLinks_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_SecurityGroupFieldLinks_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Upd] from [dbo].[SecurityGroupFieldLinks]'

    	DROP TRIGGER [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_SecurityGroupFieldLinks_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Upd] on [dbo].[SecurityGroupFieldLinks]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_SecurityGroupFieldLinks_Upd] ON [dbo].[SecurityGroupFieldLinks] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230103 23:20:16

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )

        -- Populate audit detail records...
        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nSecurityGroupFieldLinkUID], d.[nSecurityGroupFieldLinkUID] )),
                3161,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nSecurityGroupFieldLinkUID], d.[nSecurityGroupFieldLinkUID] )),
                3164,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nSecurityGroupFieldLinkUID], d.[nSecurityGroupFieldLinkUID] )),
                3163,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nSecurityGroupFieldLinkUID], d.[nSecurityGroupFieldLinkUID] )),
                3162,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nSecurityGroupFieldLinkUID], d.[nSecurityGroupFieldLinkUID] )),
                3165,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nSecurityGroupFieldLinkUID], d.[nSecurityGroupFieldLinkUID] )),
                3166,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSecurityGroupFieldLinkUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nSecurityGroupFieldLinkUID], d.[nSecurityGroupFieldLinkUID] )),
                3158,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nSecurityGroupFieldLinkUID]),
                CONVERT(NVARCHAR( 36 ), i.[nSecurityGroupFieldLinkUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )
            WHERE
                ( d.[nSecurityGroupFieldLinkUID] <> i.[nSecurityGroupFieldLinkUID] ) OR
                ( d.[nSecurityGroupFieldLinkUID] IS NULL AND i.[nSecurityGroupFieldLinkUID] IS NOT NULL ) OR
                ( i.[nSecurityGroupFieldLinkUID] IS NULL AND d.[nSecurityGroupFieldLinkUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nSecurityGroupUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nSecurityGroupFieldLinkUID], d.[nSecurityGroupFieldLinkUID] )),
                3159,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nSecurityGroupUID]),
                CONVERT(NVARCHAR( 36 ), i.[nSecurityGroupUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )
            WHERE
                ( d.[nSecurityGroupUID] <> i.[nSecurityGroupUID] ) OR
                ( d.[nSecurityGroupUID] IS NULL AND i.[nSecurityGroupUID] IS NOT NULL ) OR
                ( i.[nSecurityGroupUID] IS NULL AND d.[nSecurityGroupUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nUCIDataUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nSecurityGroupFieldLinkUID], d.[nSecurityGroupFieldLinkUID] )),
                3160,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nUCIDataUID]),
                CONVERT(NVARCHAR( 36 ), i.[nUCIDataUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )
            WHERE
                ( d.[nUCIDataUID] <> i.[nUCIDataUID] ) OR
                ( d.[nUCIDataUID] IS NULL AND i.[nUCIDataUID] IS NOT NULL ) OR
                ( i.[nUCIDataUID] IS NULL AND d.[nUCIDataUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nSecurityGroupFieldLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nSecurityGroupFieldLinkUID], d.[nSecurityGroupFieldLinkUID] )),
                3167,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nSecurityGroupFieldLinkUID] = i.[nSecurityGroupFieldLinkUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN
        
            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED
        
            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 90, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_SecurityGroupFieldLinks_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END

	IF NOT EXISTS(SELECT * FROM [dbo].[AuditLink] WHERE [nAuditLinkUID] = 'DCD4BB18-9BBF-4E5C-A5C4-77FBA6CB602E')
	BEGIN
		PRINT 'Adding audit link'

		INSERT INTO [dbo].[AuditLink] ([nAuditLinkUID],[cColumnName],[cTableName],[cReturnValue],[mCustomSelect],[lActive],[lDeleted],[lApproved],[lAdded],[nAddFacilityUID],[nAddUserUID],[tAddTime],[nUpdateFacilityUID],[nUpdateUserUID],[tUpdateTime],[tMobileTime],[tSystemUpdateTime],[nImportUID])
		VALUES('DCD4BB18-9BBF-4E5C-A5C4-77FBA6CB602E','nUCIDataUID','UCIData','AuditDisplay',NULL,-1,0,0,0,'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20230104 23:55:27.023', 'DBA97ADF-F868-459D-8343-DE1DF0FFB398', '915F9722-3175-4E4D-A571-4A478E8E5172', '20230104 23:55:27.023', '20230104 23:55:27.023', NULL, NULL)

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END	
  
  
	-->>MTM-7376<<--
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '01158336-3CBB-41AE-8BBE-FA51DCB758AD') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = '01158336-3CBB-41AE-8BBE-FA51DCB758AD' END 
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '0F685664-2ED4-41E5-8004-34BDBD7CEDC5') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = '0F685664-2ED4-41E5-8004-34BDBD7CEDC5' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '12C3783B-887F-48B5-BDAC-C30E5F746F13') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = '12C3783B-887F-48B5-BDAC-C30E5F746F13' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '20DB3E8E-F930-425F-8C14-CE81C6D0A47A') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = '20DB3E8E-F930-425F-8C14-CE81C6D0A47A' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '26FD76B0-FF77-473E-B8E1-D1B491CF020F') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = '26FD76B0-FF77-473E-B8E1-D1B491CF020F' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '2D7513E5-497A-4676-868D-A882B04DCAE8') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = '2D7513E5-497A-4676-868D-A882B04DCAE8' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '3C476D15-286F-45B2-A449-ADE11D78582D') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = '3C476D15-286F-45B2-A449-ADE11D78582D' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = '5D6F5B56-FC3E-4607-A63B-DDEA62608A5D') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = '5D6F5B56-FC3E-4607-A63B-DDEA62608A5D' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'C25A69A6-0EA3-4F34-ABC5-F347EDAB1C5E') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = 'C25A69A6-0EA3-4F34-ABC5-F347EDAB1C5E' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'EC91793A-81AA-448D-B356-D3929507B52F') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = 'EC91793A-81AA-448D-B356-D3929507B52F' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'ED316105-2557-45DD-A53A-1B176E084818') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = 'ED316105-2557-45DD-A53A-1B176E084818' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElementLink] WHERE [nContextElementLinkUID] = 'F0E5B7AA-E66A-40A4-B82A-FF0A7B2ACA8F') BEGIN UPDATE [dbo].[ContextElementLink] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementLinkUID] = 'F0E5B7AA-E66A-40A4-B82A-FF0A7B2ACA8F' END
	
	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	
	
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE [nContextElementUID] = '9284A57E-6884-4BAF-AFFA-8C593335A579') BEGIN UPDATE [dbo].[ContextElements] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementUID] = '9284A57E-6884-4BAF-AFFA-8C593335A579' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE [nContextElementUID] = 'D557F577-887A-45B7-B9B6-4895912B3514') BEGIN UPDATE [dbo].[ContextElements] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementUID] = 'D557F577-887A-45B7-B9B6-4895912B3514' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE [nContextElementUID] = '48716DEA-5C39-4D06-811B-12FA964B4FF3') BEGIN UPDATE [dbo].[ContextElements] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementUID] = '48716DEA-5C39-4D06-811B-12FA964B4FF3' END
	IF EXISTS(SELECT * FROM [dbo].[ContextElements] WHERE [nContextElementUID] = 'EBF6B735-9443-4C57-B9AC-DF1A12E59D64') BEGIN UPDATE [dbo].[ContextElements] SET [lDeleted] = -1, [tUpdateTime] = '20230110 00:10:38.280' WHERE [nContextElementUID] = 'EBF6B735-9443-4C57-B9AC-DF1A12E59D64' END
	
	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
	
	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-->>MTM-9415<<--
	PRINT 'Updating context elements for Find screens'
	
	UPDATE 
		[dbo].ContextElements
	SET 
		cValue = 'ass.cDisposition',
		tUpdateTime = '20230110 16:51:04.325'
	WHERE 
		nContextElementUID='4202BC66-B73E-40AE-8CF3-DAD79D07A974'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	UPDATE 
		[dbo].ContextElements
	SET 
		cValue = 'ass.cStandardType',
		tUpdateTime = '20230110 16:51:04.325'
	WHERE 
		nContextElementUID='86BF6FEA-D87E-44AA-AC8D-9DD8C50440BC'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	UPDATE 
		[dbo].ContextElements
	SET 
		cValue = 'ass.cTyWeightUOM',
		tUpdateTime = '20230110 16:51:04.325'
	WHERE 
		nContextElementUID='7DFCC882-94D4-4FD5-857A-01526DF7C026'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	UPDATE 
		[dbo].ContextElements
	SET 
		cValue = 'ass.cTyAuthority',
		tUpdateTime = '20230110 16:51:04.325'
	WHERE 
		nContextElementUID='09469565-E1D1-43D8-B26B-6E7F019A5928'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	UPDATE 
		[dbo].ContextElements
	SET 
		cValue = 'ass.cTyArea',
		tUpdateTime = '20230110 16:51:04.325'
	WHERE 
		nContextElementUID='DD197492-15F6-4C61-A7ED-855E5DCFF02E'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-->>MTM-9669<<--
	UPDATE 
		[dbo].ContextElements
	SET 
		cValue = 'ass.cNextMaintType',
		tUpdateTime = '20230110 16:51:04.325'
	WHERE 
		nContextElementUID='D3192BE2-B63C-4533-979E-8A195D8CC5BA'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-->>MTM-9679<<--
	UPDATE 
		[dbo].ContextElements
	SET 
		cValue = 'ass.lTyActive',
		tUpdateTime = '20230110 16:51:04.325'
	WHERE 
		nContextElementUID='20B609E8-706C-49D5-B232-227BC85DA339'

	IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


	-->>MTM-9649<<--
	IF OBJECT_ID(N'[dbo].[AuditDisplayCache]', 'U') IS NULL
	BEGIN
		PRINT N'Adding table [dbo].[AuditDisplayCache]'

		CREATE TABLE [dbo].[AuditDisplayCache](
			[RecordUID] [uniqueidentifier] NOT NULL,
			[DisplayValue] [nvarchar](4000) NOT NULL,
			[lActive] [int] NOT NULL,
			[lDeleted] [int] NOT NULL,
			[lApproved] [int] NOT NULL,
			[lAdded] [int] NOT NULL,
			[nAddFacilityUID] [uniqueidentifier] NOT NULL,
			[nAddUserUID] [uniqueidentifier] NOT NULL,
			[tAddTime] [datetime] NOT NULL,
			[nUpdateFacilityUID] [uniqueidentifier] NOT NULL,
			[nUpdateUserUID] [uniqueidentifier] NOT NULL,
			[tUpdateTime] [datetime] NOT NULL,
			[tMobileTime] [datetime] NOT NULL,
			[tSystemUpdateTime] [datetime] NULL,
			[nImportUID] [uniqueidentifier] NULL,
			CONSTRAINT [PK_AuditDisplayCache] PRIMARY KEY CLUSTERED 
			(
				[RecordUID] ASC
			)
		)

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_lActive]  DEFAULT (-1) FOR [lActive]

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_lDeleted]  DEFAULT (0) FOR [lDeleted]

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_lApproved]  DEFAULT (0) FOR [lApproved]

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_lAdded]  DEFAULT (0) FOR [lAdded]

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_nAddFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nAddFacilityUID]

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_nAddUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nAddUserUID]

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_tAddTime]  DEFAULT (GETUTCDATE()) FOR [tAddTime]

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_nUpdateFacilityUID]  DEFAULT ('DBA97ADF-F868-459D-8343-DE1DF0FFB398') FOR [nUpdateFacilityUID]

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_nUpdateUserUID]  DEFAULT ('915F9722-3175-4E4D-A571-4A478E8E5172') FOR [nUpdateUserUID]

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_tUpdateTime]  DEFAULT (GETUTCDATE()) FOR [tUpdateTime]

		ALTER TABLE [dbo].[AuditDisplayCache] ADD  CONSTRAINT [DF_AuditDisplayCache_tMobileTime]  DEFAULT (GETUTCDATE()) FOR [tMobileTime]
		

		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
					

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the record for the audit display' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'RecordUID'
		
		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Value to show on the audit viewer, for this foreign key reference' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'DisplayValue'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=inactive; -1 or 1 = active' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'lActive'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not deleted; -1 or 1 = deleted' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'lDeleted'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not approved; -1 or 1 = approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'lApproved'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0=not added; -1 or 1 = added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'lAdded'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the server that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'nAddFacilityUID'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the user that added the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'nAddUserUID'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was added' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'tAddTime'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the server that last updated the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'nUpdateFacilityUID'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UID of the last user to update the record' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'nUpdateUserUID'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'tUpdateTime'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for Mobile mode' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'tMobileTime'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Time the record was last updated for the Warehouse' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'tSystemUpdateTime'

		EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Import this record came from' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'AuditDisplayCache', @level2type=N'COLUMN',@level2name=N'nImportUID'	


		IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

		IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
			
	END

	IF OBJECT_ID(N'[dbo].[spl_CacheAuditDisplay]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CacheAuditDisplay]'
		
		DROP PROCEDURE [dbo].[spl_CacheAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
	
	IF OBJECT_ID(N'[dbo].[spl_CacheAuditDisplay]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CacheAuditDisplay]'

		EXEC sp_executesql N'
	
		CREATE PROCEDURE [dbo].[spl_CacheAuditDisplay]	
			@RecordUID UNIQUEIDENTIFIER  = NULL,
			@DisplayValue NVARCHAR(4000)  = NULL    
    	AS
		BEGIN
			IF EXISTS(SELECT * FROM [dbo].[AuditDisplayCache] WHERE RecordUID = @RecordUID)
				BEGIN
					UPDATE
						[dbo].[AuditDisplayCache]
					SET
						DisplayValue = @DisplayValue
					WHERE
						RecordUID = @RecordUID			
				END
			ELSE
				BEGIN
					INSERT INTO [dbo].[AuditDisplayCache] (
						RecordUID,
						DisplayValue
					)
					VALUES (
						@RecordUID,
						@DisplayValue
					)	
				END
	    END'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END	
	
	IF OBJECT_ID(N'[dbo].[spl_CacheAuditDisplay2]', 'P') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[spl_CacheAuditDisplay2]'
		
		DROP PROCEDURE [dbo].[spl_CacheAuditDisplay2]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[spl_CacheAuditDisplay2]', 'P') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[spl_CacheAuditDisplay2]'

		EXEC sp_executesql N'
	
		CREATE PROCEDURE [dbo].[spl_CacheAuditDisplay2]	
			@RecordUID UNIQUEIDENTIFIER = NULL,
			@TableName sysname = NULL    
    	AS
		BEGIN
			DECLARE @DisplayValue NVARCHAR(4000);
			DECLARE @uid NVARCHAR(36);
			DECLARE @sql NVARCHAR(4000);
			DECLARE @params NVARCHAR(255) = ''@Disp NVARCHAR(4000) OUTPUT'';
			SET @uid = CONVERT(NVARCHAR(36), @RecordUID);
			
			SET @sql = N''SET @Disp = (SELECT [dbo].[udf_GET_'' + @TableName + ''AuditDisplay] ('''''' + @uid + ''''''));'';
			EXEC sp_executesql @sql, @params, @Disp = @DisplayValue OUTPUT;
			
			IF EXISTS(SELECT * FROM [dbo].[AuditDisplayCache] WHERE RecordUID = @RecordUID)
				BEGIN
					UPDATE
						[dbo].[AuditDisplayCache]
					SET
						DisplayValue = @DisplayValue
					WHERE
						RecordUID = @RecordUID
				END
			ELSE
				BEGIN
					INSERT INTO [dbo].[AuditDisplayCache] (
						RecordUID,
						DisplayValue
					)
					VALUES (
						@RecordUID,
						@DisplayValue
					)	
				END
	    END'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
	END	
		
	IF OBJECT_ID(N'[dbo].[udf_GET_AuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_AuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_AuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_AuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_AuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(4000)

		AS
		BEGIN
			if(@nRecordUID IS NULL)
				RETURN N'''';
			
			DECLARE @ret AS NVARCHAR(4000);
			SET @ret = COALESCE((SELECT DisplayValue FROM [dbo].[AuditDisplayCache] WHERE RecordUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END	

	IF OBJECT_ID(N'[dbo].[udf_GET_AccountsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_AccountsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_AccountsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AccountsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_AccountsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_AccountsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN			
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cUsername FROM [dbo].[Accounts] WHERE nAccountUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END	
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AccreditationsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_AccreditationsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_AccreditationsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AccreditationsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_AccreditationsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_AccreditationsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cDescription FROM [dbo].[Accreditations] WHERE nAccreditationUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AlertParameterSheetAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_AlertParameterSheetAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_AlertParameterSheetAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AlertParameterSheetAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_AlertParameterSheetAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_AlertParameterSheetAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)
		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cDescription FROM [dbo].[AlertParameterSheet] WHERE nAlertParameterSheetUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AlertRecipientsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_AlertRecipientsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_AlertRecipientsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AlertRecipientsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_AlertRecipientsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_AlertRecipientsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cAlertName + '' '' + cFirstName + '' '' + cLastName FROM [dbo].[AlertRecipients] ar JOIN [dbo].[Alerts] a ON ar.nAlertUID = a.nAlertUID JOIN [dbo].[Contacts] c ON ar.nContactUID = c.nContactUID WHERE ar.nAlertRecipientUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AlertsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_AlertsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_AlertsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AlertsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_AlertsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_AlertsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cAlertName FROM [dbo].[Alerts] WHERE nAlertUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AssetFilesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_AssetFilesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_AssetFilesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AssetFilesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_AssetFilesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_AssetFilesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cFileName FROM [dbo].[AssetFiles] af JOIN [dbo].[Files] f ON af.nFileUID = f.nFileUID WHERE af.nAssetFileUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AssetsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_AssetsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_AssetsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_AssetsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_AssetsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_AssetsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cBarcode FROM [dbo].[Assets] WHERE nAssetUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_CallSheetAttributesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_CallSheetAttributesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_CallSheetAttributesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_CallSheetAttributesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_CallSheetAttributesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_CallSheetAttributesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cFileName FROM [dbo].[CallSheetAttributes] WHERE nCallSheetAttributeUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_CallSheetFilesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_CallSheetFilesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_CallSheetFilesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_CallSheetFilesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_CallSheetFilesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_CallSheetFilesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cFileName FROM [dbo].[CallSheetFiles] cf JOIN [dbo].[Files] f ON cf.nFileUID = f.nFileUID WHERE cf.nCallSheetFileUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_CallSheetPartsLinkAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_CallSheetPartsLinkAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_CallSheetPartsLinkAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_CallSheetPartsLinkAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_CallSheetPartsLinkAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_CallSheetPartsLinkAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cCallSheetNumber + '' '' + cPartNumber + '' '' + cDescription FROM [dbo].[CallSheetPartsLink] cpl JOIN [dbo].[CallSheets] cs ON cpl.nCallSheetUID = cs.nCallSheetUID JOIN [dbo].[Parts] p ON cpl.nPartUID = p.nPartUID WHERE cpl.nCallSheetPartLinkUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_CallSheetsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_CallSheetsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_CallSheetsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_CallSheetsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_CallSheetsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_CallSheetsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cCallSheetNumber FROM [dbo].[CallSheets] WHERE nCallSheetUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_CategoryAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_CategoryAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_CategoryAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_CategoryAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_CategoryAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_CategoryAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cDescription FROM [dbo].[Category] WHERE nCategoryUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ContactsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_ContactsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_ContactsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ContactsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_ContactsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_ContactsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cFirstName + '' '' + cLastName FROM [dbo].[Contacts] WHERE nContactUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_DataCheckSQLAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_DataCheckSQLAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_DataCheckSQLAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_DataCheckSQLAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_DataCheckSQLAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_DataCheckSQLAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cFunctionName FROM [dbo].[DataCheckSQL] WHERE nDataCheckSQLUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_EstimatesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_EstimatesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_EstimatesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_EstimatesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_EstimatesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_EstimatesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cEstimateNumber FROM [dbo].[Estimates] WHERE nEstimateUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_FacilitiesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_FacilitiesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_FacilitiesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_FacilitiesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_FacilitiesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_FacilitiesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(cFacilityName, cFacilityNumber) FROM [dbo].[Facilities] WHERE nFacilityUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_FacilityFilesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_FacilityFilesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_FacilityFilesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_FacilityFilesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_FacilityFilesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_FacilityFilesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cFileName FROM [dbo].[FacilityFiles] ff JOIN [dbo].[Files] f ON ff.nFileUID = f.nFileUID WHERE ff.nFacilityFileUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_FacilityUserLinkAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_FacilityUserLinkAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_FacilityUserLinkAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_FacilityUserLinkAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_FacilityUserLinkAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_FacilityUserLinkAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(cFacilityName, cFacilityNumber) FROM [dbo].[Facilities] f JOIN [dbo].[FacilityUserLink] ful ON f.nFacilityUID = ful.nFacilityUID WHERE ful.nFacilityUserLinkUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_FilesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_FilesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_FilesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_FilesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_FilesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_FilesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cFileName FROM [dbo].[Files] WHERE nFileUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
	
	IF OBJECT_ID(N'[dbo].[udf_GET_FormatsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_FormatsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_FormatsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_FormatsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_FormatsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_FormatsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN			
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cFormatUI FROM [dbo].[Formats] WHERE nFormatUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END	
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END	

	IF OBJECT_ID(N'[dbo].[udf_GET_ImportsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_ImportsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_ImportsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ImportsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_ImportsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_ImportsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cFileName + '' '' + cDescription FROM [dbo].[Imports] i JOIN [dbo].[ImportSetups] s ON i.nImportSetupUID = s.nImportSetupUID WHERE i.nImportUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_InvoicesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_InvoicesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_InvoicesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_InvoicesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_InvoicesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_InvoicesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cInvoiceNo FROM [dbo].[Invoices] WHERE nInvoiceUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_JobNumbersAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_JobNumbersAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_JobNumbersAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_JobNumbersAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_JobNumbersAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_JobNumbersAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cJobOrderNumber FROM [dbo].[JobNumbers] WHERE nJobNumberUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_LaborAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_LaborAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_LaborAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_LaborAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_LaborAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_LaborAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(cLaborAccount, '''') + '' '' + CONVERT(NVARCHAR, nDuration) + ''h'' FROM [dbo].[Labor] WHERE nLaborUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ManualTemplateRowsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_ManualTemplateRowsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_ManualTemplateRowsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ManualTemplateRowsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_ManualTemplateRowsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_ManualTemplateRowsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT CONVERT(NVARCHAR, nOrdinal) + '' '' + COALESCE(cDescription, cNominal) FROM [dbo].[ManualTemplateRows] WHERE nManualTemplateRowUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ManualTemplatesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_ManualTemplatesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_ManualTemplatesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ManualTemplatesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_ManualTemplatesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_ManualTemplatesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cTemplateName FROM [dbo].[ManualTemplates] WHERE nManualTemplateUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_PartsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_PartsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_PartsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_PartsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_PartsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_PartsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cPartNumber + '' '' + COALESCE(cDescription, '''') FROM [dbo].[Parts] WHERE nPartUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ProblemReportsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_ProblemReportsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_ProblemReportsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ProblemReportsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_ProblemReportsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_ProblemReportsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cProblemNumber FROM [dbo].[ProblemReports] WHERE nProblemReportsUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ProceduresAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_ProceduresAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_ProceduresAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ProceduresAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_ProceduresAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_ProceduresAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cProcedureName FROM [dbo].[Procedures] WHERE nProcedureUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_PromptColumnsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_PromptColumnsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_PromptColumnsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_PromptColumnsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_PromptColumnsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_PromptColumnsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cTableName + ''.'' + cColumnName FROM [dbo].[PromptTables] pt JOIN [dbo].[PromptColumns] pc ON pt.nPromptTableUID = pc.nPromptTableUID WHERE pc.nPromptColumnUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_PromptTypesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_PromptTypesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_PromptTypesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_PromptTypesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_PromptTypesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_PromptTypesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cPromptTypeDisplay FROM [dbo].[PromptTypes] WHERE nPromptTypeUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_SecurityGroupFieldLinksAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_SecurityGroupFieldLinksAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_SecurityGroupFieldLinksAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_SecurityGroupFieldLinksAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_SecurityGroupFieldLinksAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_SecurityGroupFieldLinksAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(cGroupName, '''') + ''|'' + COALESCE(cModel, '''') + ''.'' + COALESCE(cField, '''') + ''::'' + COALESCE(cProperty, '''') FROM [dbo].[SecurityGroupFieldLinks] sgfl JOIN [dbo].[SecurityGroups] sg ON sgfl.nSecurityGroupUID = sg.nSecurityGroupUID JOIN [dbo].[UCIData] u ON sgfl.nUCIDataUID = u.nUCIDataUID WHERE sgfl.nSecurityGroupFieldLinkUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_SecurityGroupsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_SecurityGroupsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_SecurityGroupsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_SecurityGroupsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_SecurityGroupsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_SecurityGroupsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(cGroupName, '''') FROM [dbo].[SecurityGroups] WHERE nSecurityGroupUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END
	
	IF OBJECT_ID(N'[dbo].[udf_GET_ServiceTypesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_ServiceTypesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_ServiceTypesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ServiceTypesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_ServiceTypesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_ServiceTypesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cServiceName + '' '' + cServiceType FROM [dbo].[ServiceTypes] WHERE nServiceTypeUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ShipmentsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_ShipmentsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_ShipmentsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ShipmentsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_ShipmentsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_ShipmentsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(cShipmentName + '' '' + cRequisitionNumber, '''') FROM [dbo].[Shipments] WHERE nShipmentUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_SubCategoryAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_SubCategoryAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_SubCategoryAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_SubCategoryAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_SubCategoryAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_SubCategoryAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(cDescription, '''') FROM [dbo].[SubCategory] WHERE nSubCategoryUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ToolAssignmentsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_ToolAssignmentsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_ToolAssignmentsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ToolAssignmentsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_ToolAssignmentsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_ToolAssignmentsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cAssignmentNumber FROM [dbo].[ToolAssignments] WHERE nToolAssignmentUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_TypePartsLinkAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_TypePartsLinkAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_TypePartsLinkAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_TypePartsLinkAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_TypePartsLinkAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_TypePartsLinkAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(m.cFacilityName, m.cFacilityNumber) + '' '' + COALESCE(t.cModelNumber, '''') + '' '' + COALESCE(t.cDescription, '''') + '' '' + COALESCE(p.cPartNumber, '''') + '' '' + COALESCE(p.cDescription, '''') FROM [dbo].[TypePartsLink] tpl JOIN [dbo].[Types] t ON tpl.nTypeUID = t.nTypeUID JOIN [dbo].[Facilities] m ON t.nManufacturerUID = m.nFacilityUID JOIN [dbo].[Parts] p ON tpl.nPartUID = p.nPartUID WHERE tpl.nTypePartLinkUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_TypeProcedureDefaultsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_TypeProcedureDefaultsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_TypeProcedureDefaultsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_TypeProcedureDefaultsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_TypeProcedureDefaultsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_TypeProcedureDefaultsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(m.cFacilityName, m.cFacilityNumber) + '' '' + COALESCE(t.cModelNumber, '''') + '' '' + COALESCE(t.cDescription, '''') + '' '' + COALESCE(p.cProcedureName, '''') FROM [dbo].[TypeProcedureDefaults] tpd JOIN [dbo].[Types] t ON tpd.nTypeUID = t.nTypeUID JOIN [dbo].[Facilities] m ON t.nManufacturerUID = m.nFacilityUID JOIN [dbo].[Procedures] p ON tpd.nProcedureUID = p.nProcedureUID WHERE tpd.nTypeProcedureDefaultUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_TypesAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_TypesAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_TypesAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_TypesAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_TypesAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_TypesAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(m.cFacilityName, m.cFacilityNumber) + '' '' + COALESCE(t.cModelNumber, '''') + '' '' + COALESCE(t.cDescription, '''') FROM [dbo].[Types] t JOIN [dbo].[Facilities] m ON t.nManufacturerUID = m.nFacilityUID WHERE t.nTypeUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_UCIDataAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_UCIDataAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_UCIDataAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_UCIDataAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_UCIDataAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_UCIDataAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
 			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(cModel, '''') + ''.'' + COALESCE(cField, '''') + ''::'' + COALESCE(cProperty, '''') FROM [dbo].[UCIData] WHERE nUCIDataUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_UnitsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_UnitsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_UnitsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_UnitsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_UnitsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_UnitsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cUnitSymbol FROM [dbo].[Units] WHERE nUnitUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_UsersAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_UsersAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_UsersAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_UsersAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_UsersAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_UsersAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
 			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT COALESCE(cFirstName, '''') + '' '' + COALESCE(cLastName, '''') FROM [dbo].[Users] WHERE nUserUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ValidationsAuditDisplay]', 'FN') IS NOT NULL
	BEGIN
		PRINT N'Dropping [dbo].[udf_GET_ValidationsAuditDisplay]'
		
		DROP FUNCTION [dbo].[udf_GET_ValidationsAuditDisplay]

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END

	IF OBJECT_ID(N'[dbo].[udf_GET_ValidationsAuditDisplay]', 'FN') IS NULL
	BEGIN
		PRINT N'Creating [dbo].[udf_GET_ValidationsAuditDisplay]'

EXEC sp_executesql N'		CREATE FUNCTION [dbo].[udf_GET_ValidationsAuditDisplay]
		(
		    @nRecordUID [uniqueidentifier]
		)
		RETURNS NVARCHAR(1000)

		AS
		BEGIN
			DECLARE @ret AS NVARCHAR(1000);
			SET @ret = COALESCE((SELECT cFunctionName FROM [dbo].[Validations] WHERE nValidationUID = @nRecordUID), CONVERT(NVARCHAR(36), @nRecordUID));
			RETURN @ret;
		END
'

	    IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

	    IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

	END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertParameterSheet_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_AlertParameterSheet_Ins] from [dbo].[AlertParameterSheet]'

    	DROP TRIGGER [dbo].[tr_kr_audit_AlertParameterSheet_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertParameterSheet_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_AlertParameterSheet_Ins] on [dbo].[AlertParameterSheet]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_AlertParameterSheet_Ins] ON [dbo].[AlertParameterSheet] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), [nAlertParameterSheetUID]),
            312,
            0,
            CONVERT( NVARCHAR(max), [cDescription] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), [nAlertParameterSheetUID]),
            313,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), [nAlertParameterSheetUID]),
            314,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), [nAlertParameterSheetUID]),
            315,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), [nAlertParameterSheetUID]),
            316,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), [nAlertParameterSheetUID]),
            317,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), [nAlertParameterSheetUID]),
            318,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), [nAlertParameterSheetUID]),
            319,
            0,
            CONVERT(NVARCHAR( 36 ), [nAlertParameterSheetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), [nAlertParameterSheetUID]),
            322,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 11, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nAlertParameterSheetUID FROM Inserted
        SELECT @Value = dbo.udf_GET_AlertParameterSheetAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_AlertParameterSheet_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertParameterSheet_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_AlertParameterSheet_Upd] from [dbo].[AlertParameterSheet]'

    	DROP TRIGGER [dbo].[tr_kr_audit_AlertParameterSheet_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertParameterSheet_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_AlertParameterSheet_Upd] on [dbo].[AlertParameterSheet]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_AlertParameterSheet_Upd] ON [dbo].[AlertParameterSheet] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nAlertParameterSheetUID] = i.[nAlertParameterSheetUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cDescription] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertParameterSheetUID], d.[nAlertParameterSheetUID] )),
                312,
                0,
                CONVERT( NVARCHAR(max), d.[cDescription] ),
                CONVERT( NVARCHAR(max), i.[cDescription] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertParameterSheetUID] = i.[nAlertParameterSheetUID] )
            WHERE
                ( d.[cDescription] <> i.[cDescription] ) OR
                ( d.[cDescription] IS NULL AND i.[cDescription] IS NOT NULL ) OR
                ( i.[cDescription] IS NULL AND d.[cDescription] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertParameterSheetUID], d.[nAlertParameterSheetUID] )),
                313,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertParameterSheetUID] = i.[nAlertParameterSheetUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertParameterSheetUID], d.[nAlertParameterSheetUID] )),
                314,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertParameterSheetUID] = i.[nAlertParameterSheetUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertParameterSheetUID], d.[nAlertParameterSheetUID] )),
                315,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertParameterSheetUID] = i.[nAlertParameterSheetUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertParameterSheetUID], d.[nAlertParameterSheetUID] )),
                316,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertParameterSheetUID] = i.[nAlertParameterSheetUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertParameterSheetUID], d.[nAlertParameterSheetUID] )),
                317,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertParameterSheetUID] = i.[nAlertParameterSheetUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertParameterSheetUID], d.[nAlertParameterSheetUID] )),
                318,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertParameterSheetUID] = i.[nAlertParameterSheetUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAlertParameterSheetUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertParameterSheetUID], d.[nAlertParameterSheetUID] )),
                319,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAlertParameterSheetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAlertParameterSheetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertParameterSheetUID] = i.[nAlertParameterSheetUID] )
            WHERE
                ( d.[nAlertParameterSheetUID] <> i.[nAlertParameterSheetUID] ) OR
                ( d.[nAlertParameterSheetUID] IS NULL AND i.[nAlertParameterSheetUID] IS NOT NULL ) OR
                ( i.[nAlertParameterSheetUID] IS NULL AND d.[nAlertParameterSheetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertParameterSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertParameterSheetUID], d.[nAlertParameterSheetUID] )),
                322,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertParameterSheetUID] = i.[nAlertParameterSheetUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 11, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nAlertParameterSheetUID FROM Inserted
            SELECT @Value = dbo.udf_GET_AlertParameterSheetAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_AlertParameterSheet_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertRecipients_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_AlertRecipients_Ins] from [dbo].[AlertRecipients]'

    	DROP TRIGGER [dbo].[tr_kr_audit_AlertRecipients_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertRecipients_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_AlertRecipients_Ins] on [dbo].[AlertRecipients]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_AlertRecipients_Ins] ON [dbo].[AlertRecipients] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            326,
            0,
            CONVERT( NVARCHAR(max), [cEmailType] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            327,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            328,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            329,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            330,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            331,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            332,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            333,
            0,
            CONVERT(NVARCHAR( 36 ), [nAlertRecipientUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            334,
            0,
            CONVERT(NVARCHAR( 36 ), [nAlertUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            335,
            0,
            CONVERT(NVARCHAR( 36 ), [nContactUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), [nAlertRecipientUID]),
            338,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 12, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nAlertRecipientUID FROM Inserted
        SELECT @Value = dbo.udf_GET_AlertRecipientsAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_AlertRecipients_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertRecipients_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_AlertRecipients_Upd] from [dbo].[AlertRecipients]'

    	DROP TRIGGER [dbo].[tr_kr_audit_AlertRecipients_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AlertRecipients_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_AlertRecipients_Upd] on [dbo].[AlertRecipients]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_AlertRecipients_Upd] ON [dbo].[AlertRecipients] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cEmailType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                326,
                0,
                CONVERT( NVARCHAR(max), d.[cEmailType] ),
                CONVERT( NVARCHAR(max), i.[cEmailType] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[cEmailType] <> i.[cEmailType] ) OR
                ( d.[cEmailType] IS NULL AND i.[cEmailType] IS NOT NULL ) OR
                ( i.[cEmailType] IS NULL AND d.[cEmailType] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                327,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                328,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                329,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                330,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                331,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                332,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAlertRecipientUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                333,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAlertRecipientUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAlertRecipientUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[nAlertRecipientUID] <> i.[nAlertRecipientUID] ) OR
                ( d.[nAlertRecipientUID] IS NULL AND i.[nAlertRecipientUID] IS NOT NULL ) OR
                ( i.[nAlertRecipientUID] IS NULL AND d.[nAlertRecipientUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nAlertUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                334,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAlertUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAlertUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[nAlertUID] <> i.[nAlertUID] ) OR
                ( d.[nAlertUID] IS NULL AND i.[nAlertUID] IS NOT NULL ) OR
                ( i.[nAlertUID] IS NULL AND d.[nAlertUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nContactUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                335,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nContactUID]),
                CONVERT(NVARCHAR( 36 ), i.[nContactUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[nContactUID] <> i.[nContactUID] ) OR
                ( d.[nContactUID] IS NULL AND i.[nContactUID] IS NOT NULL ) OR
                ( i.[nContactUID] IS NULL AND d.[nContactUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertRecipientUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertRecipientUID], d.[nAlertRecipientUID] )),
                338,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertRecipientUID] = i.[nAlertRecipientUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 12, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nAlertRecipientUID FROM Inserted
            SELECT @Value = dbo.udf_GET_AlertRecipientsAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_AlertRecipients_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Alerts_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Alerts_Ins] from [dbo].[Alerts]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Alerts_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Alerts_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Alerts_Ins] on [dbo].[Alerts]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Alerts_Ins] ON [dbo].[Alerts] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            342,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAlertDescription], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            343,
            0,
            CONVERT( NVARCHAR(max), [cAlertName] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            344,
            0,
            CONVERT( NVARCHAR(max), [cAlertType] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            345,
            0,
            CONVERT( NVARCHAR(max), [cEmailBody] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            346,
            0,
            CONVERT( NVARCHAR(max), [cEmailSubject] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            347,
            0,
            CONVERT( NVARCHAR(max), [cReportName] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            348,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cSQLQuery], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            349,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            350,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            351,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            352,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            353,
            0,
            CONVERT(NVARCHAR, [lSkipIfEmpty])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            354,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            355,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            356,
            0,
            CONVERT(NVARCHAR( 36 ), [nAlertParameterSheetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            357,
            0,
            CONVERT(NVARCHAR( 36 ), [nAlertUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            358,
            0,
            CONVERT(NVARCHAR( 36 ), [nDataCheckUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAlertUID='' + CONVERT(VARCHAR( 36 ), [nAlertUID]),
            361,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 13, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nAlertUID FROM Inserted
        SELECT @Value = dbo.udf_GET_AlertsAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Alerts_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Alerts_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Alerts_Upd] from [dbo].[Alerts]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Alerts_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Alerts_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Alerts_Upd] on [dbo].[Alerts]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Alerts_Upd] ON [dbo].[Alerts] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cAlertDescription] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                342,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAlertDescription], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAlertDescription], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( NULLIF(d.[cAlertDescription], '''') <> NULLIF(i.[cAlertDescription], '''') ) OR
                ( NULLIF(d.[cAlertDescription], '''') IS NULL AND NULLIF(i.[cAlertDescription], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAlertDescription], '''') IS NULL AND NULLIF(d.[cAlertDescription], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cAlertName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                343,
                0,
                CONVERT( NVARCHAR(max), d.[cAlertName] ),
                CONVERT( NVARCHAR(max), i.[cAlertName] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[cAlertName] <> i.[cAlertName] ) OR
                ( d.[cAlertName] IS NULL AND i.[cAlertName] IS NOT NULL ) OR
                ( i.[cAlertName] IS NULL AND d.[cAlertName] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cAlertType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                344,
                0,
                CONVERT( NVARCHAR(max), d.[cAlertType] ),
                CONVERT( NVARCHAR(max), i.[cAlertType] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[cAlertType] <> i.[cAlertType] ) OR
                ( d.[cAlertType] IS NULL AND i.[cAlertType] IS NOT NULL ) OR
                ( i.[cAlertType] IS NULL AND d.[cAlertType] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cEmailBody] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                345,
                0,
                CONVERT( NVARCHAR(max), d.[cEmailBody] ),
                CONVERT( NVARCHAR(max), i.[cEmailBody] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[cEmailBody] <> i.[cEmailBody] ) OR
                ( d.[cEmailBody] IS NULL AND i.[cEmailBody] IS NOT NULL ) OR
                ( i.[cEmailBody] IS NULL AND d.[cEmailBody] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cEmailSubject] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                346,
                0,
                CONVERT( NVARCHAR(max), d.[cEmailSubject] ),
                CONVERT( NVARCHAR(max), i.[cEmailSubject] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[cEmailSubject] <> i.[cEmailSubject] ) OR
                ( d.[cEmailSubject] IS NULL AND i.[cEmailSubject] IS NOT NULL ) OR
                ( i.[cEmailSubject] IS NULL AND d.[cEmailSubject] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cReportName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                347,
                0,
                CONVERT( NVARCHAR(max), d.[cReportName] ),
                CONVERT( NVARCHAR(max), i.[cReportName] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[cReportName] <> i.[cReportName] ) OR
                ( d.[cReportName] IS NULL AND i.[cReportName] IS NOT NULL ) OR
                ( i.[cReportName] IS NULL AND d.[cReportName] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cSQLQuery] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                348,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cSQLQuery], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cSQLQuery], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( NULLIF(d.[cSQLQuery], '''') <> NULLIF(i.[cSQLQuery], '''') ) OR
                ( NULLIF(d.[cSQLQuery], '''') IS NULL AND NULLIF(i.[cSQLQuery], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cSQLQuery], '''') IS NULL AND NULLIF(d.[cSQLQuery], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                349,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                350,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                351,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                352,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lSkipIfEmpty] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                353,
                0,
                CONVERT(NVARCHAR, d.[lSkipIfEmpty]),
                CONVERT(NVARCHAR, i.[lSkipIfEmpty])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[lSkipIfEmpty] <> i.[lSkipIfEmpty] ) OR
                ( d.[lSkipIfEmpty] IS NULL AND i.[lSkipIfEmpty] IS NOT NULL ) OR
                ( i.[lSkipIfEmpty] IS NULL AND d.[lSkipIfEmpty] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                354,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                355,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAlertParameterSheetUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                356,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAlertParameterSheetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAlertParameterSheetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[nAlertParameterSheetUID] <> i.[nAlertParameterSheetUID] ) OR
                ( d.[nAlertParameterSheetUID] IS NULL AND i.[nAlertParameterSheetUID] IS NOT NULL ) OR
                ( i.[nAlertParameterSheetUID] IS NULL AND d.[nAlertParameterSheetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAlertUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                357,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAlertUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAlertUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[nAlertUID] <> i.[nAlertUID] ) OR
                ( d.[nAlertUID] IS NULL AND i.[nAlertUID] IS NOT NULL ) OR
                ( i.[nAlertUID] IS NULL AND d.[nAlertUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nDataCheckUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                358,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nDataCheckUID]),
                CONVERT(NVARCHAR( 36 ), i.[nDataCheckUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[nDataCheckUID] <> i.[nDataCheckUID] ) OR
                ( d.[nDataCheckUID] IS NULL AND i.[nDataCheckUID] IS NOT NULL ) OR
                ( i.[nDataCheckUID] IS NULL AND d.[nDataCheckUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAlertUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAlertUID], d.[nAlertUID] )),
                361,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAlertUID] = i.[nAlertUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 13, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nAlertUID FROM Inserted
            SELECT @Value = dbo.udf_GET_AlertsAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Alerts_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AssetFiles_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_AssetFiles_Ins] from [dbo].[AssetFiles]'

    	DROP TRIGGER [dbo].[tr_kr_audit_AssetFiles_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AssetFiles_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_AssetFiles_Ins] on [dbo].[AssetFiles]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_AssetFiles_Ins] ON [dbo].[AssetFiles] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            2993,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            2994,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            2995,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            2996,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            2997,
            0,
            CONVERT(NVARCHAR, [lPrivate])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            2998,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            2999,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            3000,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssetFileUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            3001,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            3002,
            0,
            CONVERT(NVARCHAR( 36 ), [nFileUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), [nAssetFileUID]),
            3006,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 82, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nAssetFileUID FROM Inserted
        SELECT @Value = dbo.udf_GET_AssetFilesAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_AssetFiles_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AssetFiles_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_AssetFiles_Upd] from [dbo].[AssetFiles]'

    	DROP TRIGGER [dbo].[tr_kr_audit_AssetFiles_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_AssetFiles_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_AssetFiles_Upd] on [dbo].[AssetFiles]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_AssetFiles_Upd] ON [dbo].[AssetFiles] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )

        -- Populate audit detail records...
        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                2993,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                2994,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                2995,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                2996,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lPrivate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                2997,
                0,
                CONVERT(NVARCHAR, d.[lPrivate]),
                CONVERT(NVARCHAR, i.[lPrivate])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[lPrivate] <> i.[lPrivate] ) OR
                ( d.[lPrivate] IS NULL AND i.[lPrivate] IS NOT NULL ) OR
                ( i.[lPrivate] IS NULL AND d.[lPrivate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                2998,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                2999,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAssetFileUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                3000,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAssetFileUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAssetFileUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[nAssetFileUID] <> i.[nAssetFileUID] ) OR
                ( d.[nAssetFileUID] IS NULL AND i.[nAssetFileUID] IS NOT NULL ) OR
                ( i.[nAssetFileUID] IS NULL AND d.[nAssetFileUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nAssetUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                3001,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAssetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAssetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[nAssetUID] <> i.[nAssetUID] ) OR
                ( d.[nAssetUID] IS NULL AND i.[nAssetUID] IS NOT NULL ) OR
                ( i.[nAssetUID] IS NULL AND d.[nAssetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFileUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                3002,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFileUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFileUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[nFileUID] <> i.[nFileUID] ) OR
                ( d.[nFileUID] IS NULL AND i.[nFileUID] IS NOT NULL ) OR
                ( i.[nFileUID] IS NULL AND d.[nFileUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetFileUID], d.[nAssetFileUID] )),
                3006,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetFileUID] = i.[nAssetFileUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 82, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nAssetFileUID FROM Inserted
            SELECT @Value = dbo.udf_GET_AssetFilesAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_AssetFiles_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Assets_Ins] from [dbo].[Assets]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Assets_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Assets_Ins] on [dbo].[Assets]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Assets_Ins] ON [dbo].[Assets] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3076,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAssignedContact], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAssignedGroup], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            4,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cBarcode], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            5,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cClass], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            6,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDescription], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            7,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDimension], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            8,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDisposition], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            9,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFamily], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            10,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cGroup], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            11,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cID], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            14,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cModelNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3077,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cOptional1], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            16,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPartNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            17,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPhysicalLocation], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            18,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cSerialNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            19,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStandardType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            20,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStatus], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            21,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStockNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            22,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cWeight], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            23,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cWeightUOM], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            24,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            25,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            26,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            27,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            28,
            0,
            CONVERT(NVARCHAR, [lInAbeyance])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            29,
            0,
            CONVERT(NVARCHAR, [lNonTracked])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            30,
            0,
            CONVERT(NVARCHAR, [lOnSite])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            3078,
            0,
            CONVERT(NVARCHAR, [lOptional])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            31,
            0,
            CONVERT(NVARCHAR, [lRecallMaintenanceType])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            32,
            0,
            CONVERT(NVARCHAR, [lStandard])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            33,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mAccuracy], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            34,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            35,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mUncertaintyNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            36,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mWarrantyInfo], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            37,
            0,
            CONVERT(NVARCHAR, [nAbeyanceInterval])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            38,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            39,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            40,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            41,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssignedFacUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            42,
            0,
            CONVERT(NVARCHAR( 36 ), [nAuthorizedFacUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            43,
            0,
            CONVERT(NVARCHAR( 36 ), [nCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            44,
            0,
            CONVERT(NVARCHAR( 36 ), [nDepartmentUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            45,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            46,
            0,
            CONVERT(NVARCHAR( 36 ), [nInventoryByUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            47,
            0,
            CONVERT( NVARCHAR( 41 ), [nItemCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            48,
            0,
            CONVERT(NVARCHAR( 36 ), [nMaintenanceFacUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            49,
            0,
            CONVERT(NVARCHAR( 36 ), [nManufacturerUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            50,
            0,
            CONVERT(NVARCHAR( 36 ), [nParentUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            51,
            0,
            CONVERT(NVARCHAR, [nQuantity])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            52,
            0,
            CONVERT( NVARCHAR( 41 ), [nReplacementCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            53,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            54,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            57,
            0,
            CONVERT(NVARCHAR, [nUseCount])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            58,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            59,
            0,
            CONVERT( NVARCHAR( 34 ), [tAssignedGroupDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            60,
            0,
            CONVERT( NVARCHAR( 34 ), [tInServiceDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            61,
            0,
            CONVERT( NVARCHAR( 34 ), [tInventoryDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            64,
            0,
            CONVERT( NVARCHAR( 34 ), [tPurchaseDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            65,
            0,
            CONVERT( NVARCHAR( 34 ), [tStatusDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nAssetUID='' + CONVERT(VARCHAR( 36 ), [nAssetUID]),
            68,
            0,
            CONVERT( NVARCHAR( 34 ), [tWarrantyDate], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 3, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nAssetUID FROM Inserted
        SELECT @Value = dbo.udf_GET_AssetsAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Assets_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Assets_Upd] from [dbo].[Assets]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Assets_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Assets_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Assets_Upd] on [dbo].[Assets]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Assets_Upd] ON [dbo].[Assets] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cAssignedContact] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                3076,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAssignedContact], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAssignedContact], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cAssignedContact], '''') <> NULLIF(i.[cAssignedContact], '''') ) OR
                ( NULLIF(d.[cAssignedContact], '''') IS NULL AND NULLIF(i.[cAssignedContact], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAssignedContact], '''') IS NULL AND NULLIF(d.[cAssignedContact], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cAssignedGroup] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                3,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAssignedGroup], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAssignedGroup], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cAssignedGroup], '''') <> NULLIF(i.[cAssignedGroup], '''') ) OR
                ( NULLIF(d.[cAssignedGroup], '''') IS NULL AND NULLIF(i.[cAssignedGroup], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAssignedGroup], '''') IS NULL AND NULLIF(d.[cAssignedGroup], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cBarcode] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                4,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cBarcode], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cBarcode], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cBarcode], '''') <> NULLIF(i.[cBarcode], '''') ) OR
                ( NULLIF(d.[cBarcode], '''') IS NULL AND NULLIF(i.[cBarcode], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cBarcode], '''') IS NULL AND NULLIF(d.[cBarcode], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cClass] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                5,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cClass], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cClass], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cClass], '''') <> NULLIF(i.[cClass], '''') ) OR
                ( NULLIF(d.[cClass], '''') IS NULL AND NULLIF(i.[cClass], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cClass], '''') IS NULL AND NULLIF(d.[cClass], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cDescription] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                6,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cDescription], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cDescription], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cDescription], '''') <> NULLIF(i.[cDescription], '''') ) OR
                ( NULLIF(d.[cDescription], '''') IS NULL AND NULLIF(i.[cDescription], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cDescription], '''') IS NULL AND NULLIF(d.[cDescription], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cDimension] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                7,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cDimension], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cDimension], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cDimension], '''') <> NULLIF(i.[cDimension], '''') ) OR
                ( NULLIF(d.[cDimension], '''') IS NULL AND NULLIF(i.[cDimension], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cDimension], '''') IS NULL AND NULLIF(d.[cDimension], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cDisposition] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                8,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cDisposition], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cDisposition], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cDisposition], '''') <> NULLIF(i.[cDisposition], '''') ) OR
                ( NULLIF(d.[cDisposition], '''') IS NULL AND NULLIF(i.[cDisposition], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cDisposition], '''') IS NULL AND NULLIF(d.[cDisposition], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFamily] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                9,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFamily], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFamily], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cFamily], '''') <> NULLIF(i.[cFamily], '''') ) OR
                ( NULLIF(d.[cFamily], '''') IS NULL AND NULLIF(i.[cFamily], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFamily], '''') IS NULL AND NULLIF(d.[cFamily], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cGroup] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                10,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cGroup], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cGroup], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cGroup], '''') <> NULLIF(i.[cGroup], '''') ) OR
                ( NULLIF(d.[cGroup], '''') IS NULL AND NULLIF(i.[cGroup], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cGroup], '''') IS NULL AND NULLIF(d.[cGroup], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                11,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cID], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cID], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cID], '''') <> NULLIF(i.[cID], '''') ) OR
                ( NULLIF(d.[cID], '''') IS NULL AND NULLIF(i.[cID], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cID], '''') IS NULL AND NULLIF(d.[cID], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cModelNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                14,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cModelNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cModelNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cModelNumber], '''') <> NULLIF(i.[cModelNumber], '''') ) OR
                ( NULLIF(d.[cModelNumber], '''') IS NULL AND NULLIF(i.[cModelNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cModelNumber], '''') IS NULL AND NULLIF(d.[cModelNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cOptional1] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                3077,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cOptional1], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cOptional1], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cOptional1], '''') <> NULLIF(i.[cOptional1], '''') ) OR
                ( NULLIF(d.[cOptional1], '''') IS NULL AND NULLIF(i.[cOptional1], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cOptional1], '''') IS NULL AND NULLIF(d.[cOptional1], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cPartNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                16,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cPartNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cPartNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cPartNumber], '''') <> NULLIF(i.[cPartNumber], '''') ) OR
                ( NULLIF(d.[cPartNumber], '''') IS NULL AND NULLIF(i.[cPartNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cPartNumber], '''') IS NULL AND NULLIF(d.[cPartNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cPhysicalLocation] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                17,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cPhysicalLocation], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cPhysicalLocation], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cPhysicalLocation], '''') <> NULLIF(i.[cPhysicalLocation], '''') ) OR
                ( NULLIF(d.[cPhysicalLocation], '''') IS NULL AND NULLIF(i.[cPhysicalLocation], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cPhysicalLocation], '''') IS NULL AND NULLIF(d.[cPhysicalLocation], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cSerialNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                18,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cSerialNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cSerialNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cSerialNumber], '''') <> NULLIF(i.[cSerialNumber], '''') ) OR
                ( NULLIF(d.[cSerialNumber], '''') IS NULL AND NULLIF(i.[cSerialNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cSerialNumber], '''') IS NULL AND NULLIF(d.[cSerialNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cStandardType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                19,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cStandardType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cStandardType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cStandardType], '''') <> NULLIF(i.[cStandardType], '''') ) OR
                ( NULLIF(d.[cStandardType], '''') IS NULL AND NULLIF(i.[cStandardType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cStandardType], '''') IS NULL AND NULLIF(d.[cStandardType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cStatus] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                20,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cStatus], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cStatus], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cStatus], '''') <> NULLIF(i.[cStatus], '''') ) OR
                ( NULLIF(d.[cStatus], '''') IS NULL AND NULLIF(i.[cStatus], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cStatus], '''') IS NULL AND NULLIF(d.[cStatus], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cStockNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                21,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cStockNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cStockNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cStockNumber], '''') <> NULLIF(i.[cStockNumber], '''') ) OR
                ( NULLIF(d.[cStockNumber], '''') IS NULL AND NULLIF(i.[cStockNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cStockNumber], '''') IS NULL AND NULLIF(d.[cStockNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cWeight] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                22,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cWeight], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cWeight], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cWeight], '''') <> NULLIF(i.[cWeight], '''') ) OR
                ( NULLIF(d.[cWeight], '''') IS NULL AND NULLIF(i.[cWeight], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cWeight], '''') IS NULL AND NULLIF(d.[cWeight], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cWeightUOM] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                23,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cWeightUOM], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cWeightUOM], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[cWeightUOM], '''') <> NULLIF(i.[cWeightUOM], '''') ) OR
                ( NULLIF(d.[cWeightUOM], '''') IS NULL AND NULLIF(i.[cWeightUOM], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cWeightUOM], '''') IS NULL AND NULLIF(d.[cWeightUOM], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                24,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                25,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                26,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                27,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lInAbeyance] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                28,
                0,
                CONVERT(NVARCHAR, d.[lInAbeyance]),
                CONVERT(NVARCHAR, i.[lInAbeyance])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lInAbeyance] <> i.[lInAbeyance] ) OR
                ( d.[lInAbeyance] IS NULL AND i.[lInAbeyance] IS NOT NULL ) OR
                ( i.[lInAbeyance] IS NULL AND d.[lInAbeyance] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lNonTracked] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                29,
                0,
                CONVERT(NVARCHAR, d.[lNonTracked]),
                CONVERT(NVARCHAR, i.[lNonTracked])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lNonTracked] <> i.[lNonTracked] ) OR
                ( d.[lNonTracked] IS NULL AND i.[lNonTracked] IS NOT NULL ) OR
                ( i.[lNonTracked] IS NULL AND d.[lNonTracked] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOnSite] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                30,
                0,
                CONVERT(NVARCHAR, d.[lOnSite]),
                CONVERT(NVARCHAR, i.[lOnSite])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lOnSite] <> i.[lOnSite] ) OR
                ( d.[lOnSite] IS NULL AND i.[lOnSite] IS NOT NULL ) OR
                ( i.[lOnSite] IS NULL AND d.[lOnSite] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOptional] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                3078,
                0,
                CONVERT(NVARCHAR, d.[lOptional]),
                CONVERT(NVARCHAR, i.[lOptional])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lOptional] <> i.[lOptional] ) OR
                ( d.[lOptional] IS NULL AND i.[lOptional] IS NOT NULL ) OR
                ( i.[lOptional] IS NULL AND d.[lOptional] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lRecallMaintenanceType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                31,
                0,
                CONVERT(NVARCHAR, d.[lRecallMaintenanceType]),
                CONVERT(NVARCHAR, i.[lRecallMaintenanceType])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lRecallMaintenanceType] <> i.[lRecallMaintenanceType] ) OR
                ( d.[lRecallMaintenanceType] IS NULL AND i.[lRecallMaintenanceType] IS NOT NULL ) OR
                ( i.[lRecallMaintenanceType] IS NULL AND d.[lRecallMaintenanceType] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lStandard] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                32,
                0,
                CONVERT(NVARCHAR, d.[lStandard]),
                CONVERT(NVARCHAR, i.[lStandard])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[lStandard] <> i.[lStandard] ) OR
                ( d.[lStandard] IS NULL AND i.[lStandard] IS NOT NULL ) OR
                ( i.[lStandard] IS NULL AND d.[lStandard] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mAccuracy] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                33,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mAccuracy], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mAccuracy], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[mAccuracy], '''') <> NULLIF(i.[mAccuracy], '''') ) OR
                ( NULLIF(d.[mAccuracy], '''') IS NULL AND NULLIF(i.[mAccuracy], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mAccuracy], '''') IS NULL AND NULLIF(d.[mAccuracy], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                34,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mUncertaintyNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                35,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mUncertaintyNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mUncertaintyNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[mUncertaintyNotes], '''') <> NULLIF(i.[mUncertaintyNotes], '''') ) OR
                ( NULLIF(d.[mUncertaintyNotes], '''') IS NULL AND NULLIF(i.[mUncertaintyNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mUncertaintyNotes], '''') IS NULL AND NULLIF(d.[mUncertaintyNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mWarrantyInfo] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                36,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mWarrantyInfo], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mWarrantyInfo], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( NULLIF(d.[mWarrantyInfo], '''') <> NULLIF(i.[mWarrantyInfo], '''') ) OR
                ( NULLIF(d.[mWarrantyInfo], '''') IS NULL AND NULLIF(i.[mWarrantyInfo], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mWarrantyInfo], '''') IS NULL AND NULLIF(d.[mWarrantyInfo], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAbeyanceInterval] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                37,
                0,
                CONVERT(NVARCHAR, d.[nAbeyanceInterval]),
                CONVERT(NVARCHAR, i.[nAbeyanceInterval])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAbeyanceInterval] <> i.[nAbeyanceInterval] ) OR
                ( d.[nAbeyanceInterval] IS NULL AND i.[nAbeyanceInterval] IS NOT NULL ) OR
                ( i.[nAbeyanceInterval] IS NULL AND d.[nAbeyanceInterval] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                38,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                39,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAssetUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                40,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAssetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAssetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAssetUID] <> i.[nAssetUID] ) OR
                ( d.[nAssetUID] IS NULL AND i.[nAssetUID] IS NOT NULL ) OR
                ( i.[nAssetUID] IS NULL AND d.[nAssetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nAssignedFacUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                41,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAssignedFacUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAssignedFacUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAssignedFacUID] <> i.[nAssignedFacUID] ) OR
                ( d.[nAssignedFacUID] IS NULL AND i.[nAssignedFacUID] IS NOT NULL ) OR
                ( i.[nAssignedFacUID] IS NULL AND d.[nAssignedFacUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAuthorizedFacUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                42,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAuthorizedFacUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAuthorizedFacUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nAuthorizedFacUID] <> i.[nAuthorizedFacUID] ) OR
                ( d.[nAuthorizedFacUID] IS NULL AND i.[nAuthorizedFacUID] IS NOT NULL ) OR
                ( i.[nAuthorizedFacUID] IS NULL AND d.[nAuthorizedFacUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                43,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nCategoryUID] <> i.[nCategoryUID] ) OR
                ( d.[nCategoryUID] IS NULL AND i.[nCategoryUID] IS NOT NULL ) OR
                ( i.[nCategoryUID] IS NULL AND d.[nCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nDepartmentUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                44,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nDepartmentUID]),
                CONVERT(NVARCHAR( 36 ), i.[nDepartmentUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nDepartmentUID] <> i.[nDepartmentUID] ) OR
                ( d.[nDepartmentUID] IS NULL AND i.[nDepartmentUID] IS NOT NULL ) OR
                ( i.[nDepartmentUID] IS NULL AND d.[nDepartmentUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                45,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nFacilityUID] <> i.[nFacilityUID] ) OR
                ( d.[nFacilityUID] IS NULL AND i.[nFacilityUID] IS NOT NULL ) OR
                ( i.[nFacilityUID] IS NULL AND d.[nFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nInventoryByUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                46,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nInventoryByUID]),
                CONVERT(NVARCHAR( 36 ), i.[nInventoryByUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nInventoryByUID] <> i.[nInventoryByUID] ) OR
                ( d.[nInventoryByUID] IS NULL AND i.[nInventoryByUID] IS NOT NULL ) OR
                ( i.[nInventoryByUID] IS NULL AND d.[nInventoryByUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nItemCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                47,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nItemCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nItemCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nItemCost] <> i.[nItemCost] ) OR
                ( d.[nItemCost] IS NULL AND i.[nItemCost] IS NOT NULL ) OR
                ( i.[nItemCost] IS NULL AND d.[nItemCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nMaintenanceFacUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                48,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nMaintenanceFacUID]),
                CONVERT(NVARCHAR( 36 ), i.[nMaintenanceFacUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nMaintenanceFacUID] <> i.[nMaintenanceFacUID] ) OR
                ( d.[nMaintenanceFacUID] IS NULL AND i.[nMaintenanceFacUID] IS NOT NULL ) OR
                ( i.[nMaintenanceFacUID] IS NULL AND d.[nMaintenanceFacUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nManufacturerUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                49,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nManufacturerUID]),
                CONVERT(NVARCHAR( 36 ), i.[nManufacturerUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nManufacturerUID] <> i.[nManufacturerUID] ) OR
                ( d.[nManufacturerUID] IS NULL AND i.[nManufacturerUID] IS NOT NULL ) OR
                ( i.[nManufacturerUID] IS NULL AND d.[nManufacturerUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nParentUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                50,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nParentUID]),
                CONVERT(NVARCHAR( 36 ), i.[nParentUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nParentUID] <> i.[nParentUID] ) OR
                ( d.[nParentUID] IS NULL AND i.[nParentUID] IS NOT NULL ) OR
                ( i.[nParentUID] IS NULL AND d.[nParentUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nQuantity] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                51,
                0,
                CONVERT(NVARCHAR, d.[nQuantity]),
                CONVERT(NVARCHAR, i.[nQuantity])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nQuantity] <> i.[nQuantity] ) OR
                ( d.[nQuantity] IS NULL AND i.[nQuantity] IS NOT NULL ) OR
                ( i.[nQuantity] IS NULL AND d.[nQuantity] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nReplacementCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                52,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nReplacementCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nReplacementCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nReplacementCost] <> i.[nReplacementCost] ) OR
                ( d.[nReplacementCost] IS NULL AND i.[nReplacementCost] IS NOT NULL ) OR
                ( i.[nReplacementCost] IS NULL AND d.[nReplacementCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                53,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nSubCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nSubCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nSubCategoryUID] <> i.[nSubCategoryUID] ) OR
                ( d.[nSubCategoryUID] IS NULL AND i.[nSubCategoryUID] IS NOT NULL ) OR
                ( i.[nSubCategoryUID] IS NULL AND d.[nSubCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTypeUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                54,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nTypeUID]),
                CONVERT(NVARCHAR( 36 ), i.[nTypeUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nTypeUID] <> i.[nTypeUID] ) OR
                ( d.[nTypeUID] IS NULL AND i.[nTypeUID] IS NOT NULL ) OR
                ( i.[nTypeUID] IS NULL AND d.[nTypeUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nUseCount] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                57,
                0,
                CONVERT(NVARCHAR, d.[nUseCount]),
                CONVERT(NVARCHAR, i.[nUseCount])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[nUseCount] <> i.[nUseCount] ) OR
                ( d.[nUseCount] IS NULL AND i.[nUseCount] IS NOT NULL ) OR
                ( i.[nUseCount] IS NULL AND d.[nUseCount] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                58,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAssignedGroupDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                59,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAssignedGroupDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAssignedGroupDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tAssignedGroupDate] <> i.[tAssignedGroupDate] ) OR
                ( d.[tAssignedGroupDate] IS NULL AND i.[tAssignedGroupDate] IS NOT NULL ) OR
                ( i.[tAssignedGroupDate] IS NULL AND d.[tAssignedGroupDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tInServiceDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                60,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tInServiceDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tInServiceDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tInServiceDate] <> i.[tInServiceDate] ) OR
                ( d.[tInServiceDate] IS NULL AND i.[tInServiceDate] IS NOT NULL ) OR
                ( i.[tInServiceDate] IS NULL AND d.[tInServiceDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tInventoryDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                61,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tInventoryDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tInventoryDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tInventoryDate] <> i.[tInventoryDate] ) OR
                ( d.[tInventoryDate] IS NULL AND i.[tInventoryDate] IS NOT NULL ) OR
                ( i.[tInventoryDate] IS NULL AND d.[tInventoryDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tPurchaseDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                64,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tPurchaseDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tPurchaseDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tPurchaseDate] <> i.[tPurchaseDate] ) OR
                ( d.[tPurchaseDate] IS NULL AND i.[tPurchaseDate] IS NOT NULL ) OR
                ( i.[tPurchaseDate] IS NULL AND d.[tPurchaseDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tStatusDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                65,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tStatusDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tStatusDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tStatusDate] <> i.[tStatusDate] ) OR
                ( d.[tStatusDate] IS NULL AND i.[tStatusDate] IS NOT NULL ) OR
                ( i.[tStatusDate] IS NULL AND d.[tStatusDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tWarrantyDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nAssetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nAssetUID], d.[nAssetUID] )),
                68,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tWarrantyDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tWarrantyDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nAssetUID] = i.[nAssetUID] )
            WHERE
                ( d.[tWarrantyDate] <> i.[tWarrantyDate] ) OR
                ( d.[tWarrantyDate] IS NULL AND i.[tWarrantyDate] IS NOT NULL ) OR
                ( i.[tWarrantyDate] IS NULL AND d.[tWarrantyDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 3, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nAssetUID FROM Inserted
            SELECT @Value = dbo.udf_GET_AssetsAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Assets_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetFiles_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheetFiles_Ins] from [dbo].[CallSheetFiles]'

    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheetFiles_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetFiles_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheetFiles_Ins] on [dbo].[CallSheetFiles]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheetFiles_Ins] ON [dbo].[CallSheetFiles] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            502,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            503,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            504,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            2990,
            0,
            CONVERT(NVARCHAR, [lCert])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            2991,
            0,
            CONVERT(NVARCHAR, [lCertCurrent])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            2992,
            0,
            CONVERT(NVARCHAR, [lCertExport])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            505,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            506,
            0,
            CONVERT(NVARCHAR, [lPrivate])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            507,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            508,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            509,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetFileUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            510,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            511,
            0,
            CONVERT(NVARCHAR( 36 ), [nFileUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetFileUID]),
            514,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 17, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nCallSheetFileUID FROM Inserted
        SELECT @Value = dbo.udf_GET_CallSheetFilesAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheetFiles_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetFiles_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheetFiles_Upd] from [dbo].[CallSheetFiles]'

    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheetFiles_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetFiles_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheetFiles_Upd] on [dbo].[CallSheetFiles]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheetFiles_Upd] ON [dbo].[CallSheetFiles] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )

        -- Populate audit detail records...
        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                502,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                503,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                504,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lCert] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                2990,
                0,
                CONVERT(NVARCHAR, d.[lCert]),
                CONVERT(NVARCHAR, i.[lCert])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[lCert] <> i.[lCert] ) OR
                ( d.[lCert] IS NULL AND i.[lCert] IS NOT NULL ) OR
                ( i.[lCert] IS NULL AND d.[lCert] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lCertCurrent] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                2991,
                0,
                CONVERT(NVARCHAR, d.[lCertCurrent]),
                CONVERT(NVARCHAR, i.[lCertCurrent])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[lCertCurrent] <> i.[lCertCurrent] ) OR
                ( d.[lCertCurrent] IS NULL AND i.[lCertCurrent] IS NOT NULL ) OR
                ( i.[lCertCurrent] IS NULL AND d.[lCertCurrent] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lCertExport] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                2992,
                0,
                CONVERT(NVARCHAR, d.[lCertExport]),
                CONVERT(NVARCHAR, i.[lCertExport])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[lCertExport] <> i.[lCertExport] ) OR
                ( d.[lCertExport] IS NULL AND i.[lCertExport] IS NOT NULL ) OR
                ( i.[lCertExport] IS NULL AND d.[lCertExport] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                505,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lPrivate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                506,
                0,
                CONVERT(NVARCHAR, d.[lPrivate]),
                CONVERT(NVARCHAR, i.[lPrivate])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[lPrivate] <> i.[lPrivate] ) OR
                ( d.[lPrivate] IS NULL AND i.[lPrivate] IS NOT NULL ) OR
                ( i.[lPrivate] IS NULL AND d.[lPrivate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                507,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                508,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetFileUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                509,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetFileUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetFileUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[nCallSheetFileUID] <> i.[nCallSheetFileUID] ) OR
                ( d.[nCallSheetFileUID] IS NULL AND i.[nCallSheetFileUID] IS NOT NULL ) OR
                ( i.[nCallSheetFileUID] IS NULL AND d.[nCallSheetFileUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nCallSheetUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                510,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[nCallSheetUID] <> i.[nCallSheetUID] ) OR
                ( d.[nCallSheetUID] IS NULL AND i.[nCallSheetUID] IS NOT NULL ) OR
                ( i.[nCallSheetUID] IS NULL AND d.[nCallSheetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFileUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                511,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFileUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFileUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[nFileUID] <> i.[nFileUID] ) OR
                ( d.[nFileUID] IS NULL AND i.[nFileUID] IS NOT NULL ) OR
                ( i.[nFileUID] IS NULL AND d.[nFileUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetFileUID], d.[nCallSheetFileUID] )),
                514,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetFileUID] = i.[nCallSheetFileUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 17, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nCallSheetFileUID FROM Inserted
            SELECT @Value = dbo.udf_GET_CallSheetFilesAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheetFiles_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetPartsLink_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheetPartsLink_Ins] from [dbo].[CallSheetPartsLink]'

    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheetPartsLink_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetPartsLink_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheetPartsLink_Ins] on [dbo].[CallSheetPartsLink]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheetPartsLink_Ins] ON [dbo].[CallSheetPartsLink] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            538,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            539,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            540,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            541,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            542,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            543,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            544,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetPartLinkUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            545,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            546,
            0,
            CONVERT( NVARCHAR( 41 ), [nCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            548,
            0,
            CONVERT(NVARCHAR( 36 ), [nJobNumberUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            549,
            0,
            CONVERT(NVARCHAR( 36 ), [nPartUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            550,
            0,
            CONVERT(NVARCHAR, [nQuantity])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            553,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetPartLinkUID]),
            557,
            0,
            CONVERT( NVARCHAR( 34 ), [tUsedDate], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 19, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nCallSheetPartLinkUID FROM Inserted
        SELECT @Value = dbo.udf_GET_CallSheetPartsLinkAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheetPartsLink_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetPartsLink_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheetPartsLink_Upd] from [dbo].[CallSheetPartsLink]'

    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheetPartsLink_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheetPartsLink_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheetPartsLink_Upd] on [dbo].[CallSheetPartsLink]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheetPartsLink_Upd] ON [dbo].[CallSheetPartsLink] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )

        -- Populate audit detail records...
        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                538,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                539,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                540,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                541,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                542,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                543,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetPartLinkUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                544,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetPartLinkUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetPartLinkUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[nCallSheetPartLinkUID] <> i.[nCallSheetPartLinkUID] ) OR
                ( d.[nCallSheetPartLinkUID] IS NULL AND i.[nCallSheetPartLinkUID] IS NOT NULL ) OR
                ( i.[nCallSheetPartLinkUID] IS NULL AND d.[nCallSheetPartLinkUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nCallSheetUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                545,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[nCallSheetUID] <> i.[nCallSheetUID] ) OR
                ( d.[nCallSheetUID] IS NULL AND i.[nCallSheetUID] IS NOT NULL ) OR
                ( i.[nCallSheetUID] IS NULL AND d.[nCallSheetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                546,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[nCost] <> i.[nCost] ) OR
                ( d.[nCost] IS NULL AND i.[nCost] IS NOT NULL ) OR
                ( i.[nCost] IS NULL AND d.[nCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nJobNumberUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                548,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nJobNumberUID]),
                CONVERT(NVARCHAR( 36 ), i.[nJobNumberUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[nJobNumberUID] <> i.[nJobNumberUID] ) OR
                ( d.[nJobNumberUID] IS NULL AND i.[nJobNumberUID] IS NOT NULL ) OR
                ( i.[nJobNumberUID] IS NULL AND d.[nJobNumberUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nPartUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                549,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nPartUID]),
                CONVERT(NVARCHAR( 36 ), i.[nPartUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[nPartUID] <> i.[nPartUID] ) OR
                ( d.[nPartUID] IS NULL AND i.[nPartUID] IS NOT NULL ) OR
                ( i.[nPartUID] IS NULL AND d.[nPartUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nQuantity] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                550,
                0,
                CONVERT(NVARCHAR, d.[nQuantity]),
                CONVERT(NVARCHAR, i.[nQuantity])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[nQuantity] <> i.[nQuantity] ) OR
                ( d.[nQuantity] IS NULL AND i.[nQuantity] IS NOT NULL ) OR
                ( i.[nQuantity] IS NULL AND d.[nQuantity] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                553,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tUsedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetPartLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetPartLinkUID], d.[nCallSheetPartLinkUID] )),
                557,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tUsedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tUsedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetPartLinkUID] = i.[nCallSheetPartLinkUID] )
            WHERE
                ( d.[tUsedDate] <> i.[tUsedDate] ) OR
                ( d.[tUsedDate] IS NULL AND i.[tUsedDate] IS NOT NULL ) OR
                ( i.[tUsedDate] IS NULL AND d.[tUsedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 19, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nCallSheetPartLinkUID FROM Inserted
            SELECT @Value = dbo.udf_GET_CallSheetPartsLinkAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheetPartsLink_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheets_Ins] from [dbo].[CallSheets]'

    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheets_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheets_Ins] on [dbo].[CallSheets]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheets_Ins] ON [dbo].[CallSheets] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            558,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cArea], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            559,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCallSheetNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            560,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCallSheetStatus], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            561,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCallSheetType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            562,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCertFormat], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            563,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCertificationNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            564,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cContactInfo], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            565,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cHumidity], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            566,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cHumidityUOM], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            567,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cInitialCondition], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            568,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cInterval], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            569,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cIntervalUOM], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            570,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cLocation], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            571,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPressure], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            572,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPressureUOM], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            3075,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cReturnedTo], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            573,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cServiceReason], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            574,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStickerType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            575,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cTemperature], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            576,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cTemperatureUOM], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            577,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cWorkOrderResults], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            578,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            579,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            580,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            581,
            0,
            CONVERT(NVARCHAR, [lCancelled])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            582,
            0,
            CONVERT(NVARCHAR, [lClosed])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            583,
            0,
            CONVERT(NVARCHAR, [lDelayed])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            584,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            585,
            0,
            CONVERT(NVARCHAR, [lExpedite])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            586,
            0,
            CONVERT(NVARCHAR, [lISOCert])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            587,
            0,
            CONVERT(NVARCHAR, [lOnSite])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            588,
            0,
            CONVERT(NVARCHAR, [lOOT])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            3072,
            0,
            CONVERT(NVARCHAR, [lOptional1])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            3073,
            0,
            CONVERT(NVARCHAR, [lOptional2])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            589,
            0,
            CONVERT(NVARCHAR, [lReturnNoMaint])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            590,
            0,
            CONVERT(NVARCHAR, [lSubContracted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            591,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mAccuracyNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            592,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mCallSheetNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            593,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mOOTNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            594,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mStickerNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            595,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mSubContractorNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            596,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mUncertaintyNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            597,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            598,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            599,
            0,
            CONVERT( NVARCHAR( 41 ), [nAllocated], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            600,
            0,
            CONVERT( NVARCHAR( 41 ), [nAllocatedParts], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            601,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            602,
            0,
            CONVERT(NVARCHAR( 36 ), [nAssignedTechUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            603,
            0,
            CONVERT(NVARCHAR( 36 ), [nCalendarUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            604,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetAttributeUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            605,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            606,
            0,
            CONVERT(NVARCHAR( 36 ), [nCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            607,
            0,
            CONVERT( NVARCHAR( 41 ), [nCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            608,
            0,
            CONVERT(NVARCHAR( 36 ), [nDepartmentUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            609,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            610,
            0,
            CONVERT(NVARCHAR( 36 ), [nGroupUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            612,
            0,
            CONVERT(NVARCHAR( 36 ), [nInvoiceUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            613,
            0,
            CONVERT(NVARCHAR( 36 ), [nJobNumberUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            614,
            0,
            CONVERT(NVARCHAR( 36 ), [nOwningLabUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            615,
            0,
            CONVERT(NVARCHAR, [nPriority])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            616,
            0,
            CONVERT(NVARCHAR( 36 ), [nProcedureUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            617,
            0,
            CONVERT(NVARCHAR( 36 ), [nQCApprovedByUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            618,
            0,
            CONVERT(NVARCHAR, [nQuantity])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            619,
            0,
            CONVERT(NVARCHAR( 36 ), [nReturnedByUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            620,
            0,
            CONVERT(NVARCHAR, [nRevision])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            621,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            622,
            0,
            CONVERT( NVARCHAR( 41 ), [nSubContCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            623,
            0,
            CONVERT( NVARCHAR( 41 ), [nSubContHours], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            624,
            0,
            CONVERT( NVARCHAR( 41 ), [nSubContLabCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            625,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubContractorUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            626,
            0,
            CONVERT(NVARCHAR, [nTechnicianPriority])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            627,
            0,
            CONVERT(NVARCHAR( 36 ), [nTechnicianUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            628,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeProcedureDefaultUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            629,
            0,
            CONVERT(NVARCHAR( 36 ), [nTypeUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            632,
            0,
            CONVERT(NVARCHAR( 36 ), [nWorkingFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            633,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            634,
            0,
            CONVERT( NVARCHAR( 34 ), [tClosedDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            635,
            0,
            CONVERT( NVARCHAR( 34 ), [tDelayDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            636,
            0,
            CONVERT( NVARCHAR( 34 ), [tMaintDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            637,
            0,
            CONVERT( NVARCHAR( 34 ), [tMaintNextDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            639,
            0,
            CONVERT( NVARCHAR( 34 ), [tOpenDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            640,
            0,
            CONVERT( NVARCHAR( 34 ), [tQCApprovedDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            641,
            0,
            CONVERT( NVARCHAR( 34 ), [tRequiredDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), [nCallSheetUID]),
            642,
            0,
            CONVERT( NVARCHAR( 34 ), [tReturnedDate], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 20, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nCallSheetUID FROM Inserted
        SELECT @Value = dbo.udf_GET_CallSheetsAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheets_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_CallSheets_Upd] from [dbo].[CallSheets]'

    	DROP TRIGGER [dbo].[tr_kr_audit_CallSheets_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_CallSheets_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_CallSheets_Upd] on [dbo].[CallSheets]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_CallSheets_Upd] ON [dbo].[CallSheets] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cArea] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                558,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cArea], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cArea], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cArea], '''') <> NULLIF(i.[cArea], '''') ) OR
                ( NULLIF(d.[cArea], '''') IS NULL AND NULLIF(i.[cArea], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cArea], '''') IS NULL AND NULLIF(d.[cArea], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCallSheetNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                559,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCallSheetNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCallSheetNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cCallSheetNumber], '''') <> NULLIF(i.[cCallSheetNumber], '''') ) OR
                ( NULLIF(d.[cCallSheetNumber], '''') IS NULL AND NULLIF(i.[cCallSheetNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCallSheetNumber], '''') IS NULL AND NULLIF(d.[cCallSheetNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCallSheetStatus] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                560,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCallSheetStatus], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCallSheetStatus], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cCallSheetStatus], '''') <> NULLIF(i.[cCallSheetStatus], '''') ) OR
                ( NULLIF(d.[cCallSheetStatus], '''') IS NULL AND NULLIF(i.[cCallSheetStatus], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCallSheetStatus], '''') IS NULL AND NULLIF(d.[cCallSheetStatus], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCallSheetType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                561,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCallSheetType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCallSheetType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cCallSheetType], '''') <> NULLIF(i.[cCallSheetType], '''') ) OR
                ( NULLIF(d.[cCallSheetType], '''') IS NULL AND NULLIF(i.[cCallSheetType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCallSheetType], '''') IS NULL AND NULLIF(d.[cCallSheetType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCertFormat] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                562,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCertFormat], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCertFormat], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cCertFormat], '''') <> NULLIF(i.[cCertFormat], '''') ) OR
                ( NULLIF(d.[cCertFormat], '''') IS NULL AND NULLIF(i.[cCertFormat], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCertFormat], '''') IS NULL AND NULLIF(d.[cCertFormat], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCertificationNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                563,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCertificationNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCertificationNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cCertificationNumber], '''') <> NULLIF(i.[cCertificationNumber], '''') ) OR
                ( NULLIF(d.[cCertificationNumber], '''') IS NULL AND NULLIF(i.[cCertificationNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCertificationNumber], '''') IS NULL AND NULLIF(d.[cCertificationNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cContactInfo] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                564,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cContactInfo], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cContactInfo], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cContactInfo], '''') <> NULLIF(i.[cContactInfo], '''') ) OR
                ( NULLIF(d.[cContactInfo], '''') IS NULL AND NULLIF(i.[cContactInfo], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cContactInfo], '''') IS NULL AND NULLIF(d.[cContactInfo], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cHumidity] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                565,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cHumidity], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cHumidity], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cHumidity], '''') <> NULLIF(i.[cHumidity], '''') ) OR
                ( NULLIF(d.[cHumidity], '''') IS NULL AND NULLIF(i.[cHumidity], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cHumidity], '''') IS NULL AND NULLIF(d.[cHumidity], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cHumidityUOM] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                566,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cHumidityUOM], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cHumidityUOM], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cHumidityUOM], '''') <> NULLIF(i.[cHumidityUOM], '''') ) OR
                ( NULLIF(d.[cHumidityUOM], '''') IS NULL AND NULLIF(i.[cHumidityUOM], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cHumidityUOM], '''') IS NULL AND NULLIF(d.[cHumidityUOM], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cInitialCondition] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                567,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cInitialCondition], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cInitialCondition], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cInitialCondition], '''') <> NULLIF(i.[cInitialCondition], '''') ) OR
                ( NULLIF(d.[cInitialCondition], '''') IS NULL AND NULLIF(i.[cInitialCondition], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cInitialCondition], '''') IS NULL AND NULLIF(d.[cInitialCondition], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cInterval] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                568,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cInterval], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cInterval], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cInterval], '''') <> NULLIF(i.[cInterval], '''') ) OR
                ( NULLIF(d.[cInterval], '''') IS NULL AND NULLIF(i.[cInterval], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cInterval], '''') IS NULL AND NULLIF(d.[cInterval], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cIntervalUOM] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                569,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cIntervalUOM], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cIntervalUOM], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cIntervalUOM], '''') <> NULLIF(i.[cIntervalUOM], '''') ) OR
                ( NULLIF(d.[cIntervalUOM], '''') IS NULL AND NULLIF(i.[cIntervalUOM], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cIntervalUOM], '''') IS NULL AND NULLIF(d.[cIntervalUOM], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cLocation] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                570,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cLocation], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cLocation], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cLocation], '''') <> NULLIF(i.[cLocation], '''') ) OR
                ( NULLIF(d.[cLocation], '''') IS NULL AND NULLIF(i.[cLocation], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cLocation], '''') IS NULL AND NULLIF(d.[cLocation], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cPressure] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                571,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cPressure], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cPressure], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cPressure], '''') <> NULLIF(i.[cPressure], '''') ) OR
                ( NULLIF(d.[cPressure], '''') IS NULL AND NULLIF(i.[cPressure], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cPressure], '''') IS NULL AND NULLIF(d.[cPressure], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cPressureUOM] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                572,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cPressureUOM], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cPressureUOM], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cPressureUOM], '''') <> NULLIF(i.[cPressureUOM], '''') ) OR
                ( NULLIF(d.[cPressureUOM], '''') IS NULL AND NULLIF(i.[cPressureUOM], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cPressureUOM], '''') IS NULL AND NULLIF(d.[cPressureUOM], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cReturnedTo] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                3075,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cReturnedTo], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cReturnedTo], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cReturnedTo], '''') <> NULLIF(i.[cReturnedTo], '''') ) OR
                ( NULLIF(d.[cReturnedTo], '''') IS NULL AND NULLIF(i.[cReturnedTo], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cReturnedTo], '''') IS NULL AND NULLIF(d.[cReturnedTo], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cServiceReason] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                573,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cServiceReason], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cServiceReason], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cServiceReason], '''') <> NULLIF(i.[cServiceReason], '''') ) OR
                ( NULLIF(d.[cServiceReason], '''') IS NULL AND NULLIF(i.[cServiceReason], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cServiceReason], '''') IS NULL AND NULLIF(d.[cServiceReason], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cStickerType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                574,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cStickerType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cStickerType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cStickerType], '''') <> NULLIF(i.[cStickerType], '''') ) OR
                ( NULLIF(d.[cStickerType], '''') IS NULL AND NULLIF(i.[cStickerType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cStickerType], '''') IS NULL AND NULLIF(d.[cStickerType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cTemperature] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                575,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cTemperature], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cTemperature], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cTemperature], '''') <> NULLIF(i.[cTemperature], '''') ) OR
                ( NULLIF(d.[cTemperature], '''') IS NULL AND NULLIF(i.[cTemperature], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cTemperature], '''') IS NULL AND NULLIF(d.[cTemperature], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cTemperatureUOM] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                576,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cTemperatureUOM], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cTemperatureUOM], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cTemperatureUOM], '''') <> NULLIF(i.[cTemperatureUOM], '''') ) OR
                ( NULLIF(d.[cTemperatureUOM], '''') IS NULL AND NULLIF(i.[cTemperatureUOM], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cTemperatureUOM], '''') IS NULL AND NULLIF(d.[cTemperatureUOM], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cWorkOrderResults] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                577,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cWorkOrderResults], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cWorkOrderResults], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[cWorkOrderResults], '''') <> NULLIF(i.[cWorkOrderResults], '''') ) OR
                ( NULLIF(d.[cWorkOrderResults], '''') IS NULL AND NULLIF(i.[cWorkOrderResults], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cWorkOrderResults], '''') IS NULL AND NULLIF(d.[cWorkOrderResults], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                578,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                579,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                580,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lCancelled] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                581,
                0,
                CONVERT(NVARCHAR, d.[lCancelled]),
                CONVERT(NVARCHAR, i.[lCancelled])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lCancelled] <> i.[lCancelled] ) OR
                ( d.[lCancelled] IS NULL AND i.[lCancelled] IS NOT NULL ) OR
                ( i.[lCancelled] IS NULL AND d.[lCancelled] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lClosed] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                582,
                0,
                CONVERT(NVARCHAR, d.[lClosed]),
                CONVERT(NVARCHAR, i.[lClosed])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lClosed] <> i.[lClosed] ) OR
                ( d.[lClosed] IS NULL AND i.[lClosed] IS NOT NULL ) OR
                ( i.[lClosed] IS NULL AND d.[lClosed] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDelayed] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                583,
                0,
                CONVERT(NVARCHAR, d.[lDelayed]),
                CONVERT(NVARCHAR, i.[lDelayed])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lDelayed] <> i.[lDelayed] ) OR
                ( d.[lDelayed] IS NULL AND i.[lDelayed] IS NOT NULL ) OR
                ( i.[lDelayed] IS NULL AND d.[lDelayed] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                584,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lExpedite] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                585,
                0,
                CONVERT(NVARCHAR, d.[lExpedite]),
                CONVERT(NVARCHAR, i.[lExpedite])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lExpedite] <> i.[lExpedite] ) OR
                ( d.[lExpedite] IS NULL AND i.[lExpedite] IS NOT NULL ) OR
                ( i.[lExpedite] IS NULL AND d.[lExpedite] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lISOCert] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                586,
                0,
                CONVERT(NVARCHAR, d.[lISOCert]),
                CONVERT(NVARCHAR, i.[lISOCert])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lISOCert] <> i.[lISOCert] ) OR
                ( d.[lISOCert] IS NULL AND i.[lISOCert] IS NOT NULL ) OR
                ( i.[lISOCert] IS NULL AND d.[lISOCert] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOnSite] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                587,
                0,
                CONVERT(NVARCHAR, d.[lOnSite]),
                CONVERT(NVARCHAR, i.[lOnSite])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lOnSite] <> i.[lOnSite] ) OR
                ( d.[lOnSite] IS NULL AND i.[lOnSite] IS NOT NULL ) OR
                ( i.[lOnSite] IS NULL AND d.[lOnSite] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOOT] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                588,
                0,
                CONVERT(NVARCHAR, d.[lOOT]),
                CONVERT(NVARCHAR, i.[lOOT])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lOOT] <> i.[lOOT] ) OR
                ( d.[lOOT] IS NULL AND i.[lOOT] IS NOT NULL ) OR
                ( i.[lOOT] IS NULL AND d.[lOOT] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOptional1] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                3072,
                0,
                CONVERT(NVARCHAR, d.[lOptional1]),
                CONVERT(NVARCHAR, i.[lOptional1])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lOptional1] <> i.[lOptional1] ) OR
                ( d.[lOptional1] IS NULL AND i.[lOptional1] IS NOT NULL ) OR
                ( i.[lOptional1] IS NULL AND d.[lOptional1] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lOptional2] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                3073,
                0,
                CONVERT(NVARCHAR, d.[lOptional2]),
                CONVERT(NVARCHAR, i.[lOptional2])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lOptional2] <> i.[lOptional2] ) OR
                ( d.[lOptional2] IS NULL AND i.[lOptional2] IS NOT NULL ) OR
                ( i.[lOptional2] IS NULL AND d.[lOptional2] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lReturnNoMaint] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                589,
                0,
                CONVERT(NVARCHAR, d.[lReturnNoMaint]),
                CONVERT(NVARCHAR, i.[lReturnNoMaint])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lReturnNoMaint] <> i.[lReturnNoMaint] ) OR
                ( d.[lReturnNoMaint] IS NULL AND i.[lReturnNoMaint] IS NOT NULL ) OR
                ( i.[lReturnNoMaint] IS NULL AND d.[lReturnNoMaint] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lSubContracted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                590,
                0,
                CONVERT(NVARCHAR, d.[lSubContracted]),
                CONVERT(NVARCHAR, i.[lSubContracted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[lSubContracted] <> i.[lSubContracted] ) OR
                ( d.[lSubContracted] IS NULL AND i.[lSubContracted] IS NOT NULL ) OR
                ( i.[lSubContracted] IS NULL AND d.[lSubContracted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mAccuracyNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                591,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mAccuracyNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mAccuracyNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mAccuracyNotes], '''') <> NULLIF(i.[mAccuracyNotes], '''') ) OR
                ( NULLIF(d.[mAccuracyNotes], '''') IS NULL AND NULLIF(i.[mAccuracyNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mAccuracyNotes], '''') IS NULL AND NULLIF(d.[mAccuracyNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mCallSheetNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                592,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mCallSheetNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mCallSheetNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mCallSheetNotes], '''') <> NULLIF(i.[mCallSheetNotes], '''') ) OR
                ( NULLIF(d.[mCallSheetNotes], '''') IS NULL AND NULLIF(i.[mCallSheetNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mCallSheetNotes], '''') IS NULL AND NULLIF(d.[mCallSheetNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mOOTNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                593,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mOOTNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mOOTNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mOOTNotes], '''') <> NULLIF(i.[mOOTNotes], '''') ) OR
                ( NULLIF(d.[mOOTNotes], '''') IS NULL AND NULLIF(i.[mOOTNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mOOTNotes], '''') IS NULL AND NULLIF(d.[mOOTNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mStickerNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                594,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mStickerNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mStickerNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mStickerNotes], '''') <> NULLIF(i.[mStickerNotes], '''') ) OR
                ( NULLIF(d.[mStickerNotes], '''') IS NULL AND NULLIF(i.[mStickerNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mStickerNotes], '''') IS NULL AND NULLIF(d.[mStickerNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mSubContractorNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                595,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mSubContractorNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mSubContractorNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mSubContractorNotes], '''') <> NULLIF(i.[mSubContractorNotes], '''') ) OR
                ( NULLIF(d.[mSubContractorNotes], '''') IS NULL AND NULLIF(i.[mSubContractorNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mSubContractorNotes], '''') IS NULL AND NULLIF(d.[mSubContractorNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mUncertaintyNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                596,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mUncertaintyNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mUncertaintyNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( NULLIF(d.[mUncertaintyNotes], '''') <> NULLIF(i.[mUncertaintyNotes], '''') ) OR
                ( NULLIF(d.[mUncertaintyNotes], '''') IS NULL AND NULLIF(i.[mUncertaintyNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mUncertaintyNotes], '''') IS NULL AND NULLIF(d.[mUncertaintyNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                597,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                598,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAllocated] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                599,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nAllocated], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nAllocated], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAllocated] <> i.[nAllocated] ) OR
                ( d.[nAllocated] IS NULL AND i.[nAllocated] IS NOT NULL ) OR
                ( i.[nAllocated] IS NULL AND d.[nAllocated] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAllocatedParts] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                600,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nAllocatedParts], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nAllocatedParts], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAllocatedParts] <> i.[nAllocatedParts] ) OR
                ( d.[nAllocatedParts] IS NULL AND i.[nAllocatedParts] IS NOT NULL ) OR
                ( i.[nAllocatedParts] IS NULL AND d.[nAllocatedParts] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAssetUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                601,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAssetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAssetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAssetUID] <> i.[nAssetUID] ) OR
                ( d.[nAssetUID] IS NULL AND i.[nAssetUID] IS NOT NULL ) OR
                ( i.[nAssetUID] IS NULL AND d.[nAssetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAssignedTechUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                602,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAssignedTechUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAssignedTechUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nAssignedTechUID] <> i.[nAssignedTechUID] ) OR
                ( d.[nAssignedTechUID] IS NULL AND i.[nAssignedTechUID] IS NOT NULL ) OR
                ( i.[nAssignedTechUID] IS NULL AND d.[nAssignedTechUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCalendarUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                603,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCalendarUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCalendarUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nCalendarUID] <> i.[nCalendarUID] ) OR
                ( d.[nCalendarUID] IS NULL AND i.[nCalendarUID] IS NOT NULL ) OR
                ( i.[nCalendarUID] IS NULL AND d.[nCalendarUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetAttributeUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                604,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetAttributeUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetAttributeUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nCallSheetAttributeUID] <> i.[nCallSheetAttributeUID] ) OR
                ( d.[nCallSheetAttributeUID] IS NULL AND i.[nCallSheetAttributeUID] IS NOT NULL ) OR
                ( i.[nCallSheetAttributeUID] IS NULL AND d.[nCallSheetAttributeUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                605,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nCallSheetUID] <> i.[nCallSheetUID] ) OR
                ( d.[nCallSheetUID] IS NULL AND i.[nCallSheetUID] IS NOT NULL ) OR
                ( i.[nCallSheetUID] IS NULL AND d.[nCallSheetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                606,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nCategoryUID] <> i.[nCategoryUID] ) OR
                ( d.[nCategoryUID] IS NULL AND i.[nCategoryUID] IS NOT NULL ) OR
                ( i.[nCategoryUID] IS NULL AND d.[nCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                607,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nCost] <> i.[nCost] ) OR
                ( d.[nCost] IS NULL AND i.[nCost] IS NOT NULL ) OR
                ( i.[nCost] IS NULL AND d.[nCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nDepartmentUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                608,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nDepartmentUID]),
                CONVERT(NVARCHAR( 36 ), i.[nDepartmentUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nDepartmentUID] <> i.[nDepartmentUID] ) OR
                ( d.[nDepartmentUID] IS NULL AND i.[nDepartmentUID] IS NOT NULL ) OR
                ( i.[nDepartmentUID] IS NULL AND d.[nDepartmentUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                609,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nFacilityUID] <> i.[nFacilityUID] ) OR
                ( d.[nFacilityUID] IS NULL AND i.[nFacilityUID] IS NOT NULL ) OR
                ( i.[nFacilityUID] IS NULL AND d.[nFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nGroupUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                610,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nGroupUID]),
                CONVERT(NVARCHAR( 36 ), i.[nGroupUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nGroupUID] <> i.[nGroupUID] ) OR
                ( d.[nGroupUID] IS NULL AND i.[nGroupUID] IS NOT NULL ) OR
                ( i.[nGroupUID] IS NULL AND d.[nGroupUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nInvoiceUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                612,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nInvoiceUID]),
                CONVERT(NVARCHAR( 36 ), i.[nInvoiceUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nInvoiceUID] <> i.[nInvoiceUID] ) OR
                ( d.[nInvoiceUID] IS NULL AND i.[nInvoiceUID] IS NOT NULL ) OR
                ( i.[nInvoiceUID] IS NULL AND d.[nInvoiceUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nJobNumberUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                613,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nJobNumberUID]),
                CONVERT(NVARCHAR( 36 ), i.[nJobNumberUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nJobNumberUID] <> i.[nJobNumberUID] ) OR
                ( d.[nJobNumberUID] IS NULL AND i.[nJobNumberUID] IS NOT NULL ) OR
                ( i.[nJobNumberUID] IS NULL AND d.[nJobNumberUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nOwningLabUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                614,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nOwningLabUID]),
                CONVERT(NVARCHAR( 36 ), i.[nOwningLabUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nOwningLabUID] <> i.[nOwningLabUID] ) OR
                ( d.[nOwningLabUID] IS NULL AND i.[nOwningLabUID] IS NOT NULL ) OR
                ( i.[nOwningLabUID] IS NULL AND d.[nOwningLabUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nPriority] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                615,
                0,
                CONVERT(NVARCHAR, d.[nPriority]),
                CONVERT(NVARCHAR, i.[nPriority])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nPriority] <> i.[nPriority] ) OR
                ( d.[nPriority] IS NULL AND i.[nPriority] IS NOT NULL ) OR
                ( i.[nPriority] IS NULL AND d.[nPriority] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nProcedureUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                616,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nProcedureUID]),
                CONVERT(NVARCHAR( 36 ), i.[nProcedureUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nProcedureUID] <> i.[nProcedureUID] ) OR
                ( d.[nProcedureUID] IS NULL AND i.[nProcedureUID] IS NOT NULL ) OR
                ( i.[nProcedureUID] IS NULL AND d.[nProcedureUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nQCApprovedByUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                617,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nQCApprovedByUID]),
                CONVERT(NVARCHAR( 36 ), i.[nQCApprovedByUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nQCApprovedByUID] <> i.[nQCApprovedByUID] ) OR
                ( d.[nQCApprovedByUID] IS NULL AND i.[nQCApprovedByUID] IS NOT NULL ) OR
                ( i.[nQCApprovedByUID] IS NULL AND d.[nQCApprovedByUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nQuantity] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                618,
                0,
                CONVERT(NVARCHAR, d.[nQuantity]),
                CONVERT(NVARCHAR, i.[nQuantity])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nQuantity] <> i.[nQuantity] ) OR
                ( d.[nQuantity] IS NULL AND i.[nQuantity] IS NOT NULL ) OR
                ( i.[nQuantity] IS NULL AND d.[nQuantity] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nReturnedByUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                619,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nReturnedByUID]),
                CONVERT(NVARCHAR( 36 ), i.[nReturnedByUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nReturnedByUID] <> i.[nReturnedByUID] ) OR
                ( d.[nReturnedByUID] IS NULL AND i.[nReturnedByUID] IS NOT NULL ) OR
                ( i.[nReturnedByUID] IS NULL AND d.[nReturnedByUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nRevision] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                620,
                0,
                CONVERT(NVARCHAR, d.[nRevision]),
                CONVERT(NVARCHAR, i.[nRevision])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nRevision] <> i.[nRevision] ) OR
                ( d.[nRevision] IS NULL AND i.[nRevision] IS NOT NULL ) OR
                ( i.[nRevision] IS NULL AND d.[nRevision] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                621,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nSubCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nSubCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nSubCategoryUID] <> i.[nSubCategoryUID] ) OR
                ( d.[nSubCategoryUID] IS NULL AND i.[nSubCategoryUID] IS NOT NULL ) OR
                ( i.[nSubCategoryUID] IS NULL AND d.[nSubCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubContCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                622,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nSubContCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nSubContCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nSubContCost] <> i.[nSubContCost] ) OR
                ( d.[nSubContCost] IS NULL AND i.[nSubContCost] IS NOT NULL ) OR
                ( i.[nSubContCost] IS NULL AND d.[nSubContCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubContHours] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                623,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nSubContHours], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nSubContHours], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nSubContHours] <> i.[nSubContHours] ) OR
                ( d.[nSubContHours] IS NULL AND i.[nSubContHours] IS NOT NULL ) OR
                ( i.[nSubContHours] IS NULL AND d.[nSubContHours] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubContLabCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                624,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nSubContLabCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nSubContLabCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nSubContLabCost] <> i.[nSubContLabCost] ) OR
                ( d.[nSubContLabCost] IS NULL AND i.[nSubContLabCost] IS NOT NULL ) OR
                ( i.[nSubContLabCost] IS NULL AND d.[nSubContLabCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubContractorUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                625,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nSubContractorUID]),
                CONVERT(NVARCHAR( 36 ), i.[nSubContractorUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nSubContractorUID] <> i.[nSubContractorUID] ) OR
                ( d.[nSubContractorUID] IS NULL AND i.[nSubContractorUID] IS NOT NULL ) OR
                ( i.[nSubContractorUID] IS NULL AND d.[nSubContractorUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTechnicianPriority] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                626,
                0,
                CONVERT(NVARCHAR, d.[nTechnicianPriority]),
                CONVERT(NVARCHAR, i.[nTechnicianPriority])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nTechnicianPriority] <> i.[nTechnicianPriority] ) OR
                ( d.[nTechnicianPriority] IS NULL AND i.[nTechnicianPriority] IS NOT NULL ) OR
                ( i.[nTechnicianPriority] IS NULL AND d.[nTechnicianPriority] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTechnicianUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                627,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nTechnicianUID]),
                CONVERT(NVARCHAR( 36 ), i.[nTechnicianUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nTechnicianUID] <> i.[nTechnicianUID] ) OR
                ( d.[nTechnicianUID] IS NULL AND i.[nTechnicianUID] IS NOT NULL ) OR
                ( i.[nTechnicianUID] IS NULL AND d.[nTechnicianUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTypeProcedureDefaultUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                628,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nTypeProcedureDefaultUID]),
                CONVERT(NVARCHAR( 36 ), i.[nTypeProcedureDefaultUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nTypeProcedureDefaultUID] <> i.[nTypeProcedureDefaultUID] ) OR
                ( d.[nTypeProcedureDefaultUID] IS NULL AND i.[nTypeProcedureDefaultUID] IS NOT NULL ) OR
                ( i.[nTypeProcedureDefaultUID] IS NULL AND d.[nTypeProcedureDefaultUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTypeUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                629,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nTypeUID]),
                CONVERT(NVARCHAR( 36 ), i.[nTypeUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nTypeUID] <> i.[nTypeUID] ) OR
                ( d.[nTypeUID] IS NULL AND i.[nTypeUID] IS NOT NULL ) OR
                ( i.[nTypeUID] IS NULL AND d.[nTypeUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nWorkingFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                632,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nWorkingFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nWorkingFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[nWorkingFacilityUID] <> i.[nWorkingFacilityUID] ) OR
                ( d.[nWorkingFacilityUID] IS NULL AND i.[nWorkingFacilityUID] IS NOT NULL ) OR
                ( i.[nWorkingFacilityUID] IS NULL AND d.[nWorkingFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                633,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tClosedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                634,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tClosedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tClosedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tClosedDate] <> i.[tClosedDate] ) OR
                ( d.[tClosedDate] IS NULL AND i.[tClosedDate] IS NOT NULL ) OR
                ( i.[tClosedDate] IS NULL AND d.[tClosedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tDelayDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                635,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tDelayDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tDelayDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tDelayDate] <> i.[tDelayDate] ) OR
                ( d.[tDelayDate] IS NULL AND i.[tDelayDate] IS NOT NULL ) OR
                ( i.[tDelayDate] IS NULL AND d.[tDelayDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tMaintDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                636,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tMaintDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tMaintDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tMaintDate] <> i.[tMaintDate] ) OR
                ( d.[tMaintDate] IS NULL AND i.[tMaintDate] IS NOT NULL ) OR
                ( i.[tMaintDate] IS NULL AND d.[tMaintDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tMaintNextDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                637,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tMaintNextDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tMaintNextDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tMaintNextDate] <> i.[tMaintNextDate] ) OR
                ( d.[tMaintNextDate] IS NULL AND i.[tMaintNextDate] IS NOT NULL ) OR
                ( i.[tMaintNextDate] IS NULL AND d.[tMaintNextDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tOpenDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                639,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tOpenDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tOpenDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tOpenDate] <> i.[tOpenDate] ) OR
                ( d.[tOpenDate] IS NULL AND i.[tOpenDate] IS NOT NULL ) OR
                ( i.[tOpenDate] IS NULL AND d.[tOpenDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tQCApprovedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                640,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tQCApprovedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tQCApprovedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tQCApprovedDate] <> i.[tQCApprovedDate] ) OR
                ( d.[tQCApprovedDate] IS NULL AND i.[tQCApprovedDate] IS NOT NULL ) OR
                ( i.[tQCApprovedDate] IS NULL AND d.[tQCApprovedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tRequiredDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                641,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tRequiredDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tRequiredDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tRequiredDate] <> i.[tRequiredDate] ) OR
                ( d.[tRequiredDate] IS NULL AND i.[tRequiredDate] IS NOT NULL ) OR
                ( i.[tRequiredDate] IS NULL AND d.[tRequiredDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tReturnedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nCallSheetUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nCallSheetUID], d.[nCallSheetUID] )),
                642,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tReturnedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tReturnedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nCallSheetUID] = i.[nCallSheetUID] )
            WHERE
                ( d.[tReturnedDate] <> i.[tReturnedDate] ) OR
                ( d.[tReturnedDate] IS NULL AND i.[tReturnedDate] IS NOT NULL ) OR
                ( i.[tReturnedDate] IS NULL AND d.[tReturnedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 20, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nCallSheetUID FROM Inserted
            SELECT @Value = dbo.udf_GET_CallSheetsAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_CallSheets_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Contacts_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Contacts_Ins] from [dbo].[Contacts]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Contacts_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Contacts_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Contacts_Ins] on [dbo].[Contacts]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Contacts_Ins] ON [dbo].[Contacts] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            664,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCellPhone], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            665,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDescription], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            666,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cEmail1], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            667,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cEmail2], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            668,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cExtension], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            669,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFax], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            670,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFirstName], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            671,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cLastName], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            672,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cMiddleName], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            673,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPhone1], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            674,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cPhone2], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            675,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cSuffix], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            676,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            677,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            678,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            679,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            680,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            681,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            682,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            683,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            684,
            0,
            CONVERT(NVARCHAR( 36 ), [nContactUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            686,
            0,
            CONVERT(NVARCHAR( 36 ), [nManagerUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            689,
            0,
            CONVERT(NVARCHAR( 36 ), [nUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nContactUID='' + CONVERT(VARCHAR( 36 ), [nContactUID]),
            690,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 22, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nContactUID FROM Inserted
        SELECT @Value = dbo.udf_GET_ContactsAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Contacts_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Contacts_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Contacts_Upd] from [dbo].[Contacts]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Contacts_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Contacts_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Contacts_Upd] on [dbo].[Contacts]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Contacts_Upd] ON [dbo].[Contacts] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nContactUID] = i.[nContactUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cCellPhone] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                664,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCellPhone], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCellPhone], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cCellPhone], '''') <> NULLIF(i.[cCellPhone], '''') ) OR
                ( NULLIF(d.[cCellPhone], '''') IS NULL AND NULLIF(i.[cCellPhone], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCellPhone], '''') IS NULL AND NULLIF(d.[cCellPhone], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cDescription] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                665,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cDescription], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cDescription], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cDescription], '''') <> NULLIF(i.[cDescription], '''') ) OR
                ( NULLIF(d.[cDescription], '''') IS NULL AND NULLIF(i.[cDescription], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cDescription], '''') IS NULL AND NULLIF(d.[cDescription], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cEmail1] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                666,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cEmail1], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cEmail1], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cEmail1], '''') <> NULLIF(i.[cEmail1], '''') ) OR
                ( NULLIF(d.[cEmail1], '''') IS NULL AND NULLIF(i.[cEmail1], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cEmail1], '''') IS NULL AND NULLIF(d.[cEmail1], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cEmail2] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                667,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cEmail2], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cEmail2], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cEmail2], '''') <> NULLIF(i.[cEmail2], '''') ) OR
                ( NULLIF(d.[cEmail2], '''') IS NULL AND NULLIF(i.[cEmail2], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cEmail2], '''') IS NULL AND NULLIF(d.[cEmail2], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cExtension] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                668,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cExtension], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cExtension], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cExtension], '''') <> NULLIF(i.[cExtension], '''') ) OR
                ( NULLIF(d.[cExtension], '''') IS NULL AND NULLIF(i.[cExtension], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cExtension], '''') IS NULL AND NULLIF(d.[cExtension], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFax] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                669,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFax], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFax], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cFax], '''') <> NULLIF(i.[cFax], '''') ) OR
                ( NULLIF(d.[cFax], '''') IS NULL AND NULLIF(i.[cFax], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFax], '''') IS NULL AND NULLIF(d.[cFax], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFirstName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                670,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFirstName], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFirstName], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cFirstName], '''') <> NULLIF(i.[cFirstName], '''') ) OR
                ( NULLIF(d.[cFirstName], '''') IS NULL AND NULLIF(i.[cFirstName], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFirstName], '''') IS NULL AND NULLIF(d.[cFirstName], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cLastName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                671,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cLastName], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cLastName], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cLastName], '''') <> NULLIF(i.[cLastName], '''') ) OR
                ( NULLIF(d.[cLastName], '''') IS NULL AND NULLIF(i.[cLastName], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cLastName], '''') IS NULL AND NULLIF(d.[cLastName], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cMiddleName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                672,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cMiddleName], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cMiddleName], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cMiddleName], '''') <> NULLIF(i.[cMiddleName], '''') ) OR
                ( NULLIF(d.[cMiddleName], '''') IS NULL AND NULLIF(i.[cMiddleName], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cMiddleName], '''') IS NULL AND NULLIF(d.[cMiddleName], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cPhone1] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                673,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cPhone1], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cPhone1], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cPhone1], '''') <> NULLIF(i.[cPhone1], '''') ) OR
                ( NULLIF(d.[cPhone1], '''') IS NULL AND NULLIF(i.[cPhone1], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cPhone1], '''') IS NULL AND NULLIF(d.[cPhone1], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cPhone2] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                674,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cPhone2], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cPhone2], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cPhone2], '''') <> NULLIF(i.[cPhone2], '''') ) OR
                ( NULLIF(d.[cPhone2], '''') IS NULL AND NULLIF(i.[cPhone2], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cPhone2], '''') IS NULL AND NULLIF(d.[cPhone2], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cSuffix] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                675,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cSuffix], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cSuffix], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cSuffix], '''') <> NULLIF(i.[cSuffix], '''') ) OR
                ( NULLIF(d.[cSuffix], '''') IS NULL AND NULLIF(i.[cSuffix], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cSuffix], '''') IS NULL AND NULLIF(d.[cSuffix], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                676,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[cType], '''') <> NULLIF(i.[cType], '''') ) OR
                ( NULLIF(d.[cType], '''') IS NULL AND NULLIF(i.[cType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cType], '''') IS NULL AND NULLIF(d.[cType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                677,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                678,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                679,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                680,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                681,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                682,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                683,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nContactUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                684,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nContactUID]),
                CONVERT(NVARCHAR( 36 ), i.[nContactUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( d.[nContactUID] <> i.[nContactUID] ) OR
                ( d.[nContactUID] IS NULL AND i.[nContactUID] IS NOT NULL ) OR
                ( i.[nContactUID] IS NULL AND d.[nContactUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nManagerUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                686,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nManagerUID]),
                CONVERT(NVARCHAR( 36 ), i.[nManagerUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( d.[nManagerUID] <> i.[nManagerUID] ) OR
                ( d.[nManagerUID] IS NULL AND i.[nManagerUID] IS NOT NULL ) OR
                ( i.[nManagerUID] IS NULL AND d.[nManagerUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                689,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( d.[nUserUID] <> i.[nUserUID] ) OR
                ( d.[nUserUID] IS NULL AND i.[nUserUID] IS NOT NULL ) OR
                ( i.[nUserUID] IS NULL AND d.[nUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nContactUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nContactUID], d.[nContactUID] )),
                690,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nContactUID] = i.[nContactUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 22, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nContactUID FROM Inserted
            SELECT @Value = dbo.udf_GET_ContactsAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Contacts_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_DataCheckSQL_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_DataCheckSQL_Ins] from [dbo].[DataCheckSQL]'

    	DROP TRIGGER [dbo].[tr_kr_audit_DataCheckSQL_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_DataCheckSQL_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_DataCheckSQL_Ins] on [dbo].[DataCheckSQL]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_DataCheckSQL_Ins] ON [dbo].[DataCheckSQL] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            694,
            0,
            CONVERT( NVARCHAR(max), [cFunctionName] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            695,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            696,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            697,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            698,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            699,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            700,
            0,
            CONVERT( NVARCHAR(max), [mSQL] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            701,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            702,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            703,
            0,
            CONVERT(NVARCHAR( 36 ), [nDataCheckSQLUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            704,
            0,
            CONVERT(NVARCHAR( 36 ), [nDataCheckUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), [nDataCheckSQLUID]),
            707,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 23, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nDataCheckSQLUID FROM Inserted
        SELECT @Value = dbo.udf_GET_DataCheckSQLAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_DataCheckSQL_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_DataCheckSQL_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_DataCheckSQL_Upd] from [dbo].[DataCheckSQL]'

    	DROP TRIGGER [dbo].[tr_kr_audit_DataCheckSQL_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_DataCheckSQL_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_DataCheckSQL_Upd] on [dbo].[DataCheckSQL]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_DataCheckSQL_Upd] ON [dbo].[DataCheckSQL] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cFunctionName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                694,
                0,
                CONVERT( NVARCHAR(max), d.[cFunctionName] ),
                CONVERT( NVARCHAR(max), i.[cFunctionName] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[cFunctionName] <> i.[cFunctionName] ) OR
                ( d.[cFunctionName] IS NULL AND i.[cFunctionName] IS NOT NULL ) OR
                ( i.[cFunctionName] IS NULL AND d.[cFunctionName] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                695,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                696,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                697,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                698,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                699,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mSQL] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                700,
                0,
                CONVERT( NVARCHAR(max), d.[mSQL] ),
                CONVERT( NVARCHAR(max), i.[mSQL] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[mSQL] <> i.[mSQL] ) OR
                ( d.[mSQL] IS NULL AND i.[mSQL] IS NOT NULL ) OR
                ( i.[mSQL] IS NULL AND d.[mSQL] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                701,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                702,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nDataCheckSQLUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                703,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nDataCheckSQLUID]),
                CONVERT(NVARCHAR( 36 ), i.[nDataCheckSQLUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[nDataCheckSQLUID] <> i.[nDataCheckSQLUID] ) OR
                ( d.[nDataCheckSQLUID] IS NULL AND i.[nDataCheckSQLUID] IS NOT NULL ) OR
                ( i.[nDataCheckSQLUID] IS NULL AND d.[nDataCheckSQLUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nDataCheckUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                704,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nDataCheckUID]),
                CONVERT(NVARCHAR( 36 ), i.[nDataCheckUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[nDataCheckUID] <> i.[nDataCheckUID] ) OR
                ( d.[nDataCheckUID] IS NULL AND i.[nDataCheckUID] IS NOT NULL ) OR
                ( i.[nDataCheckUID] IS NULL AND d.[nDataCheckUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nDataCheckSQLUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nDataCheckSQLUID], d.[nDataCheckSQLUID] )),
                707,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nDataCheckSQLUID] = i.[nDataCheckSQLUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 23, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nDataCheckSQLUID FROM Inserted
            SELECT @Value = dbo.udf_GET_DataCheckSQLAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_DataCheckSQL_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Estimates_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Estimates_Ins] from [dbo].[Estimates]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Estimates_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Estimates_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Estimates_Ins] on [dbo].[Estimates]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Estimates_Ins] ON [dbo].[Estimates] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            737,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAcceptedBy], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            738,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAccountType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            739,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cEstimateNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            740,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cEstimateStatus], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            741,
            0,
            CONVERT(NVARCHAR, [lAccepted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            742,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            743,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            744,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            745,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            746,
            0,
            CONVERT(NVARCHAR, [lLabAccepted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            747,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mCustomerNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            748,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mLabNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            749,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            750,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            751,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            752,
            0,
            CONVERT(NVARCHAR( 36 ), [nContactUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            753,
            0,
            CONVERT( NVARCHAR( 41 ), [nCustomerDiscount], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            754,
            0,
            CONVERT(NVARCHAR, [nEstDeliveryDays])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            755,
            0,
            CONVERT(NVARCHAR( 36 ), [nEstimateUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            756,
            0,
            CONVERT(NVARCHAR( 36 ), [nEstimatorUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            757,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            758,
            0,
            CONVERT(NVARCHAR( 36 ), [nJobNumberUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            759,
            0,
            CONVERT(NVARCHAR( 36 ), [nLabAcceptedByUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            760,
            0,
            CONVERT( NVARCHAR( 41 ), [nTotal], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            763,
            0,
            CONVERT( NVARCHAR( 34 ), [tAcceptedDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            764,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            765,
            0,
            CONVERT( NVARCHAR( 34 ), [tEndDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            766,
            0,
            CONVERT( NVARCHAR( 34 ), [tEstimateDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            767,
            0,
            CONVERT( NVARCHAR( 34 ), [tExpirationDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            768,
            0,
            CONVERT( NVARCHAR( 34 ), [tLabAcceptedDate], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), [nEstimateUID]),
            770,
            0,
            CONVERT( NVARCHAR( 34 ), [tStartDate], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 25, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nEstimateUID FROM Inserted
        SELECT @Value = dbo.udf_GET_EstimatesAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Estimates_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Estimates_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Estimates_Upd] from [dbo].[Estimates]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Estimates_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Estimates_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Estimates_Upd] on [dbo].[Estimates]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Estimates_Upd] ON [dbo].[Estimates] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cAcceptedBy] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                737,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAcceptedBy], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAcceptedBy], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( NULLIF(d.[cAcceptedBy], '''') <> NULLIF(i.[cAcceptedBy], '''') ) OR
                ( NULLIF(d.[cAcceptedBy], '''') IS NULL AND NULLIF(i.[cAcceptedBy], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAcceptedBy], '''') IS NULL AND NULLIF(d.[cAcceptedBy], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cAccountType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                738,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAccountType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAccountType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( NULLIF(d.[cAccountType], '''') <> NULLIF(i.[cAccountType], '''') ) OR
                ( NULLIF(d.[cAccountType], '''') IS NULL AND NULLIF(i.[cAccountType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAccountType], '''') IS NULL AND NULLIF(d.[cAccountType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cEstimateNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                739,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cEstimateNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cEstimateNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( NULLIF(d.[cEstimateNumber], '''') <> NULLIF(i.[cEstimateNumber], '''') ) OR
                ( NULLIF(d.[cEstimateNumber], '''') IS NULL AND NULLIF(i.[cEstimateNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cEstimateNumber], '''') IS NULL AND NULLIF(d.[cEstimateNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cEstimateStatus] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                740,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cEstimateStatus], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cEstimateStatus], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( NULLIF(d.[cEstimateStatus], '''') <> NULLIF(i.[cEstimateStatus], '''') ) OR
                ( NULLIF(d.[cEstimateStatus], '''') IS NULL AND NULLIF(i.[cEstimateStatus], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cEstimateStatus], '''') IS NULL AND NULLIF(d.[cEstimateStatus], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAccepted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                741,
                0,
                CONVERT(NVARCHAR, d.[lAccepted]),
                CONVERT(NVARCHAR, i.[lAccepted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[lAccepted] <> i.[lAccepted] ) OR
                ( d.[lAccepted] IS NULL AND i.[lAccepted] IS NOT NULL ) OR
                ( i.[lAccepted] IS NULL AND d.[lAccepted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                742,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                743,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                744,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                745,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lLabAccepted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                746,
                0,
                CONVERT(NVARCHAR, d.[lLabAccepted]),
                CONVERT(NVARCHAR, i.[lLabAccepted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[lLabAccepted] <> i.[lLabAccepted] ) OR
                ( d.[lLabAccepted] IS NULL AND i.[lLabAccepted] IS NOT NULL ) OR
                ( i.[lLabAccepted] IS NULL AND d.[lLabAccepted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mCustomerNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                747,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mCustomerNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mCustomerNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( NULLIF(d.[mCustomerNotes], '''') <> NULLIF(i.[mCustomerNotes], '''') ) OR
                ( NULLIF(d.[mCustomerNotes], '''') IS NULL AND NULLIF(i.[mCustomerNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mCustomerNotes], '''') IS NULL AND NULLIF(d.[mCustomerNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mLabNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                748,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mLabNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mLabNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( NULLIF(d.[mLabNotes], '''') <> NULLIF(i.[mLabNotes], '''') ) OR
                ( NULLIF(d.[mLabNotes], '''') IS NULL AND NULLIF(i.[mLabNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mLabNotes], '''') IS NULL AND NULLIF(d.[mLabNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                749,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                750,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                751,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nCallSheetUID] <> i.[nCallSheetUID] ) OR
                ( d.[nCallSheetUID] IS NULL AND i.[nCallSheetUID] IS NOT NULL ) OR
                ( i.[nCallSheetUID] IS NULL AND d.[nCallSheetUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nContactUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                752,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nContactUID]),
                CONVERT(NVARCHAR( 36 ), i.[nContactUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nContactUID] <> i.[nContactUID] ) OR
                ( d.[nContactUID] IS NULL AND i.[nContactUID] IS NOT NULL ) OR
                ( i.[nContactUID] IS NULL AND d.[nContactUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCustomerDiscount] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                753,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nCustomerDiscount], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nCustomerDiscount], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nCustomerDiscount] <> i.[nCustomerDiscount] ) OR
                ( d.[nCustomerDiscount] IS NULL AND i.[nCustomerDiscount] IS NOT NULL ) OR
                ( i.[nCustomerDiscount] IS NULL AND d.[nCustomerDiscount] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nEstDeliveryDays] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                754,
                0,
                CONVERT(NVARCHAR, d.[nEstDeliveryDays]),
                CONVERT(NVARCHAR, i.[nEstDeliveryDays])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nEstDeliveryDays] <> i.[nEstDeliveryDays] ) OR
                ( d.[nEstDeliveryDays] IS NULL AND i.[nEstDeliveryDays] IS NOT NULL ) OR
                ( i.[nEstDeliveryDays] IS NULL AND d.[nEstDeliveryDays] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nEstimateUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                755,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nEstimateUID]),
                CONVERT(NVARCHAR( 36 ), i.[nEstimateUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nEstimateUID] <> i.[nEstimateUID] ) OR
                ( d.[nEstimateUID] IS NULL AND i.[nEstimateUID] IS NOT NULL ) OR
                ( i.[nEstimateUID] IS NULL AND d.[nEstimateUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nEstimatorUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                756,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nEstimatorUID]),
                CONVERT(NVARCHAR( 36 ), i.[nEstimatorUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nEstimatorUID] <> i.[nEstimatorUID] ) OR
                ( d.[nEstimatorUID] IS NULL AND i.[nEstimatorUID] IS NOT NULL ) OR
                ( i.[nEstimatorUID] IS NULL AND d.[nEstimatorUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                757,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nFacilityUID] <> i.[nFacilityUID] ) OR
                ( d.[nFacilityUID] IS NULL AND i.[nFacilityUID] IS NOT NULL ) OR
                ( i.[nFacilityUID] IS NULL AND d.[nFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nJobNumberUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                758,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nJobNumberUID]),
                CONVERT(NVARCHAR( 36 ), i.[nJobNumberUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nJobNumberUID] <> i.[nJobNumberUID] ) OR
                ( d.[nJobNumberUID] IS NULL AND i.[nJobNumberUID] IS NOT NULL ) OR
                ( i.[nJobNumberUID] IS NULL AND d.[nJobNumberUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nLabAcceptedByUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                759,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nLabAcceptedByUID]),
                CONVERT(NVARCHAR( 36 ), i.[nLabAcceptedByUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nLabAcceptedByUID] <> i.[nLabAcceptedByUID] ) OR
                ( d.[nLabAcceptedByUID] IS NULL AND i.[nLabAcceptedByUID] IS NOT NULL ) OR
                ( i.[nLabAcceptedByUID] IS NULL AND d.[nLabAcceptedByUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTotal] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                760,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nTotal], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nTotal], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[nTotal] <> i.[nTotal] ) OR
                ( d.[nTotal] IS NULL AND i.[nTotal] IS NOT NULL ) OR
                ( i.[nTotal] IS NULL AND d.[nTotal] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAcceptedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                763,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAcceptedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAcceptedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[tAcceptedDate] <> i.[tAcceptedDate] ) OR
                ( d.[tAcceptedDate] IS NULL AND i.[tAcceptedDate] IS NOT NULL ) OR
                ( i.[tAcceptedDate] IS NULL AND d.[tAcceptedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                764,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tEndDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                765,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tEndDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tEndDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[tEndDate] <> i.[tEndDate] ) OR
                ( d.[tEndDate] IS NULL AND i.[tEndDate] IS NOT NULL ) OR
                ( i.[tEndDate] IS NULL AND d.[tEndDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tEstimateDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                766,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tEstimateDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tEstimateDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[tEstimateDate] <> i.[tEstimateDate] ) OR
                ( d.[tEstimateDate] IS NULL AND i.[tEstimateDate] IS NOT NULL ) OR
                ( i.[tEstimateDate] IS NULL AND d.[tEstimateDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tExpirationDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                767,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tExpirationDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tExpirationDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[tExpirationDate] <> i.[tExpirationDate] ) OR
                ( d.[tExpirationDate] IS NULL AND i.[tExpirationDate] IS NOT NULL ) OR
                ( i.[tExpirationDate] IS NULL AND d.[tExpirationDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tLabAcceptedDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                768,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tLabAcceptedDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tLabAcceptedDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[tLabAcceptedDate] <> i.[tLabAcceptedDate] ) OR
                ( d.[tLabAcceptedDate] IS NULL AND i.[tLabAcceptedDate] IS NOT NULL ) OR
                ( i.[tLabAcceptedDate] IS NULL AND d.[tLabAcceptedDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tStartDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nEstimateUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nEstimateUID], d.[nEstimateUID] )),
                770,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tStartDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tStartDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nEstimateUID] = i.[nEstimateUID] )
            WHERE
                ( d.[tStartDate] <> i.[tStartDate] ) OR
                ( d.[tStartDate] IS NULL AND i.[tStartDate] IS NOT NULL ) OR
                ( i.[tStartDate] IS NULL AND d.[tStartDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 25, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nEstimateUID FROM Inserted
            SELECT @Value = dbo.udf_GET_EstimatesAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Estimates_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Facilities_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Facilities_Ins] from [dbo].[Facilities]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Facilities_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Facilities_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Facilities_Ins] on [dbo].[Facilities]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Facilities_Ins] ON [dbo].[Facilities] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1691,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAccountNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1692,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cCompanyCode], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1693,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDistrict], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1694,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cDivision], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1695,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFacilityName], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1696,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFacilityNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1697,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFacilityType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1698,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFacilityWebSite], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1699,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFedNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1700,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cIndustryCode], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1701,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cTaxNumber], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1702,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1703,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1704,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1705,
            0,
            CONVERT(NVARCHAR, [lCustomer])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1706,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1707,
            0,
            CONVERT(NVARCHAR, [lHandHeldUse])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1708,
            0,
            CONVERT(NVARCHAR, [lInspectionRate])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1709,
            0,
            CONVERT(NVARCHAR, [lLab])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1710,
            0,
            CONVERT(NVARCHAR, [lManufacturer])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1711,
            0,
            CONVERT(NVARCHAR, [lNoRecall])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1712,
            0,
            CONVERT(NVARCHAR, [lNoTax])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1713,
            0,
            CONVERT(NVARCHAR, [lSubContractor])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1714,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1715,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1716,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1717,
            0,
            CONVERT(NVARCHAR( 36 ), [nCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1718,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1720,
            0,
            CONVERT(NVARCHAR( 36 ), [nParentFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1721,
            0,
            CONVERT( NVARCHAR( 41 ), [nRate1], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1722,
            0,
            CONVERT( NVARCHAR( 41 ), [nRate2], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1723,
            0,
            CONVERT( NVARCHAR( 41 ), [nRate3], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1724,
            0,
            CONVERT(NVARCHAR( 36 ), [nSubCategoryUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1725,
            0,
            CONVERT( NVARCHAR( 41 ), [nTaxRate], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUID]),
            1728,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 56, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nFacilityUID FROM Inserted
        SELECT @Value = dbo.udf_GET_FacilitiesAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Facilities_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Facilities_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Facilities_Upd] from [dbo].[Facilities]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Facilities_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Facilities_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Facilities_Upd] on [dbo].[Facilities]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Facilities_Upd] ON [dbo].[Facilities] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cAccountNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1691,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAccountNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAccountNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cAccountNumber], '''') <> NULLIF(i.[cAccountNumber], '''') ) OR
                ( NULLIF(d.[cAccountNumber], '''') IS NULL AND NULLIF(i.[cAccountNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAccountNumber], '''') IS NULL AND NULLIF(d.[cAccountNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cCompanyCode] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1692,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cCompanyCode], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cCompanyCode], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cCompanyCode], '''') <> NULLIF(i.[cCompanyCode], '''') ) OR
                ( NULLIF(d.[cCompanyCode], '''') IS NULL AND NULLIF(i.[cCompanyCode], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cCompanyCode], '''') IS NULL AND NULLIF(d.[cCompanyCode], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cDistrict] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1693,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cDistrict], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cDistrict], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cDistrict], '''') <> NULLIF(i.[cDistrict], '''') ) OR
                ( NULLIF(d.[cDistrict], '''') IS NULL AND NULLIF(i.[cDistrict], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cDistrict], '''') IS NULL AND NULLIF(d.[cDistrict], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cDivision] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1694,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cDivision], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cDivision], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cDivision], '''') <> NULLIF(i.[cDivision], '''') ) OR
                ( NULLIF(d.[cDivision], '''') IS NULL AND NULLIF(i.[cDivision], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cDivision], '''') IS NULL AND NULLIF(d.[cDivision], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFacilityName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1695,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFacilityName], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFacilityName], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cFacilityName], '''') <> NULLIF(i.[cFacilityName], '''') ) OR
                ( NULLIF(d.[cFacilityName], '''') IS NULL AND NULLIF(i.[cFacilityName], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFacilityName], '''') IS NULL AND NULLIF(d.[cFacilityName], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFacilityNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1696,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFacilityNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFacilityNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cFacilityNumber], '''') <> NULLIF(i.[cFacilityNumber], '''') ) OR
                ( NULLIF(d.[cFacilityNumber], '''') IS NULL AND NULLIF(i.[cFacilityNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFacilityNumber], '''') IS NULL AND NULLIF(d.[cFacilityNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFacilityType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1697,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFacilityType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFacilityType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cFacilityType], '''') <> NULLIF(i.[cFacilityType], '''') ) OR
                ( NULLIF(d.[cFacilityType], '''') IS NULL AND NULLIF(i.[cFacilityType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFacilityType], '''') IS NULL AND NULLIF(d.[cFacilityType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFacilityWebSite] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1698,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFacilityWebSite], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFacilityWebSite], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cFacilityWebSite], '''') <> NULLIF(i.[cFacilityWebSite], '''') ) OR
                ( NULLIF(d.[cFacilityWebSite], '''') IS NULL AND NULLIF(i.[cFacilityWebSite], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFacilityWebSite], '''') IS NULL AND NULLIF(d.[cFacilityWebSite], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFedNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1699,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFedNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFedNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cFedNumber], '''') <> NULLIF(i.[cFedNumber], '''') ) OR
                ( NULLIF(d.[cFedNumber], '''') IS NULL AND NULLIF(i.[cFedNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFedNumber], '''') IS NULL AND NULLIF(d.[cFedNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cIndustryCode] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1700,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cIndustryCode], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cIndustryCode], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cIndustryCode], '''') <> NULLIF(i.[cIndustryCode], '''') ) OR
                ( NULLIF(d.[cIndustryCode], '''') IS NULL AND NULLIF(i.[cIndustryCode], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cIndustryCode], '''') IS NULL AND NULLIF(d.[cIndustryCode], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cTaxNumber] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1701,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cTaxNumber], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cTaxNumber], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[cTaxNumber], '''') <> NULLIF(i.[cTaxNumber], '''') ) OR
                ( NULLIF(d.[cTaxNumber], '''') IS NULL AND NULLIF(i.[cTaxNumber], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cTaxNumber], '''') IS NULL AND NULLIF(d.[cTaxNumber], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1702,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1703,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1704,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lCustomer] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1705,
                0,
                CONVERT(NVARCHAR, d.[lCustomer]),
                CONVERT(NVARCHAR, i.[lCustomer])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lCustomer] <> i.[lCustomer] ) OR
                ( d.[lCustomer] IS NULL AND i.[lCustomer] IS NOT NULL ) OR
                ( i.[lCustomer] IS NULL AND d.[lCustomer] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1706,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lHandHeldUse] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1707,
                0,
                CONVERT(NVARCHAR, d.[lHandHeldUse]),
                CONVERT(NVARCHAR, i.[lHandHeldUse])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lHandHeldUse] <> i.[lHandHeldUse] ) OR
                ( d.[lHandHeldUse] IS NULL AND i.[lHandHeldUse] IS NOT NULL ) OR
                ( i.[lHandHeldUse] IS NULL AND d.[lHandHeldUse] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lInspectionRate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1708,
                0,
                CONVERT(NVARCHAR, d.[lInspectionRate]),
                CONVERT(NVARCHAR, i.[lInspectionRate])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lInspectionRate] <> i.[lInspectionRate] ) OR
                ( d.[lInspectionRate] IS NULL AND i.[lInspectionRate] IS NOT NULL ) OR
                ( i.[lInspectionRate] IS NULL AND d.[lInspectionRate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lLab] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1709,
                0,
                CONVERT(NVARCHAR, d.[lLab]),
                CONVERT(NVARCHAR, i.[lLab])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lLab] <> i.[lLab] ) OR
                ( d.[lLab] IS NULL AND i.[lLab] IS NOT NULL ) OR
                ( i.[lLab] IS NULL AND d.[lLab] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lManufacturer] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1710,
                0,
                CONVERT(NVARCHAR, d.[lManufacturer]),
                CONVERT(NVARCHAR, i.[lManufacturer])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lManufacturer] <> i.[lManufacturer] ) OR
                ( d.[lManufacturer] IS NULL AND i.[lManufacturer] IS NOT NULL ) OR
                ( i.[lManufacturer] IS NULL AND d.[lManufacturer] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lNoRecall] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1711,
                0,
                CONVERT(NVARCHAR, d.[lNoRecall]),
                CONVERT(NVARCHAR, i.[lNoRecall])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lNoRecall] <> i.[lNoRecall] ) OR
                ( d.[lNoRecall] IS NULL AND i.[lNoRecall] IS NOT NULL ) OR
                ( i.[lNoRecall] IS NULL AND d.[lNoRecall] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lNoTax] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1712,
                0,
                CONVERT(NVARCHAR, d.[lNoTax]),
                CONVERT(NVARCHAR, i.[lNoTax])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lNoTax] <> i.[lNoTax] ) OR
                ( d.[lNoTax] IS NULL AND i.[lNoTax] IS NOT NULL ) OR
                ( i.[lNoTax] IS NULL AND d.[lNoTax] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lSubContractor] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1713,
                0,
                CONVERT(NVARCHAR, d.[lSubContractor]),
                CONVERT(NVARCHAR, i.[lSubContractor])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[lSubContractor] <> i.[lSubContractor] ) OR
                ( d.[lSubContractor] IS NULL AND i.[lSubContractor] IS NOT NULL ) OR
                ( i.[lSubContractor] IS NULL AND d.[lSubContractor] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1714,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1715,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1716,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1717,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[nCategoryUID] <> i.[nCategoryUID] ) OR
                ( d.[nCategoryUID] IS NULL AND i.[nCategoryUID] IS NOT NULL ) OR
                ( i.[nCategoryUID] IS NULL AND d.[nCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1718,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[nFacilityUID] <> i.[nFacilityUID] ) OR
                ( d.[nFacilityUID] IS NULL AND i.[nFacilityUID] IS NOT NULL ) OR
                ( i.[nFacilityUID] IS NULL AND d.[nFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nParentFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1720,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nParentFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nParentFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[nParentFacilityUID] <> i.[nParentFacilityUID] ) OR
                ( d.[nParentFacilityUID] IS NULL AND i.[nParentFacilityUID] IS NOT NULL ) OR
                ( i.[nParentFacilityUID] IS NULL AND d.[nParentFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nRate1] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1721,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nRate1], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nRate1], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[nRate1] <> i.[nRate1] ) OR
                ( d.[nRate1] IS NULL AND i.[nRate1] IS NOT NULL ) OR
                ( i.[nRate1] IS NULL AND d.[nRate1] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nRate2] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1722,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nRate2], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nRate2], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[nRate2] <> i.[nRate2] ) OR
                ( d.[nRate2] IS NULL AND i.[nRate2] IS NOT NULL ) OR
                ( i.[nRate2] IS NULL AND d.[nRate2] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nRate3] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1723,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nRate3], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nRate3], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[nRate3] <> i.[nRate3] ) OR
                ( d.[nRate3] IS NULL AND i.[nRate3] IS NOT NULL ) OR
                ( i.[nRate3] IS NULL AND d.[nRate3] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nSubCategoryUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1724,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nSubCategoryUID]),
                CONVERT(NVARCHAR( 36 ), i.[nSubCategoryUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[nSubCategoryUID] <> i.[nSubCategoryUID] ) OR
                ( d.[nSubCategoryUID] IS NULL AND i.[nSubCategoryUID] IS NOT NULL ) OR
                ( i.[nSubCategoryUID] IS NULL AND d.[nSubCategoryUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTaxRate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1725,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nTaxRate], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nTaxRate], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[nTaxRate] <> i.[nTaxRate] ) OR
                ( d.[nTaxRate] IS NULL AND i.[nTaxRate] IS NOT NULL ) OR
                ( i.[nTaxRate] IS NULL AND d.[nTaxRate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUID], d.[nFacilityUID] )),
                1728,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUID] = i.[nFacilityUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 56, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nFacilityUID FROM Inserted
            SELECT @Value = dbo.udf_GET_FacilitiesAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Facilities_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_FacilityFiles_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_FacilityFiles_Ins] from [dbo].[FacilityFiles]'

    	DROP TRIGGER [dbo].[tr_kr_audit_FacilityFiles_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_FacilityFiles_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_FacilityFiles_Ins] on [dbo].[FacilityFiles]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_FacilityFiles_Ins] ON [dbo].[FacilityFiles] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2068,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2069,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2070,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2071,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2072,
            0,
            CONVERT(NVARCHAR, [lPrivate])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2073,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2074,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2075,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityFileUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2076,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2077,
            0,
            CONVERT(NVARCHAR( 36 ), [nFileUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), [nFacilityFileUID]),
            2081,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 62, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nFacilityFileUID FROM Inserted
        SELECT @Value = dbo.udf_GET_FacilityFilesAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_FacilityFiles_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_FacilityFiles_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_FacilityFiles_Upd] from [dbo].[FacilityFiles]'

    	DROP TRIGGER [dbo].[tr_kr_audit_FacilityFiles_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_FacilityFiles_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_FacilityFiles_Upd] on [dbo].[FacilityFiles]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_FacilityFiles_Upd] ON [dbo].[FacilityFiles] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )

        -- Populate audit detail records...
        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2068,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2069,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2070,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2071,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lPrivate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2072,
                0,
                CONVERT(NVARCHAR, d.[lPrivate]),
                CONVERT(NVARCHAR, i.[lPrivate])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[lPrivate] <> i.[lPrivate] ) OR
                ( d.[lPrivate] IS NULL AND i.[lPrivate] IS NOT NULL ) OR
                ( i.[lPrivate] IS NULL AND d.[lPrivate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2073,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2074,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityFileUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2075,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityFileUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityFileUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[nFacilityFileUID] <> i.[nFacilityFileUID] ) OR
                ( d.[nFacilityFileUID] IS NULL AND i.[nFacilityFileUID] IS NOT NULL ) OR
                ( i.[nFacilityFileUID] IS NULL AND d.[nFacilityFileUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2076,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[nFacilityUID] <> i.[nFacilityUID] ) OR
                ( d.[nFacilityUID] IS NULL AND i.[nFacilityUID] IS NOT NULL ) OR
                ( i.[nFacilityUID] IS NULL AND d.[nFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFileUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2077,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFileUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFileUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[nFileUID] <> i.[nFileUID] ) OR
                ( d.[nFileUID] IS NULL AND i.[nFileUID] IS NOT NULL ) OR
                ( i.[nFileUID] IS NULL AND d.[nFileUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityFileUID], d.[nFacilityFileUID] )),
                2081,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityFileUID] = i.[nFacilityFileUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 62, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nFacilityFileUID FROM Inserted
            SELECT @Value = dbo.udf_GET_FacilityFilesAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_FacilityFiles_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_FacilityUserLink_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_FacilityUserLink_Ins] from [dbo].[FacilityUserLink]'

    	DROP TRIGGER [dbo].[tr_kr_audit_FacilityUserLink_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_FacilityUserLink_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_FacilityUserLink_Ins] on [dbo].[FacilityUserLink]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_FacilityUserLink_Ins] ON [dbo].[FacilityUserLink] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            881,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            882,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            883,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            884,
            0,
            CONVERT(NVARCHAR, [lDefault])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            885,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            886,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            887,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            888,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            889,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUserLinkUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            893,
            0,
            CONVERT(NVARCHAR( 36 ), [nUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), [nFacilityUserLinkUID]),
            894,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 29, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nFacilityUserLinkUID FROM Inserted
        SELECT @Value = dbo.udf_GET_FacilityUserLinkAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_FacilityUserLink_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_FacilityUserLink_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_FacilityUserLink_Upd] from [dbo].[FacilityUserLink]'

    	DROP TRIGGER [dbo].[tr_kr_audit_FacilityUserLink_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_FacilityUserLink_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_FacilityUserLink_Upd] on [dbo].[FacilityUserLink]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_FacilityUserLink_Upd] ON [dbo].[FacilityUserLink] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )

        -- Populate audit detail records...
        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                881,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                882,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                883,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDefault] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                884,
                0,
                CONVERT(NVARCHAR, d.[lDefault]),
                CONVERT(NVARCHAR, i.[lDefault])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[lDefault] <> i.[lDefault] ) OR
                ( d.[lDefault] IS NULL AND i.[lDefault] IS NOT NULL ) OR
                ( i.[lDefault] IS NULL AND d.[lDefault] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                885,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                886,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                887,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                888,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[nFacilityUID] <> i.[nFacilityUID] ) OR
                ( d.[nFacilityUID] IS NULL AND i.[nFacilityUID] IS NOT NULL ) OR
                ( i.[nFacilityUID] IS NULL AND d.[nFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityUserLinkUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                889,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUserLinkUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUserLinkUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[nFacilityUserLinkUID] <> i.[nFacilityUserLinkUID] ) OR
                ( d.[nFacilityUserLinkUID] IS NULL AND i.[nFacilityUserLinkUID] IS NOT NULL ) OR
                ( i.[nFacilityUserLinkUID] IS NULL AND d.[nFacilityUserLinkUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                893,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[nUserUID] <> i.[nUserUID] ) OR
                ( d.[nUserUID] IS NULL AND i.[nUserUID] IS NOT NULL ) OR
                ( i.[nUserUID] IS NULL AND d.[nUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFacilityUserLinkUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFacilityUserLinkUID], d.[nFacilityUserLinkUID] )),
                894,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFacilityUserLinkUID] = i.[nFacilityUserLinkUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 29, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nFacilityUserLinkUID FROM Inserted
            SELECT @Value = dbo.udf_GET_FacilityUserLinkAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_FacilityUserLink_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Files_Ins] from [dbo].[Files]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Files_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Files_Ins] on [dbo].[Files]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Files_Ins] ON [dbo].[Files] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            898,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAuthority], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            899,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFileName], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            900,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFilePath], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            901,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFileType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            2925,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cMd5], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            902,
            0,
            CONVERT( NVARCHAR(max), [iFile] )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            903,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            904,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            905,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            906,
            0,
            CONVERT(NVARCHAR, [lCheckedOut])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            907,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            3053,
            0,
            CONVERT(NVARCHAR, [lUrl])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            908,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            909,
            0,
            CONVERT(NVARCHAR, [nAccessLevel])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            910,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            911,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            3054,
            0,
            CONVERT(NVARCHAR( 36 ), [nCallSheetAttributeUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            912,
            0,
            CONVERT(NVARCHAR( 36 ), [nFileUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            914,
            0,
            CONVERT(NVARCHAR( 36 ), [nManualTemplateUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nFileUID='' + CONVERT(VARCHAR( 36 ), [nFileUID]),
            917,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 30, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nFileUID FROM Inserted
        SELECT @Value = dbo.udf_GET_FilesAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Files_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Files_Upd] from [dbo].[Files]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Files_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Files_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Files_Upd] on [dbo].[Files]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Files_Upd] ON [dbo].[Files] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nFileUID] = i.[nFileUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cAuthority] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                898,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAuthority], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAuthority], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[cAuthority], '''') <> NULLIF(i.[cAuthority], '''') ) OR
                ( NULLIF(d.[cAuthority], '''') IS NULL AND NULLIF(i.[cAuthority], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAuthority], '''') IS NULL AND NULLIF(d.[cAuthority], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFileName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                899,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFileName], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFileName], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[cFileName], '''') <> NULLIF(i.[cFileName], '''') ) OR
                ( NULLIF(d.[cFileName], '''') IS NULL AND NULLIF(i.[cFileName], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFileName], '''') IS NULL AND NULLIF(d.[cFileName], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFilePath] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                900,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFilePath], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFilePath], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[cFilePath], '''') <> NULLIF(i.[cFilePath], '''') ) OR
                ( NULLIF(d.[cFilePath], '''') IS NULL AND NULLIF(i.[cFilePath], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFilePath], '''') IS NULL AND NULLIF(d.[cFilePath], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFileType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                901,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFileType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFileType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[cFileType], '''') <> NULLIF(i.[cFileType], '''') ) OR
                ( NULLIF(d.[cFileType], '''') IS NULL AND NULLIF(i.[cFileType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFileType], '''') IS NULL AND NULLIF(d.[cFileType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cMd5] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                2925,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cMd5], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cMd5], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[cMd5], '''') <> NULLIF(i.[cMd5], '''') ) OR
                ( NULLIF(d.[cMd5], '''') IS NULL AND NULLIF(i.[cMd5], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cMd5], '''') IS NULL AND NULLIF(d.[cMd5], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [iFile] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                902,
                0,
                CONVERT( NVARCHAR(max), d.[iFile] ),
                CONVERT( NVARCHAR(max), i.[iFile] )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[iFile] <> i.[iFile] ) OR
                ( d.[iFile] IS NULL AND i.[iFile] IS NOT NULL ) OR
                ( i.[iFile] IS NULL AND d.[iFile] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                903,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                904,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                905,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lCheckedOut] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                906,
                0,
                CONVERT(NVARCHAR, d.[lCheckedOut]),
                CONVERT(NVARCHAR, i.[lCheckedOut])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lCheckedOut] <> i.[lCheckedOut] ) OR
                ( d.[lCheckedOut] IS NULL AND i.[lCheckedOut] IS NOT NULL ) OR
                ( i.[lCheckedOut] IS NULL AND d.[lCheckedOut] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                907,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lUrl] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                3053,
                0,
                CONVERT(NVARCHAR, d.[lUrl]),
                CONVERT(NVARCHAR, i.[lUrl])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[lUrl] <> i.[lUrl] ) OR
                ( d.[lUrl] IS NULL AND i.[lUrl] IS NOT NULL ) OR
                ( i.[lUrl] IS NULL AND d.[lUrl] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                908,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAccessLevel] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                909,
                0,
                CONVERT(NVARCHAR, d.[nAccessLevel]),
                CONVERT(NVARCHAR, i.[nAccessLevel])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nAccessLevel] <> i.[nAccessLevel] ) OR
                ( d.[nAccessLevel] IS NULL AND i.[nAccessLevel] IS NOT NULL ) OR
                ( i.[nAccessLevel] IS NULL AND d.[nAccessLevel] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                910,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                911,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nCallSheetAttributeUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                3054,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nCallSheetAttributeUID]),
                CONVERT(NVARCHAR( 36 ), i.[nCallSheetAttributeUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nCallSheetAttributeUID] <> i.[nCallSheetAttributeUID] ) OR
                ( d.[nCallSheetAttributeUID] IS NULL AND i.[nCallSheetAttributeUID] IS NOT NULL ) OR
                ( i.[nCallSheetAttributeUID] IS NULL AND d.[nCallSheetAttributeUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFileUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                912,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFileUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFileUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nFileUID] <> i.[nFileUID] ) OR
                ( d.[nFileUID] IS NULL AND i.[nFileUID] IS NOT NULL ) OR
                ( i.[nFileUID] IS NULL AND d.[nFileUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nManualTemplateUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                914,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nManualTemplateUID]),
                CONVERT(NVARCHAR( 36 ), i.[nManualTemplateUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[nManualTemplateUID] <> i.[nManualTemplateUID] ) OR
                ( d.[nManualTemplateUID] IS NULL AND i.[nManualTemplateUID] IS NOT NULL ) OR
                ( i.[nManualTemplateUID] IS NULL AND d.[nManualTemplateUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nFileUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nFileUID], d.[nFileUID] )),
                917,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nFileUID] = i.[nFileUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 30, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nFileUID FROM Inserted
            SELECT @Value = dbo.udf_GET_FilesAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Files_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Imports_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Imports_Ins] from [dbo].[Imports]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Imports_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Imports_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Imports_Ins] on [dbo].[Imports]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Imports_Ins] ON [dbo].[Imports] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nImportUID='' + CONVERT(VARCHAR( 36 ), [nImportUID]),
            969,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFileName], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nImportUID='' + CONVERT(VARCHAR( 36 ), [nImportUID]),
            970,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nImportUID='' + CONVERT(VARCHAR( 36 ), [nImportUID]),
            971,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nImportUID='' + CONVERT(VARCHAR( 36 ), [nImportUID]),
            972,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nImportUID='' + CONVERT(VARCHAR( 36 ), [nImportUID]),
            973,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nImportUID='' + CONVERT(VARCHAR( 36 ), [nImportUID]),
            974,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nImportUID='' + CONVERT(VARCHAR( 36 ), [nImportUID]),
            975,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nImportUID='' + CONVERT(VARCHAR( 36 ), [nImportUID]),
            976,
            0,
            CONVERT(NVARCHAR( 36 ), [nImportSetupUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nImportUID='' + CONVERT(VARCHAR( 36 ), [nImportUID]),
            981,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nImportUID='' + CONVERT(VARCHAR( 36 ), [nImportUID]),
            983,
            0,
            CONVERT( NVARCHAR( 34 ), [tRunDateTime], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 34, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nImportUID FROM Inserted
        SELECT @Value = dbo.udf_GET_ImportsAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Imports_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Imports_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Imports_Upd] from [dbo].[Imports]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Imports_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Imports_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Imports_Upd] on [dbo].[Imports]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Imports_Upd] ON [dbo].[Imports] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nImportUID] = i.[nImportUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cFileName] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nImportUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nImportUID], d.[nImportUID] )),
                969,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFileName], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFileName], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nImportUID] = i.[nImportUID] )
            WHERE
                ( NULLIF(d.[cFileName], '''') <> NULLIF(i.[cFileName], '''') ) OR
                ( NULLIF(d.[cFileName], '''') IS NULL AND NULLIF(i.[cFileName], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFileName], '''') IS NULL AND NULLIF(d.[cFileName], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nImportUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nImportUID], d.[nImportUID] )),
                970,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nImportUID] = i.[nImportUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nImportUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nImportUID], d.[nImportUID] )),
                971,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nImportUID] = i.[nImportUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nImportUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nImportUID], d.[nImportUID] )),
                972,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nImportUID] = i.[nImportUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nImportUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nImportUID], d.[nImportUID] )),
                973,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nImportUID] = i.[nImportUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nImportUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nImportUID], d.[nImportUID] )),
                974,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nImportUID] = i.[nImportUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nImportUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nImportUID], d.[nImportUID] )),
                975,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nImportUID] = i.[nImportUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nImportSetupUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nImportUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nImportUID], d.[nImportUID] )),
                976,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nImportSetupUID]),
                CONVERT(NVARCHAR( 36 ), i.[nImportSetupUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nImportUID] = i.[nImportUID] )
            WHERE
                ( d.[nImportSetupUID] <> i.[nImportSetupUID] ) OR
                ( d.[nImportSetupUID] IS NULL AND i.[nImportSetupUID] IS NOT NULL ) OR
                ( i.[nImportSetupUID] IS NULL AND d.[nImportSetupUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nImportUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nImportUID], d.[nImportUID] )),
                981,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nImportUID] = i.[nImportUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tRunDateTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nImportUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nImportUID], d.[nImportUID] )),
                983,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tRunDateTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tRunDateTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nImportUID] = i.[nImportUID] )
            WHERE
                ( d.[tRunDateTime] <> i.[tRunDateTime] ) OR
                ( d.[tRunDateTime] IS NULL AND i.[tRunDateTime] IS NOT NULL ) OR
                ( i.[tRunDateTime] IS NULL AND d.[tRunDateTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 34, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nImportUID FROM Inserted
            SELECT @Value = dbo.udf_GET_ImportsAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Imports_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Invoices_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Invoices_Ins] from [dbo].[Invoices]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Invoices_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Invoices_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Invoices_Ins] on [dbo].[Invoices]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Invoices_Ins] ON [dbo].[Invoices] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN


        -- Populate audit detail records...
        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1058,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cAccountType], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1059,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cFOB], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1060,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cInvoiceNo], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1061,
            0,
            CONVERT( NVARCHAR(max), NULLIF([cStatus], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1062,
            0,
            CONVERT(NVARCHAR, [lActive])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1063,
            0,
            CONVERT(NVARCHAR, [lAdded])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1064,
            0,
            CONVERT(NVARCHAR, [lApproved])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1065,
            0,
            CONVERT(NVARCHAR, [lBilled])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1066,
            0,
            CONVERT(NVARCHAR, [lClosed])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1067,
            0,
            CONVERT(NVARCHAR, [lDeleted])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1068,
            0,
            CONVERT( NVARCHAR(max), NULLIF([mNotes], '''') )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1069,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1070,
            0,
            CONVERT(NVARCHAR( 36 ), [nAddUserUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1071,
            0,
            CONVERT( NVARCHAR( 41 ), [nBalance], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1072,
            0,
            CONVERT( NVARCHAR( 41 ), [nDiscount], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1073,
            0,
            CONVERT( NVARCHAR( 41 ), [nDiscountAmount], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1074,
            0,
            CONVERT(NVARCHAR( 36 ), [nFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1075,
            0,
            CONVERT( NVARCHAR( 41 ), [nHandlingCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1077,
            0,
            CONVERT( NVARCHAR( 41 ), [nInvoiceAmount], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1078,
            0,
            CONVERT(NVARCHAR( 36 ), [nInvoiceUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1079,
            0,
            CONVERT(NVARCHAR( 36 ), [nJobNumberUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1080,
            0,
            CONVERT( NVARCHAR( 41 ), [nPaidAmount], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1081,
            0,
            CONVERT(NVARCHAR( 36 ), [nShipmentUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1082,
            0,
            CONVERT( NVARCHAR( 41 ), [nShippingCost], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1083,
            0,
            CONVERT(NVARCHAR( 36 ), [nShipToUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1084,
            0,
            CONVERT( NVARCHAR( 41 ), [nTaxAmount], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1085,
            0,
            CONVERT( NVARCHAR( 41 ), [nTaxRate], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1088,
            0,
            CONVERT( NVARCHAR( 41 ), [nVATAmount], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1089,
            0,
            CONVERT( NVARCHAR( 41 ), [nVATRate], 2 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1090,
            0,
            CONVERT(NVARCHAR( 36 ), [nWorkingFacilityUID])
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1091,
            0,
            CONVERT( NVARCHAR( 34 ), [tAddTime], 121 )
        FROM
            INSERTED

        INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, NewValue )
        SELECT
            @AuditID,
            ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), [nInvoiceUID]),
            1092,
            0,
            CONVERT( NVARCHAR( 34 ), [tInvoiceDate], 121 )
        FROM
            INSERTED


        DECLARE @nAddUserUID [UNIQUEIDENTIFIER],
        		@nAddFacilityUID [UNIQUEIDENTIFIER]
        SELECT
        	@nAddUserUID = nAddUserUID ,
        	@nAddFacilityUID = nAddFacilityUID
        FROM
        	INSERTED

        EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 38, @RowsAffected, ''I'', @AuditedUser, @nAddUserUID, @nAddFacilityUID, NULL, NULL

        DECLARE @nRecordUID [UNIQUEIDENTIFIER]
        DECLARE @Value NVARCHAR(4000)
        SELECT @nRecordUID = nInvoiceUID FROM Inserted
        SELECT @Value = dbo.udf_GET_InvoicesAuditDisplay(@nRecordUID)

        EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Invoices_Ins]', 'last', 'insert', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Invoices_Upd]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_Invoices_Upd] from [dbo].[Invoices]'

    	DROP TRIGGER [dbo].[tr_kr_audit_Invoices_Upd]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_Invoices_Upd]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_Invoices_Upd] on [dbo].[Invoices]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_Invoices_Upd] ON [dbo].[Invoices] FOR UPDATE NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID uniqueidentifier, @ChangeCount INT, @CaptureCount INT
    SELECT @RowsAffected = COUNT(*) FROM INSERTED


    IF( @RowsAffected > 0 )
    BEGIN

        SELECT @AuditedUser = NULL

        EXEC @ValidRun = dbo.pr_kr_AuditLogHeader ''2E5EADD1-3700-4C43-87C0-E790554B3E46'', @AuditID OUTPUT
        IF( @ValidRun <> 0 )
            RETURN

        SELECT @CaptureCount = 0

        -- Test for a key update...
        SELECT
            @ChangeCount = COUNT(*)
        FROM
            INSERTED i
        FULL OUTER JOIN
            DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )

        -- Populate audit detail records...
        IF( UPDATE( [cAccountType] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1058,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cAccountType], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cAccountType], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( NULLIF(d.[cAccountType], '''') <> NULLIF(i.[cAccountType], '''') ) OR
                ( NULLIF(d.[cAccountType], '''') IS NULL AND NULLIF(i.[cAccountType], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cAccountType], '''') IS NULL AND NULLIF(d.[cAccountType], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cFOB] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1059,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cFOB], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cFOB], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( NULLIF(d.[cFOB], '''') <> NULLIF(i.[cFOB], '''') ) OR
                ( NULLIF(d.[cFOB], '''') IS NULL AND NULLIF(i.[cFOB], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cFOB], '''') IS NULL AND NULLIF(d.[cFOB], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cInvoiceNo] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1060,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cInvoiceNo], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cInvoiceNo], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( NULLIF(d.[cInvoiceNo], '''') <> NULLIF(i.[cInvoiceNo], '''') ) OR
                ( NULLIF(d.[cInvoiceNo], '''') IS NULL AND NULLIF(i.[cInvoiceNo], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cInvoiceNo], '''') IS NULL AND NULLIF(d.[cInvoiceNo], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [cStatus] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1061,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[cStatus], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[cStatus], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( NULLIF(d.[cStatus], '''') <> NULLIF(i.[cStatus], '''') ) OR
                ( NULLIF(d.[cStatus], '''') IS NULL AND NULLIF(i.[cStatus], '''') IS NOT NULL ) OR
                ( NULLIF(i.[cStatus], '''') IS NULL AND NULLIF(d.[cStatus], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lActive] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1062,
                0,
                CONVERT(NVARCHAR, d.[lActive]),
                CONVERT(NVARCHAR, i.[lActive])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[lActive] <> i.[lActive] ) OR
                ( d.[lActive] IS NULL AND i.[lActive] IS NOT NULL ) OR
                ( i.[lActive] IS NULL AND d.[lActive] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lAdded] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1063,
                0,
                CONVERT(NVARCHAR, d.[lAdded]),
                CONVERT(NVARCHAR, i.[lAdded])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[lAdded] <> i.[lAdded] ) OR
                ( d.[lAdded] IS NULL AND i.[lAdded] IS NOT NULL ) OR
                ( i.[lAdded] IS NULL AND d.[lAdded] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lApproved] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1064,
                0,
                CONVERT(NVARCHAR, d.[lApproved]),
                CONVERT(NVARCHAR, i.[lApproved])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[lApproved] <> i.[lApproved] ) OR
                ( d.[lApproved] IS NULL AND i.[lApproved] IS NOT NULL ) OR
                ( i.[lApproved] IS NULL AND d.[lApproved] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lBilled] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1065,
                0,
                CONVERT(NVARCHAR, d.[lBilled]),
                CONVERT(NVARCHAR, i.[lBilled])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[lBilled] <> i.[lBilled] ) OR
                ( d.[lBilled] IS NULL AND i.[lBilled] IS NOT NULL ) OR
                ( i.[lBilled] IS NULL AND d.[lBilled] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lClosed] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1066,
                0,
                CONVERT(NVARCHAR, d.[lClosed]),
                CONVERT(NVARCHAR, i.[lClosed])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[lClosed] <> i.[lClosed] ) OR
                ( d.[lClosed] IS NULL AND i.[lClosed] IS NOT NULL ) OR
                ( i.[lClosed] IS NULL AND d.[lClosed] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [lDeleted] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1067,
                0,
                CONVERT(NVARCHAR, d.[lDeleted]),
                CONVERT(NVARCHAR, i.[lDeleted])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[lDeleted] <> i.[lDeleted] ) OR
                ( d.[lDeleted] IS NULL AND i.[lDeleted] IS NOT NULL ) OR
                ( i.[lDeleted] IS NULL AND d.[lDeleted] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [mNotes] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1068,
                0,
                CONVERT( NVARCHAR(max), NULLIF(d.[mNotes], '''') ),
                CONVERT( NVARCHAR(max), NULLIF(i.[mNotes], '''') )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( NULLIF(d.[mNotes], '''') <> NULLIF(i.[mNotes], '''') ) OR
                ( NULLIF(d.[mNotes], '''') IS NULL AND NULLIF(i.[mNotes], '''') IS NOT NULL ) OR
                ( NULLIF(i.[mNotes], '''') IS NULL AND NULLIF(d.[mNotes], '''') IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1069,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nAddFacilityUID] <> i.[nAddFacilityUID] ) OR
                ( d.[nAddFacilityUID] IS NULL AND i.[nAddFacilityUID] IS NOT NULL ) OR
                ( i.[nAddFacilityUID] IS NULL AND d.[nAddFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nAddUserUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1070,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nAddUserUID]),
                CONVERT(NVARCHAR( 36 ), i.[nAddUserUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nAddUserUID] <> i.[nAddUserUID] ) OR
                ( d.[nAddUserUID] IS NULL AND i.[nAddUserUID] IS NOT NULL ) OR
                ( i.[nAddUserUID] IS NULL AND d.[nAddUserUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nBalance] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1071,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nBalance], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nBalance], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nBalance] <> i.[nBalance] ) OR
                ( d.[nBalance] IS NULL AND i.[nBalance] IS NOT NULL ) OR
                ( i.[nBalance] IS NULL AND d.[nBalance] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nDiscount] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1072,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nDiscount], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nDiscount], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nDiscount] <> i.[nDiscount] ) OR
                ( d.[nDiscount] IS NULL AND i.[nDiscount] IS NOT NULL ) OR
                ( i.[nDiscount] IS NULL AND d.[nDiscount] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nDiscountAmount] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1073,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nDiscountAmount], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nDiscountAmount], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nDiscountAmount] <> i.[nDiscountAmount] ) OR
                ( d.[nDiscountAmount] IS NULL AND i.[nDiscountAmount] IS NOT NULL ) OR
                ( i.[nDiscountAmount] IS NULL AND d.[nDiscountAmount] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1074,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nFacilityUID] <> i.[nFacilityUID] ) OR
                ( d.[nFacilityUID] IS NULL AND i.[nFacilityUID] IS NOT NULL ) OR
                ( i.[nFacilityUID] IS NULL AND d.[nFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nHandlingCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1075,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nHandlingCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nHandlingCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nHandlingCost] <> i.[nHandlingCost] ) OR
                ( d.[nHandlingCost] IS NULL AND i.[nHandlingCost] IS NOT NULL ) OR
                ( i.[nHandlingCost] IS NULL AND d.[nHandlingCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nInvoiceAmount] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1077,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nInvoiceAmount], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nInvoiceAmount], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nInvoiceAmount] <> i.[nInvoiceAmount] ) OR
                ( d.[nInvoiceAmount] IS NULL AND i.[nInvoiceAmount] IS NOT NULL ) OR
                ( i.[nInvoiceAmount] IS NULL AND d.[nInvoiceAmount] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nInvoiceUID] ) )
        BEGIN
        -- Audit key column updates...
        IF( @ChangeCount > @RowsAffected )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1078,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nInvoiceUID]),
                CONVERT(NVARCHAR( 36 ), i.[nInvoiceUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nInvoiceUID] <> i.[nInvoiceUID] ) OR
                ( d.[nInvoiceUID] IS NULL AND i.[nInvoiceUID] IS NOT NULL ) OR
                ( i.[nInvoiceUID] IS NULL AND d.[nInvoiceUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END
        END

        IF( UPDATE( [nJobNumberUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1079,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nJobNumberUID]),
                CONVERT(NVARCHAR( 36 ), i.[nJobNumberUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nJobNumberUID] <> i.[nJobNumberUID] ) OR
                ( d.[nJobNumberUID] IS NULL AND i.[nJobNumberUID] IS NOT NULL ) OR
                ( i.[nJobNumberUID] IS NULL AND d.[nJobNumberUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nPaidAmount] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1080,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nPaidAmount], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nPaidAmount], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nPaidAmount] <> i.[nPaidAmount] ) OR
                ( d.[nPaidAmount] IS NULL AND i.[nPaidAmount] IS NOT NULL ) OR
                ( i.[nPaidAmount] IS NULL AND d.[nPaidAmount] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nShipmentUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1081,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nShipmentUID]),
                CONVERT(NVARCHAR( 36 ), i.[nShipmentUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nShipmentUID] <> i.[nShipmentUID] ) OR
                ( d.[nShipmentUID] IS NULL AND i.[nShipmentUID] IS NOT NULL ) OR
                ( i.[nShipmentUID] IS NULL AND d.[nShipmentUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nShippingCost] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1082,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nShippingCost], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nShippingCost], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nShippingCost] <> i.[nShippingCost] ) OR
                ( d.[nShippingCost] IS NULL AND i.[nShippingCost] IS NOT NULL ) OR
                ( i.[nShippingCost] IS NULL AND d.[nShippingCost] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nShipToUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1083,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nShipToUID]),
                CONVERT(NVARCHAR( 36 ), i.[nShipToUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nShipToUID] <> i.[nShipToUID] ) OR
                ( d.[nShipToUID] IS NULL AND i.[nShipToUID] IS NOT NULL ) OR
                ( i.[nShipToUID] IS NULL AND d.[nShipToUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTaxAmount] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1084,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nTaxAmount], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nTaxAmount], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nTaxAmount] <> i.[nTaxAmount] ) OR
                ( d.[nTaxAmount] IS NULL AND i.[nTaxAmount] IS NOT NULL ) OR
                ( i.[nTaxAmount] IS NULL AND d.[nTaxAmount] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nTaxRate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1085,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nTaxRate], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nTaxRate], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nTaxRate] <> i.[nTaxRate] ) OR
                ( d.[nTaxRate] IS NULL AND i.[nTaxRate] IS NOT NULL ) OR
                ( i.[nTaxRate] IS NULL AND d.[nTaxRate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nVATAmount] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1088,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nVATAmount], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nVATAmount], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nVATAmount] <> i.[nVATAmount] ) OR
                ( d.[nVATAmount] IS NULL AND i.[nVATAmount] IS NOT NULL ) OR
                ( i.[nVATAmount] IS NULL AND d.[nVATAmount] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nVATRate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1089,
                0,
                CONVERT( NVARCHAR( 41 ), d.[nVATRate], 2 ),
                CONVERT( NVARCHAR( 41 ), i.[nVATRate], 2 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nVATRate] <> i.[nVATRate] ) OR
                ( d.[nVATRate] IS NULL AND i.[nVATRate] IS NOT NULL ) OR
                ( i.[nVATRate] IS NULL AND d.[nVATRate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [nWorkingFacilityUID] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1090,
                0,
                CONVERT(NVARCHAR( 36 ), d.[nWorkingFacilityUID]),
                CONVERT(NVARCHAR( 36 ), i.[nWorkingFacilityUID])
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[nWorkingFacilityUID] <> i.[nWorkingFacilityUID] ) OR
                ( d.[nWorkingFacilityUID] IS NULL AND i.[nWorkingFacilityUID] IS NOT NULL ) OR
                ( i.[nWorkingFacilityUID] IS NULL AND d.[nWorkingFacilityUID] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tAddTime] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1091,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tAddTime], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tAddTime], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[tAddTime] <> i.[tAddTime] ) OR
                ( d.[tAddTime] IS NULL AND i.[tAddTime] IS NOT NULL ) OR
                ( i.[tAddTime] IS NULL AND d.[tAddTime] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END

        IF( UPDATE( [tInvoiceDate] ) )
        BEGIN
            INSERT dbo.AuditLogDetail( AuditLogID, RowKey, ColumnID, Status, OldValue, NewValue )
            SELECT
                @AuditID,
                ''nInvoiceUID='' + CONVERT(VARCHAR( 36 ), ISNULL( i.[nInvoiceUID], d.[nInvoiceUID] )),
                1092,
                0,
                CONVERT( NVARCHAR( 34 ), d.[tInvoiceDate], 121 ),
                CONVERT( NVARCHAR( 34 ), i.[tInvoiceDate], 121 )
            FROM
                INSERTED i
                FULL OUTER JOIN DELETED d ON ( d.[nInvoiceUID] = i.[nInvoiceUID] )
            WHERE
                ( d.[tInvoiceDate] <> i.[tInvoiceDate] ) OR
                ( d.[tInvoiceDate] IS NULL AND i.[tInvoiceDate] IS NOT NULL ) OR
                ( i.[tInvoiceDate] IS NULL AND d.[tInvoiceDate] IS NOT NULL )

            SELECT @CaptureCount = @CaptureCount + @@RowCount
        END


        IF( @CaptureCount > 0 )
        BEGIN

            DECLARE @nUpdateUserUID [UNIQUEIDENTIFIER],
                    @nUpdateFacilityUID [UNIQUEIDENTIFIER]
            SELECT
                @nUpdateUserUID = nUpdateUserUID,
                @nUpdateFacilityUID = nUpdateFacilityUID
            FROM
                INSERTED

            EXEC dbo.pr_kr_AuditLogTrailer @AuditID, 38, @RowsAffected, ''U'', @AuditedUser, NULL, NULL, @nUpdateUserUID, @nUpdateFacilityUID

            DECLARE @nRecordUID [UNIQUEIDENTIFIER]
            DECLARE @Value NVARCHAR(4000)
            SELECT @nRecordUID = nInvoiceUID FROM Inserted
            SELECT @Value = dbo.udf_GET_InvoicesAuditDisplay(@nRecordUID)

            EXEC dbo.spl_CacheAuditDisplay @RecordUID = @nRecordUID, @DisplayValue = @Value
        END
    END
END
'

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END


        EXEC sp_settriggerorder N'[dbo].[tr_kr_audit_Invoices_Upd]', 'last', 'update', null

        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END

    END



    IF OBJECT_ID(N'[dbo].[tr_kr_audit_JobNumbers_Ins]', 'TR') IS NOT NULL
    BEGIN
    	PRINT N'Dropping trigger [dbo].[tr_kr_audit_JobNumbers_Ins] from [dbo].[JobNumbers]'

    	DROP TRIGGER [dbo].[tr_kr_audit_JobNumbers_Ins]


        IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION

        IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
    END


    IF OBJECT_ID(N'[dbo].[tr_kr_audit_JobNumbers_Ins]', 'TR') IS NULL
    BEGIN
        PRINT N'Creating trigger [dbo].[tr_kr_audit_JobNumbers_Ins] on [dbo].[JobNumbers]'

        EXEC sp_executesql N'
CREATE TRIGGER [dbo].[tr_kr_audit_JobNumbers_Ins] ON [dbo].[JobNumbers] FOR INSERT NOT FOR REPLICATION AS
BEGIN

    -- OmniAudit 1.14.0.495
    -- Generated: 20230125 22:36:26

    SET NOCOUNT ON

    DECLARE @ValidRun INT, @RowsAffected INT, @PreExistingID INT, @MaxID INT, @AuditedUser sysname, @AuditID u